// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
package net.sourceforge.plantuml.dot;

import java.io.File;

public enum ExeState {
	// ::remove file when __CORE__

	NULL_UNDEFINED, OK, DOES_NOT_EXIST, IS_A_DIRECTORY, NOT_A_FILE, CANNOT_BE_READ;

	public static ExeState checkFile(File dotExe) {
		if (dotExe == null)
			return NULL_UNDEFINED;
		else if (dotExe.exists() == false)
			return DOES_NOT_EXIST;
		else if (dotExe.isDirectory())
			return IS_A_DIRECTORY;
		else if (dotExe.isFile() == false)
			return NOT_A_FILE;
		else if (dotExe.canRead() == false)
			return CANNOT_BE_READ;

		return OK;
	}

	public String getTextMessage() {
		switch (this) {
		case OK:
			return "Dot executable OK";
		case NULL_UNDEFINED:
			return "No dot executable found";
		case DOES_NOT_EXIST:
			return "Dot executable does not exist";
		case IS_A_DIRECTORY:
			return "Dot executable should be an executable, not a directory";
		case NOT_A_FILE:
			return "Dot executable is not a valid file";
		case CANNOT_BE_READ:
			return "Dot executable cannot be read";
		}
		throw new IllegalStateException();
	}

	public String getTextMessage(File exe) {
		switch (this) {
		case OK:
			return "File " + exe.getAbsolutePath() + " OK";
		case NULL_UNDEFINED:
			return NULL_UNDEFINED.getTextMessage();
		case DOES_NOT_EXIST:
			return "File " + exe.getAbsolutePath() + " does not exist";
		case IS_A_DIRECTORY:
			return "File " + exe.getAbsolutePath() + " should be an executable, not a directory";
		case NOT_A_FILE:
			return "File " + exe.getAbsolutePath() + " is not a valid file";
		case CANNOT_BE_READ:
			return "File " + exe.getAbsolutePath() + " cannot be read";
		}
		throw new IllegalStateException();
	}

}
