// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
package net.sourceforge.plantuml.klimt.drawing.tikz;

import net.sourceforge.plantuml.klimt.UParam;
import net.sourceforge.plantuml.klimt.color.ColorMapper;
import net.sourceforge.plantuml.klimt.drawing.UDriver;
import net.sourceforge.plantuml.klimt.shape.UImage;
import net.sourceforge.plantuml.tikz.TikzGraphics;

public class DriverImageTikz implements UDriver<UImage, TikzGraphics> {

	public void draw(UImage shape, double x, double y, ColorMapper mapper, UParam param, TikzGraphics tikz) {
		final String rawFileName = shape.getRawFileName();
		if (rawFileName != null) {
			final double scale = shape.getScale();
			final String raw;
			if (scale == 1)
				raw = "\\includegraphics{" + rawFileName + "}";
			else
				raw = "\\includegraphics[scale=" + TikzGraphics.format(scale) + "]{" + rawFileName + "}";
			tikz.appendRaw(x, y, raw);
			return;
		}
		final String formula = shape.getFormula();
		if (formula != null) {
			tikz.appendRaw(x, y, formula);
		}
	}
}
