// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
package net.sourceforge.plantuml.klimt.drawing.tikz;

import net.sourceforge.plantuml.klimt.UParam;
import net.sourceforge.plantuml.klimt.color.ColorMapper;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.color.HColorGradient;
import net.sourceforge.plantuml.klimt.drawing.UDriver;
import net.sourceforge.plantuml.klimt.shape.URectangle;
import net.sourceforge.plantuml.tikz.TikzGraphics;
import net.sourceforge.plantuml.utils.MathUtils;

public class DriverRectangleTikz implements UDriver<URectangle, TikzGraphics> {

	public void draw(URectangle rect, double x, double y, ColorMapper mapper, UParam param, TikzGraphics tikz) {
		final double width = rect.getWidth();
		final double height = rect.getHeight();
		final double r = MathUtils.min(rect.getRx(), rect.getRy(), width / 2, height / 2);

		final HColor back = param.getBackcolor();
		if (back instanceof HColorGradient) {
			final HColorGradient gr = (HColorGradient) back;
			tikz.setGradientColor(gr.getColor1(), gr.getColor2(), gr.getPolicy());
		} else {
			tikz.setFillColor(back);
		}
		tikz.setStrokeColor(param.getColor());
		tikz.setStrokeWidth(param.getStroke().getThickness(), param.getStroke().getDashTikz());
		if (r == 0) {
			tikz.rectangle(x, y, width, height);
		} else {
			tikz.rectangleRound(x, y, width, height, r);
		}
	}

}
