// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
package net.sourceforge.plantuml.security.authentication.oauth;

import java.net.URLConnection;

import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.security.authentication.SecurityAccessInterceptor;
import net.sourceforge.plantuml.security.authentication.SecurityAuthentication;

/**
 * Applies from {@link SecurityAuthentication} data an OAuth2 Authorization
 * access header.
 *
 * @author Aljoscha Rittner
 */
public class OAuth2AccessInterceptor implements SecurityAccessInterceptor {
	@Override
	public void apply(SecurityAuthentication authentication, URLConnection connection) {
		connection.setRequestProperty("Authorization", getAuth(authentication));
	}

	private String getAuth(SecurityAuthentication authentication) {
		String accessToken = (String) authentication.getTokens().get(OAuth2Tokens.ACCESS_TOKEN.key());
		String type = (String) authentication.getTokens().get(OAuth2Tokens.TOKEN_TYPE.key());
		return StringUtils.capitalize(type) + ' ' + accessToken;
	}

}
