// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
package net.sourceforge.plantuml.stats;

import java.io.PrintStream;
import java.util.Date;

import net.sourceforge.plantuml.stats.api.Stats;
import net.sourceforge.plantuml.stats.api.StatsColumn;
import net.sourceforge.plantuml.stats.api.StatsLine;

public class TextConverter {

	private final Stats stats;
	private int linesUsed;

	public TextConverter(Stats stats) {
		this.stats = stats;
	}

	public void printMe(PrintStream ps) {
		final TextTable table = new TextTable();
		table.addSeparator();
		table.addLine("ID", "Start", "Duration", "Generated", "Mean(ms)");
		// table.addLine("ID", "Start", "Last", "Parsed", "Mean(ms)", "Generated",
		// "Mean(ms)");
		table.addSeparator();
		for (StatsLine line : stats.getLastSessions().getLines()) {
			Object id = (Long) line.getValue(StatsColumn.SESSION_ID);
			if (id == null) {
				id = "";
			}
			final Date start = (Date) line.getValue(StatsColumn.STARTING);
			// final Date end = (Date) line.getValue(StatsColumn.LAST);
			// final Long parsed = (Long) line.getValue(StatsColumn.PARSED_COUNT);
			final String duration = line.getValue(StatsColumn.DURATION_STRING).toString();
			final Long generated = (Long) line.getValue(StatsColumn.GENERATED_COUNT);
			final Long generated_ms = (Long) line.getValue(StatsColumn.GENERATED_MEAN_TIME);
			table.addLine(id, start, duration, generated, generated_ms);

		}
		table.addSeparator();
		linesUsed = table.getLines();
		table.printMe(ps);
	}

	public int getLinesUsed() {
		return linesUsed;
	}

	public static void main(String[] args) {
		StatsUtils.dumpStats();

	}

}
