// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
package net.sourceforge.plantuml.xmi;

import java.io.IOException;
import java.io.OutputStream;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;

import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.UmlDiagram;
import net.sourceforge.plantuml.classdiagram.ClassDiagram;
import net.sourceforge.plantuml.cucadiagram.ICucaDiagram;
import net.sourceforge.plantuml.descdiagram.DescriptionDiagram;
import net.sourceforge.plantuml.log.Logme;
import net.sourceforge.plantuml.statediagram.StateDiagram;
import net.sourceforge.plantuml.utils.Log;

public final class CucaDiagramXmiMaker {
	// ::remove folder when __CORE__

	private final ICucaDiagram diagram;
	private final FileFormat fileFormat;

	public CucaDiagramXmiMaker(ICucaDiagram diagram, FileFormat fileFormat) throws IOException {
		this.diagram = diagram;
		this.fileFormat = fileFormat;
	}

	public static String getModel(UmlDiagram classDiagram) {
		return "model1";
	}

	public void createFiles(OutputStream fos) throws IOException {
		try {
			final XmlDiagramTransformer xmi;
			if (diagram instanceof StateDiagram)
				xmi = new XmiStateDiagram((StateDiagram) diagram);
			else if (diagram instanceof DescriptionDiagram)
				xmi = new XmiDescriptionDiagram((DescriptionDiagram) diagram);
			else if (fileFormat == FileFormat.XMI_STANDARD)
				xmi = new XmiClassDiagramStandard((ClassDiagram) diagram);
			else if (fileFormat == FileFormat.XMI_ARGO)
				xmi = new XmiClassDiagramArgo((ClassDiagram) diagram);
			else if (fileFormat == FileFormat.XMI_STAR)
				xmi = new XmiClassDiagramStar((ClassDiagram) diagram);
			else
				throw new UnsupportedOperationException();

			xmi.transformerXml(fos);
		} catch (ParserConfigurationException e) {
			Log.error(e.toString());
			Logme.error(e);
			throw new IOException(e.toString());
		} catch (TransformerException e) {
			Log.error(e.toString());
			Logme.error(e);
			throw new IOException(e.toString());
		}
	}

}
