// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
/* +=======================================================================
 * |
 * |      PlantUML : a free UML diagram generator
 * |
 * +=======================================================================
 *
 * (C) Copyright 2009-2024, Arnaud Roques
 *
 * Project Info:  https://plantuml.com
 *
 * If you like this project or if you find it useful, you can support us at:
 *
 * https://plantuml.com/patreon (only 1$ per month!)
 * https://plantuml.com/liberapay (only 1€ per month!)
 * https://plantuml.com/paypal
 *
 *
 * PlantUML is free software; you can redistribute it and/or modify it
 * under the terms of the MIT License.
 *
 * See http://opensource.org/licenses/MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR
 * IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * PlantUML can occasionally display sponsored or advertising messages. Those
 * messages are usually generated on welcome or error images and never on
 * functional diagrams.
 * See https://plantuml.com/professional if you want to remove them
 *
 * Images (whatever their format : PNG, SVG, EPS...) generated by running PlantUML
 * are owned by the author of their corresponding sources code (that is, their
 * textual description in PlantUML language). Those images are not covered by
 * this MIT license.
 *
 * The generated images can then be used without any reference to the MIT license.
 * It is not even necessary to stipulate that they have been generated with PlantUML,
 * although this will be appreciated by the PlantUML team.
 *
 * There is an exception : if the textual description in PlantUML language is also covered
 * by any license, then the generated images are logically covered
 * by the very same license.
 *
 * This is the IGY distribution (Install GraphViz by Yourself).
 * You have to install GraphViz and to setup the GRAPHVIZ_DOT environment variable
 * (see https://plantuml.com/graphviz-dot )
 *
 * Icons provided by OpenIconic :  https://useiconic.com/open
 * Archimate sprites provided by Archi :  http://www.archimatetool.com
 * Stdlib AWS provided by https://github.com/milo-minderbinder/AWS-PlantUML
 * Stdlib Icons provided https://github.com/tupadr3/plantuml-icon-font-sprites
 * ASCIIMathML (c) Peter Jipsen http://www.chapman.edu/~jipsen
 * ASCIIMathML (c) David Lippman http://www.pierce.ctc.edu/dlippman
 * CafeUndZopfli ported by Eugene Klyuchnikov https://github.com/eustas/CafeUndZopfli
 * Brotli (c) by the Brotli Authors https://github.com/google/brotli
 * Themes (c) by Brett Schwarz https://github.com/bschwarz/puml-themes
 * Twemoji (c) by Twitter at https://twemoji.twitter.com/
 *
 */
package net.sourceforge.plantuml;

import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.concurrent.atomic.AtomicBoolean;

import net.sourceforge.plantuml.core.Diagram;
import net.sourceforge.plantuml.dot.GraphvizUtils;
import net.sourceforge.plantuml.log.Logme;
import net.sourceforge.plantuml.security.SFile;
import net.sourceforge.plantuml.security.SecurityUtils;
import net.sourceforge.plantuml.utils.Log;

public class OptionFlags {
	// ::remove file when __HAXE__

	private static final OptionFlags singleton = new OptionFlags();
	static public final boolean STRICT_SELFMESSAGE_POSITION = true;
	static public final boolean USE_INTERFACE_EYE1 = false;
	static public final boolean USE_INTERFACE_EYE2 = false;
	static public final boolean FORCE_TEOZ = false;

	private boolean replaceWhiteBackgroundByTransparent;

	public static OptionFlags getInstance() {
		return singleton;
	}

	public final boolean isReplaceWhiteBackgroundByTransparent() {
		return replaceWhiteBackgroundByTransparent;
	}

	public final void setReplaceWhiteBackgroundByTransparent(boolean replaceWhiteBackgroundByTransparent) {
		this.replaceWhiteBackgroundByTransparent = replaceWhiteBackgroundByTransparent;
	}

	// ::comment when __CORE__
	// static public final boolean PBBACK = false;
	// static public boolean GRAPHVIZCACHE = false;
	// static public final boolean TRACE_DOT = false;

//	static public boolean ALLOW_INCLUDE = true;
//
//	static public void setAllowIncludeFalse() {
//		ALLOW_INCLUDE = false;
//	}

	static public void setMaxPixel(int max) {
	}

	// static public final boolean USE_HECTOR = false;
	static public boolean ADD_NICE_FOR_DOT = false;

	// static public final boolean USE_IF_VERTICAL = true;
	// static public final boolean SWI2 = false;
	// static public final boolean USE_COMPOUND = false;
	// static public final boolean OMEGA_CROSSING = false;

	// static public final boolean LINK_BETWEEN_FIELDS = true;

	public void reset() {
		reset(false);
		GraphvizUtils.setDotExecutable(null);
	}

	public final void setDotExecutable(String dotExecutable) {
		GraphvizUtils.setDotExecutable(dotExecutable);
	}

	private OptionFlags() {
		reset(true);
	}

	private void reset(boolean exit) {
		verbose = false;
		extractFromMetadata = false;
		word = false;
		systemExit = exit;
		gui = false;
		quiet = false;
		checkDotError = false;
		printFonts = false;
		// failOnError = false;
		encodesprite = false;
		// PIC_LINE = false;
	}

	public boolean useJavaInsteadOfDot() {
		return false;
	}

	private boolean verbose;
	private boolean extractFromMetadata;
	private boolean word;
	private boolean systemExit;
	private boolean gui;
	private boolean quiet;
	private boolean checkDotError;
	private boolean printFonts;
	private boolean encodesprite;
	private boolean dumpHtmlStats;
	private boolean dumpStats;
	private boolean loopStats;
	private boolean overwrite;
	private boolean enableStats = defaultForStats();
	private boolean stdLib;
	private boolean silentlyCompletelyIgnoreErrors;
	private boolean extractStdLib;
	private boolean clipboardLoop;
	private boolean clipboard;
	private String fileSeparator = "_";
	private long timeoutMs = 15 * 60 * 1000L; // 15 minutes
	private SFile logData;

	public final boolean isVerbose() {
		return verbose;
	}

	public final void setVerbose(boolean verbose) {
		this.verbose = verbose;
	}

	public final boolean isExtractFromMetadata() {
		return extractFromMetadata;
	}

	public final void setExtractFromMetadata(boolean extractFromMetadata) {
		this.extractFromMetadata = extractFromMetadata;
	}

	public final boolean isWord() {
		return word;
	}

	public final void setWord(boolean word) {
		this.word = word;
	}

	public final boolean isSystemExit() {
		return systemExit;
	}

	public final void setSystemExit(boolean systemExit) {
		this.systemExit = systemExit;
	}

	public final boolean isGui() {
		return gui;
	}

	public final void setGui(boolean gui) {
		this.gui = gui;
	}

	public final boolean isQuiet() {
		return quiet;
	}

	public final void setQuiet(boolean quiet) {
		this.quiet = quiet;
	}

	public final boolean isCheckDotError() {
		return checkDotError;
	}

	public final void setCheckDotError(boolean checkDotError) {
		this.checkDotError = checkDotError;
	}

	private final AtomicBoolean logDataInitized = new AtomicBoolean(false);

	public void logData(final SFile file, Diagram system) {
		final String warnOrError = system.getWarningOrError();
		if (warnOrError == null) {
			return;
		}
		synchronized (logDataInitized) {
			if (logData == null && logDataInitized.get() == false) {
				final String s = GraphvizUtils.getenvLogData();
				if (s != null) {
					setLogData(new SFile(s));
				}
				logDataInitized.set(true);
			}

			if (logData == null) {
				return;
			}
			// final PSystemError systemError = (PSystemError) system;
			try (PrintStream ps = SecurityUtils.createPrintStream(logData.createFileOutputStream(true))) {
				ps.println("Start of " + file.getName());
				ps.println(warnOrError);
				ps.println("End of " + file.getName());
				ps.println();
			} catch (FileNotFoundException e) {
				Log.error("Cannot open " + logData);
				Logme.error(e);
			}
		}
	}

	public final void setLogData(SFile logData) {
		this.logData = logData;
		logData.delete();
		try (PrintStream ps = SecurityUtils.createPrintStream(logData.createFileOutputStream())) {
			ps.println();
		} catch (FileNotFoundException e) {
			Log.error("Cannot open " + logData);
			Logme.error(e);
		}
	}

	public final boolean isPrintFonts() {
		return printFonts;
	}

	public final void setPrintFonts(boolean printFonts) {
		this.printFonts = printFonts;
	}

	public final boolean isUseSuggestEngine2() {
		return false;
	}

	public final boolean isEncodesprite() {
		return encodesprite;
	}

	public final void setEncodesprite(boolean encodesprite) {
		this.encodesprite = encodesprite;
	}

	public final boolean isOverwrite() {
		return overwrite;
	}

	public final void setOverwrite(boolean overwrite) {
		this.overwrite = overwrite;
	}

	public final String getFileSeparator() {
		return fileSeparator;
	}

	public final void setFileSeparator(String fileSeparator) {
		this.fileSeparator = fileSeparator;
	}

	public final boolean isDumpHtmlStats() {
		return dumpHtmlStats;
	}

	public final void setDumpHtmlStats(boolean value) {
		this.dumpHtmlStats = value;
	}

	public final boolean isDumpStats() {
		return dumpStats;
	}

	public final void setDumpStats(boolean dumpStats) {
		this.dumpStats = dumpStats;
	}

	public final boolean isLoopStats() {
		return loopStats;
	}

	public final void setLoopStats(boolean loopStats) {
		this.loopStats = loopStats;
	}

	private static boolean defaultForStats() {
		return isTrue(System.getProperty("PLANTUML_STATS")) || isTrue(System.getenv("PLANTUML_STATS"));
	}

	private static boolean isTrue(final String value) {
		return "on".equalsIgnoreCase(value) || "true".equalsIgnoreCase(value);
	}

	public boolean isEnableStats() {
		return enableStats;
	}

	public void setEnableStats(boolean enableStats) {
		this.enableStats = enableStats;
	}

	public final long getTimeoutMs() {
		return timeoutMs;
	}

	public final void setTimeoutMs(long timeoutMs) {
		this.timeoutMs = timeoutMs;
	}

	public void setExtractStdLib(boolean extractStdLib) {
		this.extractStdLib = extractStdLib;
	}

	public boolean isExtractStdLib() {
		return extractStdLib;
	}

	public final boolean isClipboardLoop() {
		return clipboardLoop;
	}

	public final void setClipboardLoop(boolean clipboardLoop) {
		this.clipboardLoop = clipboardLoop;
	}

	public final boolean isClipboard() {
		return clipboard;
	}

	public final void setClipboard(boolean clipboard) {
		this.clipboard = clipboard;
	}

	public final boolean isStdLib() {
		return stdLib;
	}

	public final void setStdLib(boolean stdLib) {
		this.stdLib = stdLib;
	}

	public final boolean isSilentlyCompletelyIgnoreErrors() {
		return silentlyCompletelyIgnoreErrors;
	}

	public final void setSilentlyCompletelyIgnoreErrors(boolean silentlyCompletelyIgnoreErrors) {
		this.silentlyCompletelyIgnoreErrors = silentlyCompletelyIgnoreErrors;
	}

}
