// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
/* +=======================================================================
 * |
 * |      PlantUML : a free UML diagram generator
 * |
 * +=======================================================================
 *
 * (C) Copyright 2009-2024, Arnaud Roques
 *
 * Project Info:  https://plantuml.com
 *
 * If you like this project or if you find it useful, you can support us at:
 *
 * https://plantuml.com/patreon (only 1$ per month!)
 * https://plantuml.com/liberapay (only 1€ per month!)
 * https://plantuml.com/paypal
 *
 *
 * PlantUML is free software; you can redistribute it and/or modify it
 * under the terms of the MIT License.
 *
 * See http://opensource.org/licenses/MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR
 * IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * PlantUML can occasionally display sponsored or advertising messages. Those
 * messages are usually generated on welcome or error images and never on
 * functional diagrams.
 * See https://plantuml.com/professional if you want to remove them
 *
 * Images (whatever their format : PNG, SVG, EPS...) generated by running PlantUML
 * are owned by the author of their corresponding sources code (that is, their
 * textual description in PlantUML language). Those images are not covered by
 * this MIT license.
 *
 * The generated images can then be used without any reference to the MIT license.
 * It is not even necessary to stipulate that they have been generated with PlantUML,
 * although this will be appreciated by the PlantUML team.
 *
 * There is an exception : if the textual description in PlantUML language is also covered
 * by any license, then the generated images are logically covered
 * by the very same license.
 *
 * This is the IGY distribution (Install GraphViz by Yourself).
 * You have to install GraphViz and to setup the GRAPHVIZ_DOT environment variable
 * (see https://plantuml.com/graphviz-dot )
 *
 * Icons provided by OpenIconic :  https://useiconic.com/open
 * Archimate sprites provided by Archi :  http://www.archimatetool.com
 * Stdlib AWS provided by https://github.com/milo-minderbinder/AWS-PlantUML
 * Stdlib Icons provided https://github.com/tupadr3/plantuml-icon-font-sprites
 * ASCIIMathML (c) Peter Jipsen http://www.chapman.edu/~jipsen
 * ASCIIMathML (c) David Lippman http://www.pierce.ctc.edu/dlippman
 * CafeUndZopfli ported by Eugene Klyuchnikov https://github.com/eustas/CafeUndZopfli
 * Brotli (c) by the Brotli Authors https://github.com/google/brotli
 * Themes (c) by Brett Schwarz https://github.com/bschwarz/puml-themes
 * Twemoji (c) by Twitter at https://twemoji.twitter.com/
 *
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.cond;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

import net.sourceforge.plantuml.activitydiagram3.Branch;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;

public class FtileSwitchWithDiamonds extends FtileSwitchNude {

	private static final double SUPP15 = 15;

	static enum Mode {
		BIG_DIAMOND, SMALL_DIAMOND
	};

	protected final Ftile diamond1;
	protected final Ftile diamond2;
	protected final List<Branch> branches;
	protected final Mode mode;
	private final double w13;
	private final double w9;

	public FtileSwitchWithDiamonds(List<Ftile> tiles, List<Branch> branches, Swimlane in, Ftile diamond1,
			Ftile diamond2, StringBounder stringBounder) {
		super(tiles, in);
		this.branches = branches;
		this.diamond1 = diamond1;
		this.diamond2 = diamond2;

		w13 = diamond1.calculateDimension(stringBounder).getWidth()
				- tiles.get(0).calculateDimension(stringBounder).getRight()
				- tiles.get(tiles.size() - 1).calculateDimension(stringBounder).getLeft();
		w9 = getW9(stringBounder);
		if (w13 > w9)
			mode = Mode.BIG_DIAMOND;
		else
			mode = Mode.SMALL_DIAMOND;

	}

	private double getW9(StringBounder stringBounder) {
		double result = 0;
		for (int i = 1; i < tiles.size() - 1; i++)
			result += tiles.get(i).calculateDimension(stringBounder).getWidth();

		return result;
	}

	@Override
	final public Collection<Ftile> getMyChildren() {
		final Collection<Ftile> result = new ArrayList<>(super.getMyChildren());
		result.add(diamond1);
		result.add(diamond2);
		return Collections.unmodifiableCollection(result);
	}

	protected double getYdelta1a(StringBounder stringBounder) {
		return 20;
	}

	final protected double getYdelta1b(StringBounder stringBounder) {
		return 10;
	}

	@Override
	final protected FtileGeometry calculateDimensionInternalSlow(StringBounder stringBounder) {
		final FtileGeometry dim1 = diamond1.calculateDimension(stringBounder);
		final FtileGeometry dim2 = diamond2.calculateDimension(stringBounder);

		final double nudeHeight = super.calculateDimensionInternalSlow(stringBounder).getHeight();

		if (mode == Mode.BIG_DIAMOND) {
			final double height = dim1.getHeight() + nudeHeight + dim2.getHeight() + getYdelta1a(stringBounder)
					+ getYdelta1b(stringBounder);
			final FtileGeometry tile0 = tiles.get(0).calculateDimension(stringBounder);
			final double width = tile0.getWidth() + SUPP15 + w13 + SUPP15
					+ +tiles.get(tiles.size() - 1).calculateDimension(stringBounder).getWidth();
			return new FtileGeometry(width, height, tile0.getLeft() + SUPP15 + dim1.getLeft(), 0, height);

		} else {
			final FtileGeometry dimNude = super.calculateDimensionInternalSlow(stringBounder);
			final FtileGeometry all = dim1.appendBottom(dimNude).appendBottom(dim2);
			return all.addDim(0, getYdelta1a(stringBounder) + getYdelta1b(stringBounder));
		}

	}

	@Override
	final public void drawU(UGraphic ug) {
		final StringBounder stringBounder = ug.getStringBounder();

		ug.apply(getTranslateDiamond1(stringBounder)).draw(diamond1);
		if (mode == Mode.BIG_DIAMOND)
			for (Ftile tile : tiles)
				tile.drawU(ug.apply(getTranslateOf(tile, stringBounder)));
		else
			super.drawU(ug.apply(getTranslateMain(stringBounder)));

		if (calculateDimension(stringBounder).hasPointOut())
			ug.apply(getTranslateDiamond2(stringBounder)).draw(diamond2);

	}

	final protected UTranslate getTranslateOf(Ftile tile, StringBounder stringBounder) {
		final UTranslate main = getTranslateMain(stringBounder);
		if (mode == Mode.BIG_DIAMOND) {
			double dx = 0;
			final double suppx = (w13 - w9) / (tiles.size() - 1);
			for (int i = 0; i < tiles.size() - 1; i++) {
				if (tile == tiles.get(i))
					return main.compose(UTranslate.dx(dx));

				dx += tiles.get(i).calculateDimension(stringBounder).getWidth() + suppx;
			}
			if (tile == tiles.get(tiles.size() - 1)) {
				final double dx9 = tiles.get(0).calculateDimension(stringBounder).getWidth() + w13 + SUPP15 + SUPP15;
				return main.compose(UTranslate.dx(dx9));
			}
			throw new IllegalArgumentException();

		}
		return getTranslateNude(tile, stringBounder).compose(main);
	}

	final protected UTranslate getTranslateMain(StringBounder stringBounder) {
		final FtileGeometry dimDiamond1 = diamond1.calculateDimension(stringBounder);
		final double dy1 = dimDiamond1.getHeight() + getYdelta1a(stringBounder);
		return UTranslate.dy(dy1);
	}

	final protected UTranslate getTranslateDiamond1(StringBounder stringBounder) {
		final double y1 = 0;
		final FtileGeometry dimTotal = calculateDimensionInternal(stringBounder);
		final FtileGeometry dimDiamond1 = diamond1.calculateDimension(stringBounder);
		final double x1 = dimTotal.getLeft() - dimDiamond1.getLeft();
		return new UTranslate(x1, y1);
	}

	final protected UTranslate getTranslateDiamond2(StringBounder stringBounder) {
		final FtileGeometry dimTotal = calculateDimensionInternal(stringBounder);
		final FtileGeometry dimDiamond2 = diamond2.calculateDimension(stringBounder);
		final double y2 = dimTotal.getHeight() - dimDiamond2.getHeight();
		final double x2 = dimTotal.getLeft() - dimDiamond2.getWidth() / 2;
		return new UTranslate(x2, y2);
	}

}
