// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
/* +=======================================================================
 * |
 * |      PlantUML : a free UML diagram generator
 * |
 * +=======================================================================
 *
 * (C) Copyright 2009-2024, Arnaud Roques
 *
 * Project Info:  https://plantuml.com
 *
 * If you like this project or if you find it useful, you can support us at:
 *
 * https://plantuml.com/patreon (only 1$ per month!)
 * https://plantuml.com/liberapay (only 1€ per month!)
 * https://plantuml.com/paypal
 *
 *
 * PlantUML is free software; you can redistribute it and/or modify it
 * under the terms of the MIT License.
 *
 * See http://opensource.org/licenses/MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR
 * IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * PlantUML can occasionally display sponsored or advertising messages. Those
 * messages are usually generated on welcome or error images and never on
 * functional diagrams.
 * See https://plantuml.com/professional if you want to remove them
 *
 * Images (whatever their format : PNG, SVG, EPS...) generated by running PlantUML
 * are owned by the author of their corresponding sources code (that is, their
 * textual description in PlantUML language). Those images are not covered by
 * this MIT license.
 *
 * The generated images can then be used without any reference to the MIT license.
 * It is not even necessary to stipulate that they have been generated with PlantUML,
 * although this will be appreciated by the PlantUML team.
 *
 * There is an exception : if the textual description in PlantUML language is also covered
 * by any license, then the generated images are logically covered
 * by the very same license.
 *
 * This is the IGY distribution (Install GraphViz by Yourself).
 * You have to install GraphViz and to setup the GRAPHVIZ_DOT environment variable
 * (see https://plantuml.com/graphviz-dot )
 *
 * Icons provided by OpenIconic :  https://useiconic.com/open
 * Archimate sprites provided by Archi :  http://www.archimatetool.com
 * Stdlib AWS provided by https://github.com/milo-minderbinder/AWS-PlantUML
 * Stdlib Icons provided https://github.com/tupadr3/plantuml-icon-font-sprites
 * ASCIIMathML (c) Peter Jipsen http://www.chapman.edu/~jipsen
 * ASCIIMathML (c) David Lippman http://www.pierce.ctc.edu/dlippman
 * CafeUndZopfli ported by Eugene Klyuchnikov https://github.com/eustas/CafeUndZopfli
 * Brotli (c) by the Brotli Authors https://github.com/google/brotli
 * Themes (c) by Brett Schwarz https://github.com/bschwarz/puml-themes
 * Twemoji (c) by Twitter at https://twemoji.twitter.com/
 *
 */
package net.sourceforge.plantuml.activitydiagram3.gtile;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;

import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.FloatingNote;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.FtileGroup;
import net.sourceforge.plantuml.decoration.symbol.USymbol;
import net.sourceforge.plantuml.klimt.Fashion;
import net.sourceforge.plantuml.klimt.UStroke;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.color.HColors;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.TextBlockUtils;
import net.sourceforge.plantuml.skin.AlignmentParam;
import net.sourceforge.plantuml.style.ISkinParam;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.utils.MathUtils;

public class GtileGroup extends AbstractGtileRoot {

	private final double diffYY2 = 20;
	private final Gtile inner;
	private final TextBlock name;
	private final TextBlock headerNote;
	private final HColor borderColor;
	private final HColor backColor;
	private final double shadowing;
	private final UStroke stroke;
	private final USymbol type;
	private final double roundCorner;

	final public StyleSignatureBasic getStyleSignature() {
		return FtileGroup.getStyleSignature(type);
	}

	private double suppWidth(StringBounder stringBounder) {
		final XDimension2D orig = inner.calculateDimension(stringBounder);
		final XDimension2D dimTitle = name.calculateDimension(stringBounder);
		final XDimension2D dimHeaderNote = headerNote.calculateDimension(stringBounder);
		final double suppWidth = MathUtils.max(orig.getWidth(), dimTitle.getWidth() + 20, dimHeaderNote.getWidth() + 20)
				- orig.getWidth();
		return suppWidth;
	}

	public GtileGroup(Gtile inner, Display title, Display displayNote, HColor arrowColor, HColor backColor,
			ISkinParam skinParam, USymbol type, Style style) {
		super(inner.getStringBounder(), skinParam);
		this.type = type;
		this.backColor = backColor == null ? HColors.WHITE : backColor;
		this.inner = inner;
		this.borderColor = style.value(PName.LineColor).asColor(skinParam.getIHtmlColorSet());
		this.roundCorner = style.value(PName.RoundCorner).asDouble();

		final FontConfiguration fc = style.getFontConfiguration(skinParam.getIHtmlColorSet());
		this.shadowing = style.value(PName.Shadowing).asDouble();

		if (title == null)
			this.name = TextBlockUtils.empty(0, 0);
		else
			this.name = title.create(fc, HorizontalAlignment.LEFT, skinParam);

		if (Display.isNull(displayNote))
			this.headerNote = TextBlockUtils.empty(0, 0);
		else
			this.headerNote = FloatingNote.create(displayNote, skinParam, SName.activityDiagram);

		this.stroke = style.getStroke();
	}

	@Override
	public Collection<GConnection> getInnerConnections() {
		return Collections.emptyList();
	}

	@Override
	public Set<Swimlane> getSwimlanes() {
		return inner.getSwimlanes();
	}

	@Override
	public Swimlane getSwimlane(String point) {
		return inner.getSwimlane(point);
	}

	@Override
	public XDimension2D calculateDimension(StringBounder stringBounder) {
		final XDimension2D orig = inner.calculateDimension(stringBounder);
		return orig.delta(18, suppHeight(stringBounder));
	}

	private double suppHeight(StringBounder stringBounder) {
		final XDimension2D dimTitle = name.calculateDimension(stringBounder);
		return dimTitle.getHeight() + 30;
	}

	private UTranslate getTranslate() {
		return new UTranslate(9, suppHeight(getStringBounder()) - 10);
	}

	@Override
	protected UTranslate getCoordImpl(String name) {
		return inner.getCoord(name).compose(getTranslate());
	}

	@Override
	protected void drawUInternal(UGraphic ug) {

		final XDimension2D dimTotal = calculateDimension(stringBounder);

		final Fashion symbolContext = new Fashion(backColor, borderColor).withShadow(shadowing).withStroke(stroke)
				.withCorner(roundCorner, 0);

		final HorizontalAlignment align = inner.skinParam().getHorizontalAlignment(AlignmentParam.packageTitleAlignment,
				null, false, null);
		type.asBig(name, align, TextBlockUtils.empty(0, 0), dimTotal.getWidth(), dimTotal.getHeight(), symbolContext,
				skinParam().getStereotypeAlignment()).drawU(ug);

		inner.drawU(ug.apply(getTranslate()));
	}

//	@Override
//	public Collection<Ftile> getMyChildren() {
//		return inner.getMyChildren();
//	}
//
//	@Override
//	public LinkRendering getInLinkRendering() {
//		return inner.getInLinkRendering();
//	}
//
//	public Set<Swimlane> getSwimlanes() {
//		return inner.getSwimlanes();
//	}
//
//	public Swimlane getSwimlaneIn() {
//		return inner.getSwimlaneIn();
//	}
//
//	public Swimlane getSwimlaneOut() {
//		return inner.getSwimlaneOut();
//	}
//
//	private double diffHeightTitle(StringBounder stringBounder) {
//		final Dimension2D dimTitle = name.calculateDimension(stringBounder);
//		return Math.max(25, dimTitle.getHeight() + 20);
//	}
//
//	private UTranslate getTranslate(StringBounder stringBounder) {
//		final double suppWidth = suppWidth(stringBounder);
//		return new UTranslate(suppWidth / 2, diffHeightTitle(stringBounder) + headerNoteHeight(stringBounder));
//	}
//
//	private MinMax getInnerMinMax(StringBounder stringBounder) {
//		final LimitFinder limitFinder = new LimitFinder(stringBounder, false);
//		final UGraphicForSnake interceptor = new UGraphicForSnake(limitFinder);
//		final UGraphicInterceptorUDrawable interceptor2 = new UGraphicInterceptorUDrawable(interceptor);
//
//		inner.drawU(interceptor2);
//		interceptor2.flushUg();
//		return limitFinder.getMinMax();
//	}
//
//	public double suppWidth(StringBounder stringBounder) {
//		final FtileGeometry orig = getInnerDimension(stringBounder);
//		final Dimension2D dimTitle = name.calculateDimension(stringBounder);
//		final Dimension2D dimHeaderNote = headerNote.calculateDimension(stringBounder);
//		final double suppWidth = MathUtils.max(orig.getWidth(), dimTitle.getWidth() + 20, dimHeaderNote.getWidth() + 20)
//				- orig.getWidth();
//		return suppWidth;
//	}
//
//	private FtileGeometry cachedInnerDimension;
//
//	private FtileGeometry getInnerDimension(StringBounder stringBounder) {
//		if (cachedInnerDimension == null) {
//			cachedInnerDimension = getInnerDimensionSlow(stringBounder);
//		}
//		return cachedInnerDimension;
//
//	}
//
//	private FtileGeometry getInnerDimensionSlow(StringBounder stringBounder) {
//		final FtileGeometry orig = inner.calculateDimension(stringBounder);
//		final MinMax minMax = getInnerMinMax(stringBounder);
//		final double missingWidth = minMax.getMaxX() - orig.getWidth();
//		if (missingWidth > 0) {
//			return orig.addDim(missingWidth + 5, 0);
//		}
//		return orig;
//	}
//
//	@Override
//	protected FtileGeometry calculateDimensionFtile(StringBounder stringBounder) {
//		final FtileGeometry orig = getInnerDimension(stringBounder);
//		final double suppWidth = suppWidth(stringBounder);
//		final double width = orig.getWidth() + suppWidth;
//		final double height = orig.getHeight() + diffHeightTitle(stringBounder) + diffYY2
//				+ headerNoteHeight(stringBounder);
//		final double titleAndHeaderNoteHeight = diffHeightTitle(stringBounder) + headerNoteHeight(stringBounder);
//		if (orig.hasPointOut()) {
//			return new FtileGeometry(width, height, orig.getLeft() + suppWidth / 2,
//					orig.getInY() + titleAndHeaderNoteHeight, orig.getOutY() + titleAndHeaderNoteHeight);
//		}
//		return new FtileGeometry(width, height, orig.getLeft() + suppWidth / 2,
//				orig.getInY() + titleAndHeaderNoteHeight);
//	}
//
//	private double headerNoteHeight(StringBounder stringBounder) {
//		return headerNote.calculateDimension(stringBounder).getHeight();
//	}
//
//	public void drawU(UGraphic ug) {
//		final StringBounder stringBounder = ug.getStringBounder();
//		final Dimension2D dimTotal = calculateDimension(stringBounder);
//
//		// final double roundCorner =
//		// type.getSkinParameter().getRoundCorner(skinParam(), null);
//		final SymbolContext symbolContext = new SymbolContext(backColor, borderColor).withShadow(shadowing)
//				.withStroke(stroke).withCorner(roundCorner, 0);
//
//		final HorizontalAlignment align = inner.skinParam().getHorizontalAlignment(AlignmentParam.packageTitleAlignment,
//				null, false, null);
//		type.asBig(name, align, TextBlockUtils.empty(0, 0), dimTotal.getWidth(), dimTotal.getHeight(), symbolContext,
//				skinParam().getStereotypeAlignment()).drawU(ug);
//
//		final Dimension2D dimHeaderNote = headerNote.calculateDimension(stringBounder);
//		headerNote.drawU(ug.apply(new UTranslate(dimTotal.getWidth() - dimHeaderNote.getWidth() - 10,
//				diffHeightTitle(ug.getStringBounder()) - 10)));
//
//		ug.apply(getTranslate(stringBounder)).draw(inner);
//
//	}

}
