// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
/* +=======================================================================
 * |
 * |      PlantUML : a free UML diagram generator
 * |
 * +=======================================================================
 *
 * (C) Copyright 2009-2024, Arnaud Roques
 *
 * Project Info:  https://plantuml.com
 *
 * If you like this project or if you find it useful, you can support us at:
 *
 * https://plantuml.com/patreon (only 1$ per month!)
 * https://plantuml.com/liberapay (only 1€ per month!)
 * https://plantuml.com/paypal
 *
 *
 * PlantUML is free software; you can redistribute it and/or modify it
 * under the terms of the MIT License.
 *
 * See http://opensource.org/licenses/MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR
 * IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * PlantUML can occasionally display sponsored or advertising messages. Those
 * messages are usually generated on welcome or error images and never on
 * functional diagrams.
 * See https://plantuml.com/professional if you want to remove them
 *
 * Images (whatever their format : PNG, SVG, EPS...) generated by running PlantUML
 * are owned by the author of their corresponding sources code (that is, their
 * textual description in PlantUML language). Those images are not covered by
 * this MIT license.
 *
 * The generated images can then be used without any reference to the MIT license.
 * It is not even necessary to stipulate that they have been generated with PlantUML,
 * although this will be appreciated by the PlantUML team.
 *
 * There is an exception : if the textual description in PlantUML language is also covered
 * by any license, then the generated images are logically covered
 * by the very same license.
 *
 * This is the IGY distribution (Install GraphViz by Yourself).
 * You have to install GraphViz and to setup the GRAPHVIZ_DOT environment variable
 * (see https://plantuml.com/graphviz-dot )
 *
 * Icons provided by OpenIconic :  https://useiconic.com/open
 * Archimate sprites provided by Archi :  http://www.archimatetool.com
 * Stdlib AWS provided by https://github.com/milo-minderbinder/AWS-PlantUML
 * Stdlib Icons provided https://github.com/tupadr3/plantuml-icon-font-sprites
 * ASCIIMathML (c) Peter Jipsen http://www.chapman.edu/~jipsen
 * ASCIIMathML (c) David Lippman http://www.pierce.ctc.edu/dlippman
 * CafeUndZopfli ported by Eugene Klyuchnikov https://github.com/eustas/CafeUndZopfli
 * Brotli (c) by the Brotli Authors https://github.com/google/brotli
 * Themes (c) by Brett Schwarz https://github.com/bschwarz/puml-themes
 * Twemoji (c) by Twitter at https://twemoji.twitter.com/
 *
 */
package net.sourceforge.plantuml.project.time;

import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;

import net.sourceforge.plantuml.project.Value;
import net.sourceforge.plantuml.project.core.PrintScale;

public class Day implements Comparable<Day>, Value {

	static final public long MILLISECONDS_PER_DAY = 1000L * 3600L * 24;
	static final private Calendar gmt = Calendar.getInstance(TimeZone.getTimeZone("GMT"));

	private final int dayOfMonth;
	private final MonthYear monthYear;
	private final long milliseconds;

	public static Day create(int year, String month, int dayOfMonth) {
		return new Day(year, Month.fromString(month), dayOfMonth);
	}

	public static Day create(int year, int month, int dayOfMonth) {
		return new Day(year, Month.values()[month - 1], dayOfMonth);
	}

	public static Day create(long ms) {
		return new Day(ms);
	}

	public static Day today() {
		return create(System.currentTimeMillis());
	}

	public String toStringShort(Locale locale) {
		return monthYear.shortName(locale) + " " + dayOfMonth;
	}

	public int getWeekOfYear(WeekNumberStrategy strategy) {
		synchronized (gmt) {
			gmt.clear();
			gmt.setTimeInMillis(milliseconds);
			gmt.setFirstDayOfWeek(strategy.getFirstDayOfWeekAsLegacyInt());
			gmt.setMinimalDaysInFirstWeek(strategy.getMinimalDaysInFirstWeek());
			return gmt.get(Calendar.WEEK_OF_YEAR);
		}
	}

	private Day(int year, Month month, int dayOfMonth) {
		this.dayOfMonth = dayOfMonth;
		this.monthYear = MonthYear.create(year, month);
		synchronized (gmt) {
			gmt.clear();
			gmt.set(year, month.ordinal(), dayOfMonth);
			this.milliseconds = gmt.getTimeInMillis();
		}
	}

	private Day(long ms) {
		this.milliseconds = ms;
		synchronized (gmt) {
			gmt.clear();
			gmt.setTimeInMillis(ms);
			final int year = gmt.get(Calendar.YEAR);
			final int month = gmt.get(Calendar.MONTH);
			final int dayOfMonth = gmt.get(Calendar.DAY_OF_MONTH);
			this.dayOfMonth = dayOfMonth;
			this.monthYear = MonthYear.create(year, Month.values()[month]);
		}

	}

	public Day increment() {
		return addDays(1);
	}

	public Day decrement() {
		return addDays(-1);
	}

	public Day addDays(int nday) {
		return create(MILLISECONDS_PER_DAY * (getAbsoluteDayNum() + nday));
	}

	public final int getAbsoluteDayNum() {
		return (int) (milliseconds / MILLISECONDS_PER_DAY);
	}

	public final long getMillis() {
		return milliseconds;
	}

	public int year() {
		return monthYear.year();
	}

	private int internalNumber() {
		return year() * 100 * 100 + month().ordinal() * 100 + dayOfMonth;
	}

	@Override
	public String toString() {
		return monthYear.toString() + "/" + dayOfMonth;
	}

	@Override
	public int hashCode() {
		return monthYear.hashCode() + dayOfMonth * 17;
	}

	@Override
	public boolean equals(Object obj) {
		final Day other = (Day) obj;
		return other.internalNumber() == this.internalNumber();
	}

	public final int getDayOfMonth() {
		return dayOfMonth;
	}

	private int daysPerMonth() {
		return month().getDaysPerMonth(year());
	}

	public Month month() {
		return monthYear.month();
	}

	public MonthYear monthYear() {
		return monthYear;
	}

	// https://en.wikipedia.org/wiki/Zeller%27s_congruence
	public DayOfWeek getDayOfWeek() {
		final int q = dayOfMonth;
		final int m = month().m();
		final int y = m >= 13 ? year() - 1 : year();
		final int k = y % 100;
		final int j = y / 100;
		final int h = ((q + 13 * (m + 1) / 5) + k + k / 4 + j / 4 + 5 * j) % 7;
		return DayOfWeek.fromH(h);
	}

	public int compareTo(Day other) {
		return this.internalNumber() - other.internalNumber();
	}

	public static Day min(Day wink1, Day wink2) {
		if (wink2.internalNumber() < wink1.internalNumber())
			return wink2;

		return wink1;
	}

	public static Day max(Day wink1, Day wink2) {
		if (wink2.internalNumber() > wink1.internalNumber())
			return wink2;

		return wink1;
	}

	public Day increment(PrintScale printScale) {
		if (printScale == PrintScale.WEEKLY)
			return this.addDays(7);
		return increment();
	}

	public Day roundDayDown() {
		return new Day((milliseconds / MILLISECONDS_PER_DAY) * MILLISECONDS_PER_DAY);
	}

	public Day roundDayUp() {
		return new Day(((milliseconds + MILLISECONDS_PER_DAY - 1) / MILLISECONDS_PER_DAY) * MILLISECONDS_PER_DAY);
	}

}
