// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
/* +=======================================================================
 * |
 * |      PlantUML : a free UML diagram generator
 * |
 * +=======================================================================
 *
 * (C) Copyright 2009-2024, Arnaud Roques
 *
 * Project Info:  https://plantuml.com
 *
 * If you like this project or if you find it useful, you can support us at:
 *
 * https://plantuml.com/patreon (only 1$ per month!)
 * https://plantuml.com/liberapay (only 1€ per month!)
 * https://plantuml.com/paypal
 *
 *
 * PlantUML is free software; you can redistribute it and/or modify it
 * under the terms of the MIT License.
 *
 * See http://opensource.org/licenses/MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR
 * IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * PlantUML can occasionally display sponsored or advertising messages. Those
 * messages are usually generated on welcome or error images and never on
 * functional diagrams.
 * See https://plantuml.com/professional if you want to remove them
 *
 * Images (whatever their format : PNG, SVG, EPS...) generated by running PlantUML
 * are owned by the author of their corresponding sources code (that is, their
 * textual description in PlantUML language). Those images are not covered by
 * this MIT license.
 *
 * The generated images can then be used without any reference to the MIT license.
 * It is not even necessary to stipulate that they have been generated with PlantUML,
 * although this will be appreciated by the PlantUML team.
 *
 * There is an exception : if the textual description in PlantUML language is also covered
 * by any license, then the generated images are logically covered
 * by the very same license.
 *
 * This is the IGY distribution (Install GraphViz by Yourself).
 * You have to install GraphViz and to setup the GRAPHVIZ_DOT environment variable
 * (see https://plantuml.com/graphviz-dot )
 *
 * Icons provided by OpenIconic :  https://useiconic.com/open
 * Archimate sprites provided by Archi :  http://www.archimatetool.com
 * Stdlib AWS provided by https://github.com/milo-minderbinder/AWS-PlantUML
 * Stdlib Icons provided https://github.com/tupadr3/plantuml-icon-font-sprites
 * ASCIIMathML (c) Peter Jipsen http://www.chapman.edu/~jipsen
 * ASCIIMathML (c) David Lippman http://www.pierce.ctc.edu/dlippman
 * CafeUndZopfli ported by Eugene Klyuchnikov https://github.com/eustas/CafeUndZopfli
 * Brotli (c) by the Brotli Authors https://github.com/google/brotli
 * Themes (c) by Brett Schwarz https://github.com/bschwarz/puml-themes
 * Twemoji (c) by Twitter at https://twemoji.twitter.com/
 *
 */
package net.sourceforge.plantuml.svek.image;

import net.sourceforge.plantuml.klimt.UPath;
import net.sourceforge.plantuml.klimt.UStroke;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.geom.XPoint2D;
import net.sourceforge.plantuml.klimt.shape.AbstractTextBlock;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.utils.Direction;
import net.sourceforge.plantuml.utils.MathUtils;

public class Opale extends AbstractTextBlock implements TextBlock {

	private static final int cornersize = 10;
	private final HColor noteBackgroundColor;
	private final HColor borderColor;
	private final int marginX1 = 6;
	private final int marginX2 = 15;
	private final int marginY = 5;
	private final double shadowing2;
	private Direction strategy;
	private XPoint2D pp1;
	private XPoint2D pp2;
	private final boolean withLink;
	private double roundCorner;
	private final UStroke stroke;

	private final TextBlock textBlock;

	public Opale(double shadowing, HColor borderColor, HColor noteBackgroundColor, TextBlock textBlock,
			boolean withLink, UStroke stroke) {
		this.noteBackgroundColor = noteBackgroundColor;
		this.withLink = withLink;
		this.shadowing2 = shadowing;
		this.borderColor = borderColor;
		this.textBlock = textBlock;
		this.stroke = stroke;
	}

	public void setRoundCorner(double roundCorner) {
		this.roundCorner = roundCorner;
	}

	public void setOpale(Direction strategy, XPoint2D pp1, XPoint2D pp2) {
		this.strategy = strategy;
		this.pp1 = pp1;
		this.pp2 = pp2;
	}

	final private double getWidth(StringBounder stringBounder) {
		return textBlock.calculateDimension(stringBounder).getWidth() + marginX1 + marginX2;
	}

	final private double getHeight(StringBounder stringBounder) {
		final XDimension2D size = textBlock.calculateDimension(stringBounder);
		return size.getHeight() + 2 * marginY;
	}

	public XDimension2D calculateDimension(StringBounder stringBounder) {
		final double height = getHeight(stringBounder);
		final double width = getWidth(stringBounder);
		return new XDimension2D(width, height);
	}

	final public void drawU(UGraphic ug) {
		final StringBounder stringBounder = ug.getStringBounder();
		ug = ug.apply(noteBackgroundColor.bg()).apply(borderColor);
		final UPath polygon;
		if (withLink == false)
			polygon = getPolygonNormal(stringBounder);
		else if (strategy == Direction.LEFT)
			polygon = getPolygonLeft(stringBounder, pp1, pp2);
		else if (strategy == Direction.RIGHT)
			polygon = getPolygonRight(stringBounder, pp1, pp2);
		else if (strategy == Direction.UP)
			polygon = getPolygonUp(stringBounder, pp1, pp2);
		else if (strategy == Direction.DOWN)
			polygon = getPolygonDown(stringBounder, pp1, pp2);
		else
			throw new IllegalArgumentException();

		polygon.setDeltaShadow(shadowing2);
		if (stroke != null)
			ug = ug.apply(stroke);
		ug.draw(polygon);
		ug.draw(getCorner(getWidth(stringBounder), roundCorner));
		textBlock.drawU(ug.apply(new UTranslate(marginX1, marginY)));
	}

	private UPath getPolygonNormal(final StringBounder stringBounder) {
		return getPolygonNormal(getWidth(stringBounder), getHeight(stringBounder), roundCorner);
	}

	public static UPath getCorner(double width, double roundCorner) {
		final UPath path = UPath.none();
		path.moveTo(width - cornersize, 0);
		if (roundCorner == 0) {
			path.lineTo(width - cornersize, cornersize);
		} else {
			path.lineTo(width - cornersize, cornersize - roundCorner / 4);
			path.arcTo(new XPoint2D(width - cornersize + roundCorner / 4, cornersize), roundCorner / 4, 0, 0);
		}
		path.lineTo(width, cornersize);
		path.lineTo(width - cornersize, 0);
		path.closePath();
		return path;
	}

	public static UPath getPolygonNormal(double width, double height, double roundCorner) {
		final UPath polygon = UPath.none();
		if (roundCorner == 0) {
			polygon.moveTo(0, 0);
			polygon.lineTo(0, height);
			polygon.lineTo(width, height);
			polygon.lineTo(width, cornersize);
			polygon.lineTo(width - cornersize, 0);
			polygon.lineTo(0, 0);
		} else {
			polygon.moveTo(0, roundCorner / 2);
			polygon.lineTo(0, height - roundCorner / 2);
			polygon.arcTo(new XPoint2D(roundCorner / 2, height), roundCorner / 2, 0, 0);
			polygon.lineTo(width - roundCorner / 2, height);
			polygon.arcTo(new XPoint2D(width, height - roundCorner / 2), roundCorner / 2, 0, 0);
			polygon.lineTo(width, cornersize);
			polygon.lineTo(width - cornersize, 0);
			polygon.lineTo(roundCorner / 2, 0);
			polygon.arcTo(new XPoint2D(0, roundCorner / 2), roundCorner / 2, 0, 0);
		}
		polygon.closePath();
		return polygon;
	}

	private final double delta = 4;

	private UPath getPolygonLeft(final StringBounder stringBounder, final XPoint2D pp1, final XPoint2D pp2) {
		final UPath polygon = UPath.none();
		polygon.moveTo(0, roundCorner / 2);

		double y1 = pp1.getY() - delta;
		y1 = MathUtils.limitation(y1, 0, getHeight(stringBounder) - 2 * delta);
		polygon.lineTo(0, y1);
		polygon.lineTo(pp2.getX(), pp2.getY());
		polygon.lineTo(0, y1 + 2 * delta);

		polygon.lineTo(0, getHeight(stringBounder) - roundCorner / 2);
		polygon.arcTo(new XPoint2D(roundCorner / 2, getHeight(stringBounder)), roundCorner / 2, 0, 0);
		polygon.lineTo(getWidth(stringBounder) - roundCorner / 2, getHeight(stringBounder));
		polygon.arcTo(new XPoint2D(getWidth(stringBounder), getHeight(stringBounder) - roundCorner / 2),
				roundCorner / 2, 0, 0);
		polygon.lineTo(getWidth(stringBounder), cornersize);
		polygon.lineTo(getWidth(stringBounder) - cornersize, 0);
		polygon.lineTo(roundCorner / 2, 0);
		polygon.arcTo(new XPoint2D(0, roundCorner / 2), roundCorner / 2, 0, 0);
		polygon.closePath();
		return polygon;
	}

	private UPath getPolygonRight(final StringBounder stringBounder, final XPoint2D pp1, final XPoint2D pp2) {
		final UPath polygon = UPath.none();
		polygon.moveTo(0, roundCorner / 2);
		polygon.lineTo(0, getHeight(stringBounder) - roundCorner / 2);
		polygon.arcTo(new XPoint2D(roundCorner / 2, getHeight(stringBounder)), roundCorner / 2, 0, 0);
		polygon.lineTo(getWidth(stringBounder) - roundCorner / 2, getHeight(stringBounder));
		polygon.arcTo(new XPoint2D(getWidth(stringBounder), getHeight(stringBounder) - roundCorner / 2),
				roundCorner / 2, 0, 0);

		double y1 = pp1.getY() - delta;
		y1 = MathUtils.limitation(y1, cornersize, getHeight(stringBounder) - 2 * delta);
		polygon.lineTo(getWidth(stringBounder), y1 + 2 * delta);
		polygon.lineTo(pp2.getX(), pp2.getY());
		polygon.lineTo(getWidth(stringBounder), y1);

		polygon.lineTo(getWidth(stringBounder), cornersize);
		polygon.lineTo(getWidth(stringBounder) - cornersize, 0);
		polygon.lineTo(roundCorner / 2, 0);
		polygon.arcTo(new XPoint2D(0, roundCorner / 2), roundCorner / 2, 0, 0);
		polygon.closePath();
		return polygon;
	}

	private UPath getPolygonUp(final StringBounder stringBounder, final XPoint2D pp1, final XPoint2D pp2) {
		final UPath polygon = UPath.none();
		polygon.moveTo(0, roundCorner / 2);
		polygon.lineTo(0, getHeight(stringBounder) - roundCorner / 2);
		polygon.arcTo(new XPoint2D(roundCorner / 2, getHeight(stringBounder)), roundCorner / 2, 0, 0);
		polygon.lineTo(getWidth(stringBounder) - roundCorner / 2, getHeight(stringBounder));
		polygon.arcTo(new XPoint2D(getWidth(stringBounder), getHeight(stringBounder) - roundCorner / 2),
				roundCorner / 2, 0, 0);
		polygon.lineTo(getWidth(stringBounder), cornersize);
		polygon.lineTo(getWidth(stringBounder) - cornersize, 0);

		double x1 = pp1.getX() - delta;
		x1 = MathUtils.limitation(x1, 0, getWidth(stringBounder) - cornersize);
		polygon.lineTo(x1 + 2 * delta, 0);
		polygon.lineTo(pp2.getX(), pp2.getY());

		polygon.lineTo(x1, 0);
		polygon.lineTo(roundCorner / 2, 0);
		polygon.arcTo(new XPoint2D(0, roundCorner / 2), roundCorner / 2, 0, 0);
		polygon.closePath();
		return polygon;
	}

	private UPath getPolygonDown(final StringBounder stringBounder, final XPoint2D pp1, final XPoint2D pp2) {
		final UPath polygon = UPath.none();
		polygon.moveTo(0, roundCorner / 2);
		polygon.lineTo(0, getHeight(stringBounder) - roundCorner / 2);
		polygon.arcTo(new XPoint2D(roundCorner / 2, getHeight(stringBounder)), roundCorner / 2, 0, 0);

		double x1 = pp1.getX() - delta;
		x1 = MathUtils.limitation(x1, 0, getWidth(stringBounder));
		polygon.lineTo(x1, getHeight(stringBounder));
		polygon.lineTo(pp2.getX(), pp2.getY());
		polygon.lineTo(x1 + 2 * delta, getHeight(stringBounder));

		polygon.lineTo(getWidth(stringBounder) - roundCorner / 2, getHeight(stringBounder));
		polygon.arcTo(new XPoint2D(getWidth(stringBounder), getHeight(stringBounder) - roundCorner / 2),
				roundCorner / 2, 0, 0);
		polygon.lineTo(getWidth(stringBounder), cornersize);
		polygon.lineTo(getWidth(stringBounder) - cornersize, 0);
		polygon.lineTo(roundCorner / 2, 0);
		polygon.arcTo(new XPoint2D(0, roundCorner / 2), roundCorner / 2, 0, 0);
		polygon.closePath();
		return polygon;
	}

	public final int getMarginX1() {
		return marginX1;
	}

}
