/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vcompact;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import net.sourceforge.plantuml.activitydiagram3.ftile.BoxStyle;
import net.sourceforge.plantuml.activitydiagram3.ftile.Connection;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileBreak;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileFactory;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileFactoryDelegator;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileUtils;
import net.sourceforge.plantuml.activitydiagram3.ftile.Genealogy;
import net.sourceforge.plantuml.activitydiagram3.ftile.Snake;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.activitydiagram3.ftile.WeldingPoint;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.FtileRepeat;
import net.sourceforge.plantuml.activitydiagram3.ftile.vertical.FtileDiamond;
import net.sourceforge.plantuml.decoration.Rainbow;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.Colors;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleBuilder;
import net.sourceforge.plantuml.svek.ConditionStyle;

public class FtileFactoryDelegatorRepeat
extends FtileFactoryDelegator {
    public FtileFactoryDelegatorRepeat(FtileFactory factory) {
        super(factory);
    }

    @Override
    public Ftile repeat(BoxStyle boxStyleIn, Swimlane swimlane, Swimlane swimlaneOut, Display startLabel, Ftile repeat, Display test, Display yes, Display out, Colors colors, Ftile backward, boolean noOut, LinkRendering incoming1, LinkRendering incoming2, StyleBuilder currentStyleBuilder) {
        ConditionStyle conditionStyle = this.skinParam().getConditionStyle();
        Style styleArrow = this.getDefaultStyleDefinitionArrow().getMergedStyle(currentStyleBuilder);
        Style styleDiamond = this.getDefaultStyleDefinitionDiamond().getMergedStyle(currentStyleBuilder);
        HColor borderColor = styleDiamond.value(PName.LineColor).asColor(this.skinParam().getIHtmlColorSet());
        HColor diamondColor = styleDiamond.value(PName.BackGroundColor).asColor(this.skinParam().getIHtmlColorSet());
        final Rainbow arrowColor = Rainbow.build(styleArrow, this.skinParam().getIHtmlColorSet());
        FontConfiguration fcDiamond = styleDiamond.getFontConfiguration(this.skinParam().getIHtmlColorSet());
        FontConfiguration fcArrow = styleArrow.getFontConfiguration(this.skinParam().getIHtmlColorSet());
        LinkRendering endRepeatLinkRendering = repeat.getOutLinkRendering();
        Rainbow endRepeatLinkColor = endRepeatLinkRendering == null ? null : endRepeatLinkRendering.getRainbow();
        Ftile entry = this.getEntry(repeat.getSwimlaneIn(), startLabel, colors, boxStyleIn);
        Ftile result = FtileRepeat.create(swimlane, swimlaneOut, entry, repeat, test, yes, out, borderColor, diamondColor, arrowColor, endRepeatLinkColor, conditionStyle, this.skinParam(), fcDiamond, fcArrow, backward, noOut, incoming1, incoming2);
        List<WeldingPoint> weldingPoints = repeat.getWeldingPoints();
        if (weldingPoints.size() > 0) {
            final FtileDiamond diamondBreak = new FtileDiamond(repeat.skinParam(), diamondColor, borderColor, swimlane);
            result = this.assembly(FtileUtils.addHorizontalMargin(result, 10.0, 0.0), diamondBreak);
            final Genealogy genealogy = new Genealogy(result);
            ArrayList<Connection> connections = new ArrayList<Connection>();
            for (int i = 0; i < weldingPoints.size(); ++i) {
                final FtileBreak ftileBreak = (FtileBreak)weldingPoints.get(i);
                final boolean first = i == 0;
                connections.add(new Connection(){

                    @Override
                    public void drawU(UGraphic ug) {
                        Snake snake;
                        UTranslate tr1 = genealogy.getTranslate(ftileBreak, ug.getStringBounder());
                        UTranslate tr2 = genealogy.getTranslate(diamondBreak, ug.getStringBounder());
                        FtileGeometry dimDiamond = diamondBreak.calculateDimension(ug.getStringBounder());
                        if (first) {
                            snake = Snake.create(FtileFactoryDelegatorRepeat.this.skinParam(), arrowColor, FtileFactoryDelegatorRepeat.this.skinParam().arrows().asToRight());
                            snake.addPoint(tr1.getDx(), tr1.getDy());
                            snake.addPoint(0.0, tr1.getDy());
                            snake.addPoint(0.0, tr2.getDy() + ((XDimension2D)dimDiamond).getHeight() / 2.0);
                            snake.addPoint(tr2.getDx(), tr2.getDy() + ((XDimension2D)dimDiamond).getHeight() / 2.0);
                        } else {
                            snake = Snake.create(FtileFactoryDelegatorRepeat.this.skinParam(), arrowColor, FtileFactoryDelegatorRepeat.this.skinParam().arrows().asToLeft());
                            snake.addPoint(tr1.getDx(), tr1.getDy());
                            snake.addPoint(0.0, tr1.getDy());
                        }
                        ug.draw(snake);
                    }

                    @Override
                    public Ftile getFtile1() {
                        return ftileBreak;
                    }

                    @Override
                    public Ftile getFtile2() {
                        return diamondBreak;
                    }
                });
            }
            result = FtileUtils.addConnection(result, connections);
        }
        return result;
    }

    private Ftile getEntry(Swimlane swimlane, Display startLabel, Colors colors, BoxStyle boxStyleIn) {
        if (Display.isNull(startLabel)) {
            return null;
        }
        return this.activity(startLabel, swimlane, boxStyleIn, colors, null);
    }
}

