// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
/* +=======================================================================
 * |
 * |      PlantUML : a free UML diagram generator
 * |
 * +=======================================================================
 *
 * (C) Copyright 2009-2024, Arnaud Roques
 *
 * Project Info:  https://plantuml.com
 *
 * If you like this project or if you find it useful, you can support us at:
 *
 * https://plantuml.com/patreon (only 1$ per month!)
 * https://plantuml.com/liberapay (only 1€ per month!)
 * https://plantuml.com/paypal
 *
 *
 * PlantUML is free software; you can redistribute it and/or modify it
 * under the terms of the MIT License.
 *
 * See http://opensource.org/licenses/MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR
 * IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * PlantUML can occasionally display sponsored or advertising messages. Those
 * messages are usually generated on welcome or error images and never on
 * functional diagrams.
 * See https://plantuml.com/professional if you want to remove them
 *
 * Images (whatever their format : PNG, SVG, EPS...) generated by running PlantUML
 * are owned by the author of their corresponding sources code (that is, their
 * textual description in PlantUML language). Those images are not covered by
 * this MIT license.
 *
 * The generated images can then be used without any reference to the MIT license.
 * It is not even necessary to stipulate that they have been generated with PlantUML,
 * although this will be appreciated by the PlantUML team.
 *
 * There is an exception : if the textual description in PlantUML language is also covered
 * by any license, then the generated images are logically covered
 * by the very same license.
 *
 * This is the IGY distribution (Install GraphViz by Yourself).
 * You have to install GraphViz and to setup the GRAPHVIZ_DOT environment variable
 * (see https://plantuml.com/graphviz-dot )
 *
 * Icons provided by OpenIconic :  https://useiconic.com/open
 * Archimate sprites provided by Archi :  http://www.archimatetool.com
 * Stdlib AWS provided by https://github.com/milo-minderbinder/AWS-PlantUML
 * Stdlib Icons provided https://github.com/tupadr3/plantuml-icon-font-sprites
 * ASCIIMathML (c) Peter Jipsen http://www.chapman.edu/~jipsen
 * ASCIIMathML (c) David Lippman http://www.pierce.ctc.edu/dlippman
 * CafeUndZopfli ported by Eugene Klyuchnikov https://github.com/eustas/CafeUndZopfli
 * Brotli (c) by the Brotli Authors https://github.com/google/brotli
 * Themes (c) by Brett Schwarz https://github.com/bschwarz/puml-themes
 * Twemoji (c) by Twitter at https://twemoji.twitter.com/
 *
 */
package net.sourceforge.plantuml.ebnf;

import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.color.HColorSet;
import net.sourceforge.plantuml.klimt.color.NoSuchColorException;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.URectangle;
import net.sourceforge.plantuml.klimt.shape.UText;
import net.sourceforge.plantuml.style.ISkinParam;

public class ETileNamedGroup extends ETile {

	private final ETile orig;
	private final ISkinParam skinParam;
	private String commentAbove;
	private String commentBelow;
	private final HColorSet colorSet;
	private final double deltax = 10;
	private final double deltay1 = 10;
	private final double deltay2 = 10;
	private final UText groupName;

	private final FontConfiguration fc;

	public ETileNamedGroup(ETile orig, FontConfiguration fc, HColorSet colorSet, ISkinParam skinParam, String name) {
		this.skinParam = skinParam;
		this.orig = orig;
		this.fc = fc;
		this.colorSet = colorSet;
		this.groupName = UText.build(name, fc);

	}

	@Override
	public double getH1(StringBounder stringBounder) {
		// final TextBlock note = getNoteAbove(stringBounder);
		return deltay1 + orig.getH1(stringBounder);
	}

	@Override
	public double getH2(StringBounder stringBounder) {
		// final TextBlock note = getNoteBelow(stringBounder);
		return orig.getH2(stringBounder) + deltay2;
	}

	@Override
	public double getWidth(StringBounder stringBounder) {
		return orig.getWidth(stringBounder) + 2 * deltax;
	}

	@Override
	public void drawU(UGraphic ug) {
		final StringBounder stringBounder = ug.getStringBounder();
		final XDimension2D dim = calculateDimension(stringBounder);

		try {
			final HColor background = colorSet.getColor("#E8E8FF");
			final UGraphic ugBack = ug.apply(background).apply(background.bg());
			ugBack.draw(URectangle.build(dim));
			final XDimension2D dimText = stringBounder.calculateDimension(fc.getFont(), groupName.getText());
			ugBack.apply(UTranslate.dy(-dimText.getHeight())).draw(URectangle.build(dimText.delta(10, 0)));

		} catch (NoSuchColorException e) {
			e.printStackTrace();
		}
		final double linePos = getH1(stringBounder);
		drawHline(ug, linePos, 0, deltax);
		drawHline(ug, linePos, dim.getWidth() - deltax, dim.getWidth());

		orig.drawU(ug.apply(new UTranslate(deltax, deltay1)));
		ug.apply(UTranslate.dx(5)).draw(groupName);

	}

	@Override
	public void push(ETile tile) {
		throw new UnsupportedOperationException();
	}

//	@Override
//	protected void addCommentAbove(String comment) {
//		this.commentAbove = comment;
//	}
//
//	@Override
//	protected void addCommentBelow(String comment) {
//		this.commentBelow = comment;
//	}

//	private TextBlock getNoteAbove(StringBounder stringBounder) {
//		if (commentAbove == null)
//			return TextBlockUtils.EMPTY_TEXT_BLOCK;
//		final FloatingNote note = FloatingNote.create(Display.getWithNewlines(commentAbove), skinParam, SName.ebnf);
//		return TextBlockUtils.withMargin(note, 0, 0, 0, 10);
//	}
//
//	private TextBlock getNoteBelow(StringBounder stringBounder) {
//		if (commentBelow == null)
//			return TextBlockUtils.EMPTY_TEXT_BLOCK;
//		final FloatingNote note = FloatingNote.create(Display.getWithNewlines(commentBelow), skinParam, SName.ebnf);
//		return TextBlockUtils.withMargin(note, 0, 0, 10, 0);
//	}

}
