// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
/* +=======================================================================
 * |
 * |      PlantUML : a free UML diagram generator
 * |
 * +=======================================================================
 *
 * (C) Copyright 2009-2024, Arnaud Roques
 *
 * Project Info:  https://plantuml.com
 *
 * If you like this project or if you find it useful, you can support us at:
 *
 * https://plantuml.com/patreon (only 1$ per month!)
 * https://plantuml.com/liberapay (only 1€ per month!)
 * https://plantuml.com/paypal
 *
 *
 * PlantUML is free software; you can redistribute it and/or modify it
 * under the terms of the MIT License.
 *
 * See http://opensource.org/licenses/MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR
 * IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * PlantUML can occasionally display sponsored or advertising messages. Those
 * messages are usually generated on welcome or error images and never on
 * functional diagrams.
 * See https://plantuml.com/professional if you want to remove them
 *
 * Images (whatever their format : PNG, SVG, EPS...) generated by running PlantUML
 * are owned by the author of their corresponding sources code (that is, their
 * textual description in PlantUML language). Those images are not covered by
 * this MIT license.
 *
 * The generated images can then be used without any reference to the MIT license.
 * It is not even necessary to stipulate that they have been generated with PlantUML,
 * although this will be appreciated by the PlantUML team.
 *
 * There is an exception : if the textual description in PlantUML language is also covered
 * by any license, then the generated images are logically covered
 * by the very same license.
 *
 * This is the IGY distribution (Install GraphViz by Yourself).
 * You have to install GraphViz and to setup the GRAPHVIZ_DOT environment variable
 * (see https://plantuml.com/graphviz-dot )
 *
 * Icons provided by OpenIconic :  https://useiconic.com/open
 * Archimate sprites provided by Archi :  http://www.archimatetool.com
 * Stdlib AWS provided by https://github.com/milo-minderbinder/AWS-PlantUML
 * Stdlib Icons provided https://github.com/tupadr3/plantuml-icon-font-sprites
 * ASCIIMathML (c) Peter Jipsen http://www.chapman.edu/~jipsen
 * ASCIIMathML (c) David Lippman http://www.pierce.ctc.edu/dlippman
 * CafeUndZopfli ported by Eugene Klyuchnikov https://github.com/eustas/CafeUndZopfli
 * Brotli (c) by the Brotli Authors https://github.com/google/brotli
 * Themes (c) by Brett Schwarz https://github.com/bschwarz/puml-themes
 * Twemoji (c) by Twitter at https://twemoji.twitter.com/
 *
 */
package net.sourceforge.plantuml.sequencediagram.teoz;

import java.util.ArrayList;
import java.util.List;

import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.real.Real;
import net.sourceforge.plantuml.real.RealUtils;
import net.sourceforge.plantuml.sequencediagram.Event;
import net.sourceforge.plantuml.sequencediagram.Note;
import net.sourceforge.plantuml.sequencediagram.NotePosition;
import net.sourceforge.plantuml.sequencediagram.NoteStyle;
import net.sourceforge.plantuml.sequencediagram.Notes;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.Component;
import net.sourceforge.plantuml.skin.ComponentType;
import net.sourceforge.plantuml.skin.Context2D;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.style.ISkinParam;

public class NotesTile extends AbstractTile implements Tile {

	private final LivingSpaces livingSpaces;
	private final Rose skin;
	private final ISkinParam skinParam;
	private final Notes notes;
	private final YGauge yGauge;

	public Event getEvent() {
		return notes;
	}

	public NotesTile(StringBounder stringBounder, LivingSpaces livingSpaces, Notes notes, Rose skin,
			ISkinParam skinParam, YGauge currentY) {
		super(stringBounder, currentY);
		this.livingSpaces = livingSpaces;
		this.notes = notes;
		this.skin = skin;
		this.skinParam = skinParam;
		this.yGauge = YGauge.create(currentY.getMax(), getPreferredHeight());
	}

	@Override
	public YGauge getYGauge() {
		return yGauge;
	}

	private Component getComponent(StringBounder stringBounder, Note note) {
		final Component comp = skin.createComponentNote(note.getUsedStyles(), getNoteComponentType(note.getNoteStyle()),
				note.getSkinParamBackcolored(skinParam), note.getDisplay(), note.getColors(), note.getPosition());
		return comp;
	}

	private ComponentType getNoteComponentType(NoteStyle noteStyle) {
		if (noteStyle == NoteStyle.HEXAGONAL)
			return ComponentType.NOTE_HEXAGONAL;

		if (noteStyle == NoteStyle.BOX)
			return ComponentType.NOTE_BOX;

		return ComponentType.NOTE;
	}

	public void drawU(UGraphic ug) {
		if (YGauge.USE_ME)
			ug = ug.apply(UTranslate.dy(getYGauge().getMin().getCurrentValue()));
		final StringBounder stringBounder = ug.getStringBounder();

		for (Note note : notes) {
			final Component comp = getComponent(stringBounder, note);
			final XDimension2D dim = comp.getPreferredDimension(stringBounder);
			final double x = getX(stringBounder, note).getCurrentValue();
			final Area area = Area.create(getUsedWidth(stringBounder, note), dim.getHeight());

			final UGraphic ug2 = ug.apply(UTranslate.dx(x));
			comp.drawU(ug2, area, (Context2D) ug2);
		}
	}

	private double getUsedWidth(StringBounder stringBounder, Note note) {
		final Component comp = getComponent(stringBounder, note);
		final XDimension2D dim = comp.getPreferredDimension(stringBounder);
		final double width = dim.getWidth();
		return width;
	}

	private Real getXcenter(StringBounder stringBounder, Note note) {
		final LivingSpace livingSpace1 = livingSpaces.get(note.getParticipant());
		return livingSpace1.getPosC(stringBounder);
	}

	private Real getX(StringBounder stringBounder, Note note) {
		final LivingSpace livingSpace1 = livingSpaces.get(note.getParticipant());
		final NotePosition position = note.getPosition();
		final double width = getUsedWidth(stringBounder, note);
		if (position == NotePosition.LEFT) {
			return livingSpace1.getPosC(stringBounder).addFixed(-width);
		} else if (position == NotePosition.RIGHT) {
			final int level = livingSpace1.getLevelAt(this, EventsHistoryMode.IGNORE_FUTURE_DEACTIVATE);
			final double dx = level * CommunicationTile.LIVE_DELTA_SIZE;
			return livingSpace1.getPosC(stringBounder).addFixed(dx);
		} else if (position == NotePosition.OVER_SEVERAL) {
			final LivingSpace livingSpace2 = livingSpaces.get(note.getParticipant2());
			final Real x1 = livingSpace1.getPosC(stringBounder);
			final Real x2 = livingSpace2.getPosC(stringBounder);
			return RealUtils.middle(x1, x2).addFixed(-width / 2);
		} else if (position == NotePosition.OVER) {
			return livingSpace1.getPosC(stringBounder).addFixed(-width / 2);
		} else {
			throw new UnsupportedOperationException(position.toString());
		}
	}

	public double getPreferredHeight() {
		double result = 0;
		for (Note note : notes) {
			final Component comp = getComponent(getStringBounder(), note);
			final XDimension2D dim = comp.getPreferredDimension(getStringBounder());
			result = Math.max(result, dim.getHeight());
		}
		return result;
	}

	public void addConstraints() {
		final List<Note> all = notes.asList();
		for (int i = 0; i < all.size() - 1; i++) {
			for (int j = i + 1; j < all.size(); j++) {
				final double center1 = getXcenter(getStringBounder(), all.get(i)).getCurrentValue();
				final double center2 = getXcenter(getStringBounder(), all.get(j)).getCurrentValue();
				if (center2 > center1) {
					final Real point1b = getX2(getStringBounder(), all.get(i));
					final Real point2 = getX(getStringBounder(), all.get(j));
					point2.ensureBiggerThan(point1b);
				} else {
					final Real point1 = getX(getStringBounder(), all.get(i));
					final Real point2b = getX2(getStringBounder(), all.get(j));
					point1.ensureBiggerThan(point2b);
				}
			}
		}
	}

	public Real getMinX() {
		final List<Real> reals = new ArrayList<>();
		for (Note note : notes)
			reals.add(getX(getStringBounder(), note));

		return RealUtils.min(reals);
	}

	private Real getX2(StringBounder stringBounder, Note note) {
		return getX(stringBounder, note).addFixed(getUsedWidth(stringBounder, note));
	}

	public Real getMaxX() {
		final List<Real> reals = new ArrayList<>();
		for (Note note : notes)
			reals.add(getX2(getStringBounder(), note));

		return RealUtils.max(reals);
	}

}
