/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.preproc;

public class EvalMath {
    private final String str;
    private int pos = -1;
    private char ch;

    public EvalMath(String str) {
        this.str = str;
    }

    private void nextChar() {
        ++this.pos;
        this.ch = this.pos < this.str.length() ? this.str.charAt(this.pos) : (char)'\u0000';
    }

    private boolean eat(int charToEat) {
        while (this.ch == ' ') {
            this.nextChar();
        }
        if (this.ch == charToEat) {
            this.nextChar();
            return true;
        }
        return false;
    }

    private double parseExpression() {
        double x = this.parseTerm();
        while (true) {
            if (this.eat(43)) {
                x += this.parseTerm();
                continue;
            }
            if (!this.eat(45)) break;
            x -= this.parseTerm();
        }
        return x;
    }

    private double parseTerm() {
        double x = this.parseFactor();
        while (true) {
            if (this.eat(42)) {
                x *= this.parseFactor();
                continue;
            }
            if (!this.eat(47)) break;
            x /= this.parseFactor();
        }
        return x;
    }

    private double parseFactor() {
        double x;
        if (this.eat(43)) {
            return this.parseFactor();
        }
        if (this.eat(45)) {
            return -this.parseFactor();
        }
        int startPos = this.pos;
        if (this.eat(40)) {
            x = this.parseExpression();
            this.eat(41);
        } else if (this.ch >= '0' && this.ch <= '9' || this.ch == '.') {
            while (this.ch >= '0' && this.ch <= '9' || this.ch == '.') {
                this.nextChar();
            }
            x = Double.parseDouble(this.str.substring(startPos, this.pos));
        } else {
            if (this.ch >= 'a' && this.ch <= 'z') {
                while (this.ch >= 'a' && this.ch <= 'z') {
                    this.nextChar();
                }
                String func = this.str.substring(startPos, this.pos);
                double x2 = this.parseFactor();
                throw new RuntimeException("Unknown function: " + func);
            }
            throw new RuntimeException("Unexpected: " + this.ch);
        }
        return x;
    }

    public double eval() {
        this.nextChar();
        double x = this.parseExpression();
        if (this.pos < this.str.length()) {
            throw new RuntimeException("Unexpected: " + this.ch);
        }
        return x;
    }

    public static void main(String[] args) {
        EvalMath eval = new EvalMath("33+2*(4+1)");
        System.err.println(eval.eval());
    }
}

