/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.version;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.OptionFlags;
import net.sourceforge.plantuml.version.LicenseInfo;
import net.sourceforge.plantuml.version.LicenseType;
import net.sourceforge.plantuml.windowsdot.WindowsDotArchive;

public class License {
    public static void main(String[] args) {
        List<String> lines = License.getCurrent().getTextFull();
        for (int line = 0; line < lines.size(); ++line) {
            if (line == 0) {
                System.out.print("/* ");
            } else {
                System.out.print(" * ");
            }
            System.out.println(lines.get(line));
        }
        System.out.println(" */");
    }

    public String toString() {
        return "MIT";
    }

    public static License getCurrent() {
        return new License();
    }

    public List<String> getTextFull() {
        ArrayList<String> text = new ArrayList<String>();
        LicenseInfo licenseInfo = LicenseInfo.retrieveQuick();
        this.header1(text, licenseInfo);
        this.header2(text, licenseInfo, false);
        this.end3(licenseInfo, text);
        return text;
    }

    public List<String> getText1(LicenseInfo licenseInfo) {
        ArrayList<String> text = new ArrayList<String>();
        this.header1(text, licenseInfo);
        return text;
    }

    public List<String> getText2(LicenseInfo licenseInfo) {
        ArrayList<String> text = new ArrayList<String>();
        this.header2(text, licenseInfo, true);
        this.end3(licenseInfo, text);
        return text;
    }

    private void header1(List<String> text, LicenseInfo licenseInfo) {
        if (licenseInfo.isNone()) {
            text.add("+=======================================================================");
            text.add("| ");
            text.add("|      PlantUML : a free UML diagram generator");
            text.add("| ");
            text.add("+=======================================================================");
        } else {
            text.add("+=======================================================================");
            text.add("| ");
            text.add("|      PlantUML Professional Edition");
            text.add("| ");
            text.add("+=======================================================================");
            License.addLicenseInfo(text, licenseInfo);
            text.add("+=======================================================================");
        }
    }

    private void header2(List<String> text, LicenseInfo licenseInfo, boolean withQrcode) {
        text.add(" ");
        text.add("(C) Copyright 2009-2024, Arnaud Roques");
        text.add(" ");
        text.add("Project Info:  https://plantuml.com");
        text.add(" ");
        if (!licenseInfo.isValid()) {
            text.add("If you like this project or if you find it useful, you can support us at:");
            text.add(" ");
            text.add("https://plantuml.com/patreon (only 1$ per month!)");
            text.add("https://plantuml.com/liberapay (only 1\u20ac per month!)");
            text.add("https://plantuml.com/paypal");
            if (withQrcode) {
                text.add("\t<qrcode:https://plantuml.com/patreon>\t\t<qrcode:https://plantuml.com/lp>\t\t<qrcode:https://plantuml.com/paypal>");
            } else {
                text.add("");
                text.add(" ");
            }
        }
    }

    private void end3(LicenseInfo licenseInfo, List<String> text) {
        this.addMit(licenseInfo, text);
        text.add(" ");
        if (!licenseInfo.isValid()) {
            text.add("PlantUML can occasionally display sponsored or advertising messages. Those");
            text.add("messages are usually generated on welcome or error images and never on");
            text.add("functional diagrams.");
            text.add("See https://plantuml.com/professional if you want to remove them");
            text.add(" ");
        }
        text.add("Images (whatever their format : PNG, SVG, EPS...) generated by running PlantUML");
        text.add("are owned by the author of their corresponding sources code (that is, their");
        text.add("textual description in PlantUML language). Those images are not covered by");
        text.add("this " + this + " license.");
        text.add(" ");
        text.add("The generated images can then be used without any reference to the " + this + " license.");
        text.add("It is not even necessary to stipulate that they have been generated with PlantUML,");
        text.add("although this will be appreciated by the PlantUML team.");
        text.add(" ");
        text.add("There is an exception : if the textual description in PlantUML language is also covered");
        text.add("by any license, then the generated images are logically covered");
        text.add("by the very same license.");
        if (OptionFlags.getInstance().isEnableStats()) {
            text.add(" ");
            text.add("This version of PlantUML records general local statistics about usage.");
            text.add("(more info on https://plantuml.com/statistics-report)");
        }
        text.add(" ");
        if (WindowsDotArchive.getInstance().isThereArchive()) {
            text.add("This distribution bundles a minimal set of GraphViz files and may install them");
            text.add(" if needed in the local temporary directory.");
        } else {
            text.add("This is the IGY distribution (Install GraphViz by Yourself).");
            text.add("You have to install GraphViz and to setup the GRAPHVIZ_DOT environment variable");
        }
        text.add("(see https://plantuml.com/graphviz-dot )");
        text.add(" ");
        text.add("Icons provided by OpenIconic :  https://useiconic.com/open");
        text.add("Archimate sprites provided by Archi :  http://www.archimatetool.com");
        text.add("Stdlib AWS provided by https://github.com/milo-minderbinder/AWS-PlantUML");
        text.add("Stdlib Icons provided https://github.com/tupadr3/plantuml-icon-font-sprites");
        text.add("ASCIIMathML (c) Peter Jipsen http://www.chapman.edu/~jipsen");
        text.add("ASCIIMathML (c) David Lippman http://www.pierce.ctc.edu/dlippman");
        text.add("CafeUndZopfli ported by Eugene Klyuchnikov https://github.com/eustas/CafeUndZopfli");
        text.add("Brotli (c) by the Brotli Authors https://github.com/google/brotli");
        text.add("Themes (c) by Brett Schwarz https://github.com/bschwarz/puml-themes");
        text.add("Twemoji (c) by Twitter at https://twemoji.twitter.com/");
        text.add(" ");
    }

    private void addMit(LicenseInfo licenseInfo, List<String> text) {
        text.add("PlantUML is free software; you can redistribute it and/or modify it");
        text.add("under the terms of the MIT License.");
        text.add(" ");
        text.add("See http://opensource.org/licenses/MIT");
        text.add(" ");
        text.add("Permission is hereby granted, free of charge, to any person obtaining");
        text.add("a copy of this software and associated documentation files (the \"Software\"),");
        text.add("to deal in the Software without restriction, including without limitation");
        text.add("the rights to use, copy, modify, merge, publish, distribute, sublicense,");
        text.add("and/or sell copies of the Software, and to permit persons to whom the");
        text.add("Software is furnished to do so, subject to the following conditions:");
        text.add(" ");
        text.add("The above copyright notice and this permission notice shall be included");
        text.add("in all copies or substantial portions of the Software.");
        text.add(" ");
        text.add("THE SOFTWARE IS PROVIDED \"AS IS\", WITHOUT WARRANTY OF ANY KIND, EXPRESS");
        text.add("OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,");
        text.add("FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE");
        text.add("AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,");
        text.add("WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR");
        text.add("IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.");
    }

    public static void addLicenseInfo(List<String> text, LicenseInfo licenseInfo) {
        if (licenseInfo.getLicenseType() == LicenseType.NAMED) {
            text.add("| ");
            text.add("|      LICENSED TO : " + licenseInfo.getOwner());
            text.add("|      EXPIRATION DATE : " + DateFormat.getDateInstance().format(licenseInfo.getExpirationDate()));
            text.add("|  ");
        } else if (licenseInfo.getLicenseType() == LicenseType.DISTRIBUTOR) {
            text.add("|  ");
            text.add("|      DISTRIBUTED BY : " + licenseInfo.getOwner());
            text.add("|  ");
        }
        if (licenseInfo.getLicenseType() != LicenseType.UNKNOWN && licenseInfo.hasExpired()) {
            text.add("|      <i>Warning: Your license has expired.");
            text.add("|  ");
        }
    }
}

