/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.wbs;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.UmlDiagram;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.core.UmlSource;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.ColorType;
import net.sourceforge.plantuml.klimt.color.Colors;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.drawing.AbstractCommonUGraphic;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.AbstractTextBlock;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.mindmap.IdeaShape;
import net.sourceforge.plantuml.regex.Matcher2;
import net.sourceforge.plantuml.regex.MyPattern;
import net.sourceforge.plantuml.regex.Pattern2;
import net.sourceforge.plantuml.skin.UmlDiagramType;
import net.sourceforge.plantuml.stereo.Stereotype;
import net.sourceforge.plantuml.style.NoStyleAvailableException;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.utils.Direction;
import net.sourceforge.plantuml.wbs.Fork;
import net.sourceforge.plantuml.wbs.WBSLink;
import net.sourceforge.plantuml.wbs.WElement;

public class WBSDiagram
extends UmlDiagram {
    private WElement root;
    private WElement last;
    private String first;
    private final Map<String, WElement> codes = new LinkedHashMap<String, WElement>();
    private final List<WBSLink> links = new ArrayList<WBSLink>();
    public static final Pattern2 patternStereotype = MyPattern.cmpile("^\\s*(.*?)\\s*(\\<\\<\\s*(.*)\\s*\\>\\>)\\s*$");

    @Override
    public DiagramDescription getDescription() {
        return new DiagramDescription("Work Breakdown Structure");
    }

    public WBSDiagram(UmlSource source) {
        super(source, UmlDiagramType.WBS, null);
    }

    @Override
    protected ImageData exportDiagramInternal(OutputStream os, int index, FileFormatOption fileFormatOption) throws IOException {
        return this.createImageBuilder(fileFormatOption).drawable(this.getTextMainBlock(fileFormatOption)).write(os);
    }

    @Override
    protected TextBlock getTextMainBlock(FileFormatOption fileFormatOption) {
        return new AbstractTextBlock(){

            @Override
            public void drawU(UGraphic ug) {
                WBSDiagram.this.drawMe(ug);
            }

            @Override
            public XDimension2D calculateDimension(StringBounder stringBounder) {
                return WBSDiagram.this.getDrawingElement().calculateDimension(stringBounder);
            }
        };
    }

    private void drawMe(UGraphic ug) {
        UTranslate translate = null;
        if (ug instanceof AbstractCommonUGraphic) {
            translate = ((AbstractCommonUGraphic)ug).getTranslate();
        }
        Fork fork = this.getDrawingElement();
        fork.drawU(ug);
        if (translate == null) {
            return;
        }
        ug = ug.apply(translate.reverse());
        for (WBSLink link : this.links) {
            link.drawU(ug);
        }
    }

    private Fork getDrawingElement() {
        return new Fork(this.getSkinParam(), this.root);
    }

    public CommandExecutionResult addIdea(String code, HColor backColor, int level, String label, Direction direction, IdeaShape shape) {
        Matcher2 m = patternStereotype.matcher(label);
        String stereotype = null;
        if (m.matches()) {
            label = m.group(1);
            stereotype = m.group(2);
        }
        Display display = Display.getWithNewlines(label);
        return this.addIdea(code, backColor, level, display, Stereotype.build(stereotype), direction, shape);
    }

    public CommandExecutionResult addIdea(String code, HColor backColor, int level, Display display, Stereotype stereotype, Direction direction, IdeaShape shape) {
        try {
            if (level == 0) {
                if (this.root != null) {
                    return CommandExecutionResult.error("Error 44");
                }
                this.initRoot(backColor, display, stereotype, shape);
                return CommandExecutionResult.ok();
            }
            return this.add(code, backColor, level, display, stereotype, direction, shape);
        }
        catch (NoStyleAvailableException e) {
            return CommandExecutionResult.error("General failure: no style available.");
        }
    }

    private void initRoot(HColor backColor, Display display, Stereotype stereotype, IdeaShape shape) {
        this.last = this.root = new WElement(backColor, display, stereotype, this.getSkinParam().getCurrentStyleBuilder(), shape);
    }

    private WElement getParentOfLast(int nb) {
        WElement result = this.last;
        for (int i = 0; i < nb; ++i) {
            result = result.getParent();
        }
        return result;
    }

    public int getSmartLevel(String type) {
        if (this.root == null) {
            assert (this.first == null);
            this.first = type;
            return 0;
        }
        if (!(type = type.replace('\t', ' ')).contains(" ")) {
            return type.length() - 1;
        }
        if (type.endsWith(this.first)) {
            return type.length() - this.first.length();
        }
        if (type.trim().length() == 1) {
            return type.length() - 1;
        }
        if (type.startsWith(this.first)) {
            return type.length() - this.first.length();
        }
        throw new UnsupportedOperationException("type=<" + type + ">[" + this.first + "]");
    }

    private CommandExecutionResult add(String code, HColor backColor, int level, Display display, Stereotype stereotype, Direction direction, IdeaShape shape) {
        try {
            if (level == this.last.getLevel() + 1) {
                WElement newIdea;
                this.last = newIdea = this.last.createElement(backColor, level, display, stereotype, direction, shape, this.getSkinParam().getCurrentStyleBuilder());
                if (code != null) {
                    this.codes.put(code, newIdea);
                }
                return CommandExecutionResult.ok();
            }
            if (level <= this.last.getLevel()) {
                WElement newIdea;
                int diff = this.last.getLevel() - level + 1;
                this.last = newIdea = this.getParentOfLast(diff).createElement(backColor, level, display, stereotype, direction, shape, this.getSkinParam().getCurrentStyleBuilder());
                if (code != null) {
                    this.codes.put(code, newIdea);
                }
                return CommandExecutionResult.ok();
            }
            return CommandExecutionResult.error("Bad tree structure");
        }
        catch (NoStyleAvailableException e) {
            return CommandExecutionResult.error("General failure: no style available.");
        }
    }

    public CommandExecutionResult link(String code1, String code2, Colors colors, Stereotype stereotype) {
        WElement element1 = this.codes.get(code1);
        if (element1 == null) {
            return CommandExecutionResult.error("No such node " + code1);
        }
        WElement element2 = this.codes.get(code2);
        if (element2 == null) {
            return CommandExecutionResult.error("No such node " + code2);
        }
        HColor color = colors.getColor(ColorType.LINE);
        if (color == null) {
            Style style = StyleSignatureBasic.of(SName.root, SName.element, SName.wbsDiagram, SName.arrow).withTOBECHANGED(stereotype).getMergedStyle(this.getCurrentStyleBuilder());
            color = style.value(PName.LineColor).asColor(this.getSkinParam().getIHtmlColorSet());
        }
        this.links.add(new WBSLink(element1, element2, color));
        return CommandExecutionResult.ok();
    }
}

