// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
/* +=======================================================================
 * |
 * |      PlantUML : a free UML diagram generator
 * |
 * +=======================================================================
 *
 * (C) Copyright 2009-2024, Arnaud Roques
 *
 * Project Info:  https://plantuml.com
 *
 * If you like this project or if you find it useful, you can support us at:
 *
 * https://plantuml.com/patreon (only 1$ per month!)
 * https://plantuml.com/liberapay (only 1€ per month!)
 * https://plantuml.com/paypal
 *
 *
 * PlantUML is free software; you can redistribute it and/or modify it
 * under the terms of the MIT License.
 *
 * See http://opensource.org/licenses/MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR
 * IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * PlantUML can occasionally display sponsored or advertising messages. Those
 * messages are usually generated on welcome or error images and never on
 * functional diagrams.
 * See https://plantuml.com/professional if you want to remove them
 *
 * Images (whatever their format : PNG, SVG, EPS...) generated by running PlantUML
 * are owned by the author of their corresponding sources code (that is, their
 * textual description in PlantUML language). Those images are not covered by
 * this MIT license.
 *
 * The generated images can then be used without any reference to the MIT license.
 * It is not even necessary to stipulate that they have been generated with PlantUML,
 * although this will be appreciated by the PlantUML team.
 *
 * There is an exception : if the textual description in PlantUML language is also covered
 * by any license, then the generated images are logically covered
 * by the very same license.
 *
 * This is the IGY distribution (Install GraphViz by Yourself).
 * You have to install GraphViz and to setup the GRAPHVIZ_DOT environment variable
 * (see https://plantuml.com/graphviz-dot )
 *
 * Icons provided by OpenIconic :  https://useiconic.com/open
 * Archimate sprites provided by Archi :  http://www.archimatetool.com
 * Stdlib AWS provided by https://github.com/milo-minderbinder/AWS-PlantUML
 * Stdlib Icons provided https://github.com/tupadr3/plantuml-icon-font-sprites
 * ASCIIMathML (c) Peter Jipsen http://www.chapman.edu/~jipsen
 * ASCIIMathML (c) David Lippman http://www.pierce.ctc.edu/dlippman
 * CafeUndZopfli ported by Eugene Klyuchnikov https://github.com/eustas/CafeUndZopfli
 * Brotli (c) by the Brotli Authors https://github.com/google/brotli
 * Themes (c) by Brett Schwarz https://github.com/bschwarz/puml-themes
 * Twemoji (c) by Twitter at https://twemoji.twitter.com/
 *
 */
package net.sourceforge.plantuml;

import java.net.InetAddress;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

import net.sourceforge.plantuml.dot.GraphvizUtils;
import net.sourceforge.plantuml.security.SFile;
import net.sourceforge.plantuml.security.SecurityProfile;
import net.sourceforge.plantuml.security.SecurityUtils;
import net.sourceforge.plantuml.syntax.LanguageDescriptor;
import net.sourceforge.plantuml.version.License;
import net.sourceforge.plantuml.version.PSystemVersion;
import net.sourceforge.plantuml.version.Version;

public class OptionPrint {
	// ::remove file when __CORE__
	// ::remove file when __HAXE__

	static public void printTestDot() throws InterruptedException {
		final List<String> result = new ArrayList<>();
		final int errorCode = GraphvizUtils.addDotStatus(result, false);
		for (String s : result)
			if (errorCode == 0)
				System.out.println(s);
			else
				System.err.println(s);

		exit(errorCode);
	}

	static public void printHelp() throws InterruptedException {

		final String charset = Charset.defaultCharset().displayName();

		System.out.println("Usage: java -jar plantuml.jar [options] -gui");
		System.out.println("\t(to execute the GUI)");
		System.out.println("    or java -jar plantuml.jar [options] [file/dir] [file/dir] [file/dir]");
		System.out.println("\t(to process files or directories)");
		System.out.println();
		System.out.println("You can use the following wildcards in files/dirs:");
		System.out.println("\t*\tmeans any characters but '" + SFile.separator + "'");
		System.out.println("\t?\tone and only one character but '" + SFile.separator + "'");
		System.out.println("\t**\tmeans any characters (used to recurse through directories)");
		System.out.println();
		final char separator = SFile.separatorChar;
		System.out.println("where options include:");
		System.out.println("    -author[s]\t\tTo print information about PlantUML authors");
		System.out.println("    -checkmetadata\t\tSkip PNG files that don't need to be regenerated");
		System.out.println("    -checkonly\t\tTo check the syntax of files without generating images");
		System.out.println("    -charset xxx\tTo use a specific charset (default is " + charset + ")");
		System.out.println("    -computeurl|-encodeurl\tTo compute the encoded URL of a PlantUML source file");
		// System.out.println(" -config \"file\"\tTo read the provided config file
		System.out.println("    -cypher\t\tTo cypher texts of diagrams so that you can share them");
		System.out.println("    -DVAR1=value\tTo set a preprocessing variable as if '!define VAR1 value' were used");
		System.out.println("    -darkmode\t\tTo use dark mode for diagrams");
		System.out.println("    -debugsvek\t\tTo generate intermediate svek files");
		System.out.println("    -decodeurl\t\tTo retrieve the PlantUML source from an encoded URL");
		System.out.println("    -disablestats\tTo disable statistics computation (default)");
		System.out.println("    -duration\t\tTo print the duration of complete diagrams processing");
		System.out.println("    -e[x]clude pattern\tTo exclude files that match the provided pattern");
		System.out.println("    -enablestats\tTo enable statistics computation");
		System.out.println("    -encodesprite 4|8|16[z] \"file\"\tTo encode a sprite at gray level (z for compression) from an image");
		System.out.println("    -extractstdlib\tTo extract PlantUML Standard Library into stdlib folder");
		System.out.println("    -failfast\t\tTo stop processing as soon as a syntax error in diagram occurs");
		System.out.println("    -failfast2\t\tTo do a first syntax check before processing files, to fail even faster");
		System.out.println("    -filedir xxx\tTo behave as if the PlantUML source is in this dir (only affects '-pipe' and PicoWeb 'POST /render')");
		System.out.println("    -filename \"example.puml\"\tTo override %filename% variable");
		System.out.println("    -graphvizdot \"exe\"\tTo specify dot executable");
		System.out.println("    -gui\t\tTo run the graphical user interface");
		System.out.println("    -h[elp]\t\tTo display this help message");
		System.out.println("    -htmlstats\t\tTo output general statistics in file plantuml-stats.html");
		System.out.println("    -I" + separator + "path" + separator + "to" + separator + "file\tTo include file as if '!include file' were used");
		System.out.println("    -I" + separator + "path" + separator + "to" + separator + "*.puml\tTo include files with pattern");
		System.out.println("    -language\t\tTo print the list of PlantUML keywords");
		System.out.println("    -loopstats\t\tTo continuously print statistics about usage");
		System.out.println("    -metadata\t\tTo retrieve PlantUML sources from PNG images");
		System.out.println("    -nbthread N\t\tTo use (N) threads for processing");
		System.out.println("    -nbthread auto\tTo use " + Option.defaultNbThreads() + " threads for processing");
		System.out.println("    -noerror\t\tTo skip images when error in diagrams");
		System.out.println("    -nometadata\t\tTo NOT export metadata in PNG/SVG generated files");
		System.out.println("    -o[utput] \"dir\"\tTo generate images in the specified directory");
		System.out.println("    -overwrite\t\tTo allow to overwrite read only files");
		System.out.println("    -Ppragma1=value\tTo set pragma as if '!pragma pragma1 value' were used");
		System.out.println("    -p[ipe]\t\tTo use stdin for PlantUML source and stdout for PNG/SVG/EPS generation");
		System.out.println("    -picoweb\t\tTo start internal HTTP Server. See https://plantuml.com/picoweb");
		System.out.println("    -pipeimageindex N\tTo generate the Nth image with pipe option");
		System.out.println("    -preproc\t\tTo output preprocessor text of diagrams");
		System.out.println("    -printfonts\t\tTo print fonts available on your system");
		System.out.println("    -progress\t\tTo display a textual progress bar in console");
		System.out.println("    -quiet\t\tTo NOT print error message into the console");
		System.out.println("    -realtimestats\tTo generate statistics on the fly rather than at the end");
		System.out.println("    -Sparam1=value\tTo set a skin parameter as if 'skinparam param1 value' were used");
		System.out.println("    -splash\t\tTo display a splash screen with some progress bar");
		System.out.println("    -stdlib\t\tTo print standard library info");
		System.out.println("    -syntax\t\tTo report any syntax error from standard input without generating images");
		System.out.println("    -testdot\t\tTo test the installation of graphviz");
		System.out.println("    -theme xxx\t\tTo use a specific theme");
		System.out.println("    -timeout N\t\tProcessing timeout in (N) seconds. Defaults to 15 minutes (900 seconds).");
		System.out.println("    -teps\t\tTo generate images using EPS format");
		System.out.println("    -thtml\t\tTo generate HTML file for class diagram");
		System.out.println("    -tlatex:nopreamble\tTo generate images using LaTeX/Tikz format without preamble");
		System.out.println("    -tlatex\t\tTo generate images using LaTeX/Tikz format");
		System.out.println("    -tpdf\t\tTo generate images using PDF format");
		System.out.println("    -tpng\t\tTo generate images using PNG format (default)");
		System.out.println("    -tscxml\t\tTo generate SCXML file for state diagram");
		System.out.println("    -tsvg\t\tTo generate images using SVG format");
		System.out.println("    -ttxt\t\tTo generate images with ASCII art");
		System.out.println("    -tutxt\t\tTo generate images with ASCII art using Unicode characters");
		System.out.println("    -tvdx\t\tTo generate images using VDX format");
		System.out.println("    -txmi\t\tTo generate XMI file for class diagram");
		System.out.println("    -v[erbose]\t\tTo have log information");
		System.out.println("    -version\t\tTo display information about PlantUML and Java versions");
		System.out.println("    -xmlstats\t\tTo output general statistics in file plantuml-stats.xml");
		System.out.println();
		System.out.println("If needed, you can setup the environment variable GRAPHVIZ_DOT.");
		exit(0);
	}

	static private void exit(int errorCode) throws InterruptedException {
		if (OptionFlags.getInstance().isSystemExit() || errorCode != 0)
			System.exit(errorCode);

		throw new InterruptedException("exit");
	}

	public static void printLicense() throws InterruptedException {
		for (String s : License.getCurrent().getTextFull())
			System.out.println(s);
		System.exit(0);
	}

	public static void printVersion() throws InterruptedException {
		System.out.println(Version.fullDescription());
		System.out.println("(" + License.getCurrent() + " source distribution)");
		for (String v : interestingProperties())
			System.out.println(v);

		for (String v : interestingValues())
			System.out.println(v);

		System.out.println();
		final List<String> result = new ArrayList<>();
		final int errorCode = GraphvizUtils.addDotStatus(result, false);
		for (String s : result)
			System.out.println(s);

		System.exit(0);
	}

	public static Collection<String> interestingProperties() {
		final Properties p = System.getProperties();
//		final List<String> list1 = Arrays.asList("java.runtime.name", "Java Runtime", "java.vm.name", "JVM",
//				"java.runtime.version", "Java Version", "os.name", "Operating System", "file.encoding",
//				"Default Encoding", "user.language", "Language", "user.country", "Country");
//		final List<String> list2 = Arrays.asList("java.runtime.name", "Java Runtime", "java.vm.name", "JVM",
//				"java.runtime.version", "Java Version", "os.name", "Operating System", /* "os.version", "OS Version", */
//				"file.encoding", "Default Encoding", "user.language", "Language", "user.country", "Country");
//		final List<String> all = withIp() ? list1 : list2;
		final List<String> all;
		if (SecurityUtils.getSecurityProfile() == SecurityProfile.UNSECURE) {
			all = Arrays.asList("java.runtime.name", "Java Runtime", "java.vm.name", "JVM", "java.runtime.version",
					"Java Version", "os.name", "Operating System", "os.version", "OS Version", "file.encoding",
					"Default Encoding", "user.language", "Language", "user.country", "Country");
		} else {
			all = Arrays.asList("java.runtime.name", "Java Runtime", "java.vm.name", "JVM", "file.encoding",
					"Default Encoding", "user.language", "Language", "user.country", "Country");
		}
		final List<String> result = new ArrayList<>();
		for (int i = 0; i < all.size(); i += 2) {
			result.add(all.get(i + 1) + ": " + p.getProperty(all.get(i)));
		}
		return result;
	}

	public static Collection<String> interestingValues() {
		final List<String> strings = new ArrayList<>();
//		if (withIp() == false) {
//			strings.add("Machine: " + getHostName());
//		}
//		strings.add(" ");
//		strings.add("Current Security Profile: " + SecurityUtils.getSecurityProfile());
//		strings.add(SecurityUtils.getSecurityProfile().longDescription());
		strings.add(" ");
		strings.add("PLANTUML_LIMIT_SIZE: " + GraphvizUtils.getenvImageLimit());
		if (SecurityUtils.getSecurityProfile() == SecurityProfile.UNSECURE) {
			strings.add("Processors: " + Runtime.getRuntime().availableProcessors());
			final long freeMemory = Runtime.getRuntime().freeMemory();
			final long maxMemory = Runtime.getRuntime().maxMemory();
			final long totalMemory = Runtime.getRuntime().totalMemory();
			final long usedMemory = totalMemory - freeMemory;
			final int threadActiveCount = Thread.activeCount();
			strings.add("Max Memory: " + format(maxMemory));
			strings.add("Total Memory: " + format(totalMemory));
			strings.add("Free Memory: " + format(freeMemory));
			strings.add("Used Memory: " + format(usedMemory));
			strings.add("Thread Active Count: " + threadActiveCount);
		}
		return Collections.unmodifiableCollection(strings);
	}

//	private static boolean withIp() {
//		return getHostName().startsWith("ip-");
//	}

	private static String hostname;

	public static synchronized String getHostName() {
		if (hostname == null) {
			hostname = getHostNameSlow();
		}
		return hostname;
	}

	private static String getHostNameSlow() {
		try {
			final InetAddress addr = InetAddress.getLocalHost();
			return addr.getHostName();
		} catch (Throwable e) {
			final Map<String, String> env = System.getenv();
			if (env.containsKey("COMPUTERNAME")) {
				return env.get("COMPUTERNAME");
			} else if (env.containsKey("HOSTNAME")) {
				return env.get("HOSTNAME");
			}
		}
		return "Unknown Computer";
	}

	private static String format(final long value) {
		return String.format(Locale.US, "%,d", value);
	}

	public static void printAbout() throws InterruptedException {
		for (String s : PSystemVersion.getAuthorsStrings(false)) {
			System.out.println(s);
		}
		exit(0);
	}

	public static void printLanguage() throws InterruptedException {
		new LanguageDescriptor().print(System.out);
		exit(0);
	}

}
