// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
/* +=======================================================================
 * |
 * |      PlantUML : a free UML diagram generator
 * |
 * +=======================================================================
 *
 * (C) Copyright 2009-2024, Arnaud Roques
 *
 * Project Info:  https://plantuml.com
 *
 * If you like this project or if you find it useful, you can support us at:
 *
 * https://plantuml.com/patreon (only 1$ per month!)
 * https://plantuml.com/liberapay (only 1€ per month!)
 * https://plantuml.com/paypal
 *
 *
 * PlantUML is free software; you can redistribute it and/or modify it
 * under the terms of the MIT License.
 *
 * See http://opensource.org/licenses/MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR
 * IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * PlantUML can occasionally display sponsored or advertising messages. Those
 * messages are usually generated on welcome or error images and never on
 * functional diagrams.
 * See https://plantuml.com/professional if you want to remove them
 *
 * Images (whatever their format : PNG, SVG, EPS...) generated by running PlantUML
 * are owned by the author of their corresponding sources code (that is, their
 * textual description in PlantUML language). Those images are not covered by
 * this MIT license.
 *
 * The generated images can then be used without any reference to the MIT license.
 * It is not even necessary to stipulate that they have been generated with PlantUML,
 * although this will be appreciated by the PlantUML team.
 *
 * There is an exception : if the textual description in PlantUML language is also covered
 * by any license, then the generated images are logically covered
 * by the very same license.
 *
 * This is the IGY distribution (Install GraphViz by Yourself).
 * You have to install GraphViz and to setup the GRAPHVIZ_DOT environment variable
 * (see https://plantuml.com/graphviz-dot )
 *
 * Icons provided by OpenIconic :  https://useiconic.com/open
 * Archimate sprites provided by Archi :  http://www.archimatetool.com
 * Stdlib AWS provided by https://github.com/milo-minderbinder/AWS-PlantUML
 * Stdlib Icons provided https://github.com/tupadr3/plantuml-icon-font-sprites
 * ASCIIMathML (c) Peter Jipsen http://www.chapman.edu/~jipsen
 * ASCIIMathML (c) David Lippman http://www.pierce.ctc.edu/dlippman
 * CafeUndZopfli ported by Eugene Klyuchnikov https://github.com/eustas/CafeUndZopfli
 * Brotli (c) by the Brotli Authors https://github.com/google/brotli
 * Themes (c) by Brett Schwarz https://github.com/bschwarz/puml-themes
 * Twemoji (c) by Twitter at https://twemoji.twitter.com/
 *
 */
package net.sourceforge.plantuml.argon2;

import static java.nio.charset.StandardCharsets.UTF_8;
import static net.sourceforge.plantuml.argon2.Constants.Defaults.LANES_DEF;
import static net.sourceforge.plantuml.argon2.Constants.Defaults.LOG_M_COST_DEF;
import static net.sourceforge.plantuml.argon2.Constants.Defaults.OUTLEN_DEF;
import static net.sourceforge.plantuml.argon2.Constants.Defaults.TYPE_DEF;
import static net.sourceforge.plantuml.argon2.Constants.Defaults.T_COST_DEF;
import static net.sourceforge.plantuml.argon2.Constants.Defaults.VERSION_DEF;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;

import net.sourceforge.plantuml.argon2.algorithm.FillMemory;
import net.sourceforge.plantuml.argon2.algorithm.Finalize;
import net.sourceforge.plantuml.argon2.algorithm.Initialize;
import net.sourceforge.plantuml.argon2.model.Argon2Type;
import net.sourceforge.plantuml.argon2.model.Instance;

public class Argon2 {
	// ::remove folder when __CORE__
	// ::remove folder when __HAXE__

	private byte[] output;
	private int outputLength; // -l N
	private double duration;

	private byte[] password;
	private byte[] salt;
	private byte[] secret;
	private byte[] additional;

	private int iterations; // -t N
	private int memory; // -m N
	private int lanes; // -p N

	private int version; // -v (10/13)
	private Argon2Type type;

	private boolean clearMemory = true;

	private boolean encodedOnly = false;
	private boolean rawOnly = false;

	Argon2() {
		this.lanes = LANES_DEF;
		this.outputLength = OUTLEN_DEF;
		this.memory = 1 << LOG_M_COST_DEF;
		this.iterations = T_COST_DEF;
		this.version = VERSION_DEF;
		this.type = TYPE_DEF;
	}

	private static byte[] toByteArray(char[] chars, Charset charset) {
		assert chars != null;

		CharBuffer charBuffer = CharBuffer.wrap(chars);
		ByteBuffer byteBuffer = charset.encode(charBuffer);
		byte[] bytes = Arrays.copyOfRange(byteBuffer.array(), byteBuffer.position(), byteBuffer.limit());
		Arrays.fill(byteBuffer.array(), (byte) 0);
		return bytes;
	}

	public void hashNow() {
		try {
			Validation.validateInput(this);

			long start = System.nanoTime();

			Instance instance = new Instance(this);

			Initialize.initialize(instance, this);
			FillMemory.fillMemoryBlocks(instance);
			Finalize.finalize(instance, this);

			duration = (System.nanoTime() - start) / 1000000000.0;
		} finally {
			clear();
		}
	}

	public void clear() {
		if (password != null)
			Arrays.fill(password, 0, password.length - 1, (byte) 0);

		if (salt != null)
			Arrays.fill(salt, 0, salt.length - 1, (byte) 0);

		if (secret != null)
			Arrays.fill(secret, 0, secret.length - 1, (byte) 0);

		if (additional != null)
			Arrays.fill(additional, 0, additional.length - 1, (byte) 0);
	}

	void printSummary() {
		if (encodedOnly)
			System.out.println(getEncoded());
		else if (rawOnly)
			System.out.println(getOutputString());
		else {
			System.out.println("Type:\t\t" + type);
			System.out.println("Iterations:\t" + iterations);
			System.out.println("Memory:\t\t" + memory + " KiB");
			System.out.println("Parallelism:\t" + lanes);
			System.out.println("Hash:\t\t" + getOutputString());
			System.out.println("Encoded:\t " + getEncoded());
			System.out.println(duration + " seconds");
		}
	}

	public Argon2 setMemoryInKiB(int memory) {
		this.memory = memory;
		return this;
	}

	public Argon2 setParallelism(int parallelism) {
		this.lanes = parallelism;
		return this;
	}

	public Argon2 setPassword(char[] password) {
		return setPassword(toByteArray(password, UTF_8));
	}

	public Argon2 setSalt(String salt) {
		return setSalt(salt.getBytes(UTF_8));
	}

	public byte[] getOutput() {
		return output;
	}

	public void setOutput(byte[] finalResult) {
		this.output = finalResult;
	}

	public String getOutputString() {
		return Util.bytesToHexString(output);
	}

	public int getOutputLength() {
		return outputLength;
	}

	public Argon2 setOutputLength(int outputLength) {
		this.outputLength = outputLength;
		return this;
	}

	public byte[] getPassword() {
		return password;
	}

	public Argon2 setPassword(byte[] password) {
		this.password = password;
		return this;
	}

	public int getPasswordLength() {
		return password.length;
	}

	public byte[] getSalt() {
		return salt;
	}

	public Argon2 setSalt(byte[] salt) {
		this.salt = salt;
		return this;
	}

	public int getSaltLength() {
		return salt.length;
	}

	public byte[] getSecret() {
		return secret;
	}

	public Argon2 setSecret(byte[] secret) {
		this.secret = secret;
		return this;
	}

	public int getSecretLength() {
		return secret != null ? secret.length : 0;
	}

	public byte[] getAdditional() {
		return additional;
	}

	public Argon2 setAdditional(byte[] additional) {
		this.additional = additional;
		return this;
	}

	public int getAdditionalLength() {
		return additional != null ? additional.length : 0;
	}

	public int getIterations() {
		return iterations;
	}

	public Argon2 setIterations(int iterations) {
		this.iterations = iterations;
		return this;
	}

	public int getMemory() {
		return memory;
	}

	public Argon2 setMemory(int memory) {
		this.memory = 1 << memory;
		return this;
	}

	public int getLanes() {
		return lanes;
	}

	public int getVersion() {
		return version;
	}

	public Argon2 setVersion(int version) {
		this.version = version;
		return this;
	}

	public Argon2Type getType() {
		return type;
	}

	public Argon2 setType(Argon2Type type) {
		this.type = type;
		return this;
	}

	public boolean isClearMemory() {
		return clearMemory;
	}

	public void setClearMemory(boolean clearMemory) {
		this.clearMemory = clearMemory;
	}

	public Charset getCharset() {
		return UTF_8;
	}

	public void setEncodedOnly(boolean encodedOnly) {
		this.encodedOnly = encodedOnly;
	}

	public void setRawOnly(boolean rawOnly) {
		this.rawOnly = rawOnly;
	}

	public String getEncoded() {
		return ""; // TODO
	}
}
