// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
/* +=======================================================================
 * |
 * |      PlantUML : a free UML diagram generator
 * |
 * +=======================================================================
 *
 * (C) Copyright 2009-2024, Arnaud Roques
 *
 * Project Info:  https://plantuml.com
 *
 * If you like this project or if you find it useful, you can support us at:
 *
 * https://plantuml.com/patreon (only 1$ per month!)
 * https://plantuml.com/liberapay (only 1€ per month!)
 * https://plantuml.com/paypal
 *
 *
 * PlantUML is free software; you can redistribute it and/or modify it
 * under the terms of the MIT License.
 *
 * See http://opensource.org/licenses/MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR
 * IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * PlantUML can occasionally display sponsored or advertising messages. Those
 * messages are usually generated on welcome or error images and never on
 * functional diagrams.
 * See https://plantuml.com/professional if you want to remove them
 *
 * Images (whatever their format : PNG, SVG, EPS...) generated by running PlantUML
 * are owned by the author of their corresponding sources code (that is, their
 * textual description in PlantUML language). Those images are not covered by
 * this MIT license.
 *
 * The generated images can then be used without any reference to the MIT license.
 * It is not even necessary to stipulate that they have been generated with PlantUML,
 * although this will be appreciated by the PlantUML team.
 *
 * There is an exception : if the textual description in PlantUML language is also covered
 * by any license, then the generated images are logically covered
 * by the very same license.
 *
 * This is the IGY distribution (Install GraphViz by Yourself).
 * You have to install GraphViz and to setup the GRAPHVIZ_DOT environment variable
 * (see https://plantuml.com/graphviz-dot )
 *
 * Icons provided by OpenIconic :  https://useiconic.com/open
 * Archimate sprites provided by Archi :  http://www.archimatetool.com
 * Stdlib AWS provided by https://github.com/milo-minderbinder/AWS-PlantUML
 * Stdlib Icons provided https://github.com/tupadr3/plantuml-icon-font-sprites
 * ASCIIMathML (c) Peter Jipsen http://www.chapman.edu/~jipsen
 * ASCIIMathML (c) David Lippman http://www.pierce.ctc.edu/dlippman
 * CafeUndZopfli ported by Eugene Klyuchnikov https://github.com/eustas/CafeUndZopfli
 * Brotli (c) by the Brotli Authors https://github.com/google/brotli
 * Themes (c) by Brett Schwarz https://github.com/bschwarz/puml-themes
 * Twemoji (c) by Twitter at https://twemoji.twitter.com/
 *
 */
package net.sourceforge.plantuml.bpm;

import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.HColors;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.geom.XPoint2D;
import net.sourceforge.plantuml.klimt.shape.UDrawable;
import net.sourceforge.plantuml.klimt.shape.ULine;
import net.sourceforge.plantuml.style.ISkinParam;

public class GridArray implements UDrawable {

	private final int lines;
	private final int cols;
	private final Placeable data[][];
	private final ISkinParam skinParam;

	// private final List<GridEdge> edges = new ArrayList<>();

	public GridArray(ISkinParam skinParam, int lines, int cols) {
		this.skinParam = skinParam;
		this.lines = lines;
		this.cols = cols;
		this.data = new Placeable[lines][cols];
	}

	@Override
	public String toString() {
		return "" + lines + "x" + cols;
	}

	public void setData(int l, int c, Placeable element) {
		data[l][c] = element;
	}

	public Placeable getData(int l, int c) {
		return data[l][c];
	}

	public final int getRows() {
		return cols;
	}

	public final int getLines() {
		return lines;
	}

	private double getHeightOfLine(StringBounder stringBounder, int line) {
		double height = 0;
		for (int i = 0; i < cols; i++) {
			final Placeable cell = data[line][i];
			if (cell == null) {
				continue;
			}
			height = Math.max(height, cell.getDimension(stringBounder, skinParam).getHeight());
		}
		return height;
	}

	private double getWidthOfCol(StringBounder stringBounder, int col) {
		double width = 0;
		for (int i = 0; i < lines; i++) {
			final Placeable cell = data[i][col];
			if (cell == null) {
				continue;
			}
			width = Math.max(width, cell.getDimension(stringBounder, skinParam).getWidth());
		}
		return width;
	}

	private final double margin = 30;

	public void drawU(UGraphic ug) {
		// printMe();

		final StringBounder stringBounder = ug.getStringBounder();

		// for (GridEdge edge : edges) {
		// // System.err.println("Drawing " + edge);
		// final int from[] = getCoord(edge.getFrom());
		// final int to[] = getCoord(edge.getTo());
		// final XPoint2D pt1 = getCenterOf(stringBounder, from[0], from[1]);
		// final XPoint2D pt2 = getCenterOf(stringBounder, to[0], to[1]);
		// drawArrow(ug, pt1, pt2);
		// }

		double dy = 0;
		drawInternalGrid(ug);
		for (int l = 0; l < lines; l++) {
			double dx = 0;
			final double heightOfLine = getHeightOfLine(stringBounder, l);
			for (int r = 0; r < cols; r++) {
				final double widthOfCol = getWidthOfCol(stringBounder, r);
				final Placeable cell = data[l][r];
				if (cell != null) {
					final XDimension2D dim = cell.getDimension(stringBounder, skinParam);

					cell.toTextBlock(skinParam)
							.drawU(ug.apply(new UTranslate(dx + (widthOfCol + margin - dim.getWidth()) / 2,
									dy + (heightOfLine + margin - dim.getHeight()) / 2)));
				}
				dx += widthOfCol + margin;
			}
			dy += heightOfLine + margin;
		}

	}

	private void drawInternalGrid(UGraphic ug) {
		double heightMax = 0;
		for (int l = 0; l < lines; l++) {
			heightMax += getHeightOfLine(ug.getStringBounder(), l) + margin;
		}
		double widthMax = 0;
		for (int c = 0; c < cols; c++) {
			widthMax += getWidthOfCol(ug.getStringBounder(), c) + margin;
		}
		ug = ug.apply(HColors.BLACK);
		double y = 0;
		for (int l = 0; l < lines; l++) {
			ug.apply(UTranslate.dy(y)).draw(ULine.hline(widthMax));
			y += getHeightOfLine(ug.getStringBounder(), l) + margin;
		}
		double x = 0;
		for (int c = 0; c < cols; c++) {
			ug.apply(UTranslate.dx(x)).draw(ULine.vline(heightMax));
			x += getWidthOfCol(ug.getStringBounder(), c) + margin;
		}

	}

	private void drawArrow(UGraphic ug, XPoint2D pt1, XPoint2D pt2) {
		ug = ug.apply(HColors.BLUE);
		final ULine line = new ULine(pt2.getX() - pt1.getX(), pt2.getY() - pt1.getY());
		ug.apply(UTranslate.point(pt1)).draw(line);
	}

	private XPoint2D getCenterOf(StringBounder stringBounder, int c, int l) {
		double x = getWidthOfCol(stringBounder, c) / 2 + margin / 2;
		for (int i = 0; i < c; i++) {
			final double widthOfCol = getWidthOfCol(stringBounder, i);
			x += widthOfCol + margin;
		}
		double y = getHeightOfLine(stringBounder, l) / 2 + margin / 2;
		for (int i = 0; i < l; i++) {
			final double heightOfLine = getHeightOfLine(stringBounder, i);
			y += heightOfLine + margin;
		}
		return new XPoint2D(x, y);
	}

	private int[] getCoord(Cell someCell) {
		for (int l = 0; l < lines; l++) {
			for (int c = 0; c < cols; c++) {
				final Placeable cell = data[l][c];
				if (cell == someCell.getData()) {
					return new int[] { c, l };
				}
			}
		}
		throw new IllegalArgumentException();
	}

	private void printMe() {
		for (int l = 0; l < lines; l++) {
			for (int c = 0; c < cols; c++) {
				final Placeable cell = data[l][c];
				System.err.print(cell);
				System.err.print("  ;  ");
			}
			System.err.println();
		}
	}

	// void addEdgesInternal(List<GridEdge> edges) {
	// this.edges.addAll(edges);
	// }

}
