// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
/* +=======================================================================
 * |
 * |      PlantUML : a free UML diagram generator
 * |
 * +=======================================================================
 *
 * (C) Copyright 2009-2024, Arnaud Roques
 *
 * Project Info:  https://plantuml.com
 *
 * If you like this project or if you find it useful, you can support us at:
 *
 * https://plantuml.com/patreon (only 1$ per month!)
 * https://plantuml.com/liberapay (only 1€ per month!)
 * https://plantuml.com/paypal
 *
 *
 * PlantUML is free software; you can redistribute it and/or modify it
 * under the terms of the MIT License.
 *
 * See http://opensource.org/licenses/MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR
 * IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * PlantUML can occasionally display sponsored or advertising messages. Those
 * messages are usually generated on welcome or error images and never on
 * functional diagrams.
 * See https://plantuml.com/professional if you want to remove them
 *
 * Images (whatever their format : PNG, SVG, EPS...) generated by running PlantUML
 * are owned by the author of their corresponding sources code (that is, their
 * textual description in PlantUML language). Those images are not covered by
 * this MIT license.
 *
 * The generated images can then be used without any reference to the MIT license.
 * It is not even necessary to stipulate that they have been generated with PlantUML,
 * although this will be appreciated by the PlantUML team.
 *
 * There is an exception : if the textual description in PlantUML language is also covered
 * by any license, then the generated images are logically covered
 * by the very same license.
 *
 * This is the IGY distribution (Install GraphViz by Yourself).
 * You have to install GraphViz and to setup the GRAPHVIZ_DOT environment variable
 * (see https://plantuml.com/graphviz-dot )
 *
 * Icons provided by OpenIconic :  https://useiconic.com/open
 * Archimate sprites provided by Archi :  http://www.archimatetool.com
 * Stdlib AWS provided by https://github.com/milo-minderbinder/AWS-PlantUML
 * Stdlib Icons provided https://github.com/tupadr3/plantuml-icon-font-sprites
 * ASCIIMathML (c) Peter Jipsen http://www.chapman.edu/~jipsen
 * ASCIIMathML (c) David Lippman http://www.pierce.ctc.edu/dlippman
 * CafeUndZopfli ported by Eugene Klyuchnikov https://github.com/eustas/CafeUndZopfli
 * Brotli (c) by the Brotli Authors https://github.com/google/brotli
 * Themes (c) by Brett Schwarz https://github.com/bschwarz/puml-themes
 * Twemoji (c) by Twitter at https://twemoji.twitter.com/
 *
 */
package net.sourceforge.plantuml.cheneer.command;

import java.util.ArrayList;
import java.util.List;

import net.sourceforge.plantuml.abel.Entity;
import net.sourceforge.plantuml.abel.LeafType;
import net.sourceforge.plantuml.abel.Link;
import net.sourceforge.plantuml.abel.LinkArg;
import net.sourceforge.plantuml.cheneer.ChenEerDiagram;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.ParserPass;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.decoration.LinkDecor;
import net.sourceforge.plantuml.decoration.LinkType;
import net.sourceforge.plantuml.klimt.color.ColorParser;
import net.sourceforge.plantuml.klimt.color.ColorType;
import net.sourceforge.plantuml.klimt.color.Colors;
import net.sourceforge.plantuml.klimt.color.NoSuchColorException;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.plasma.Quark;
import net.sourceforge.plantuml.regex.IRegex;
import net.sourceforge.plantuml.regex.RegexConcat;
import net.sourceforge.plantuml.regex.RegexLeaf;
import net.sourceforge.plantuml.regex.RegexResult;
import net.sourceforge.plantuml.utils.LineLocation;

public class CommandMultiSubclass extends SingleLineCommand2<ChenEerDiagram> {

	public CommandMultiSubclass() {
		super(getRegexConcat());
	}

	protected static IRegex getRegexConcat() {
		return RegexConcat.build(CommandCreateEntity.class.getName(), RegexLeaf.start(), //
				new RegexLeaf("SUPERCLASS", "([\\w-]+)"), //
				RegexLeaf.spaceZeroOrMore(), //
				new RegexLeaf("PARTICIPATION", "([-=])"), //
				new RegexLeaf("(>)"), //
				new RegexLeaf("PARTICIPATION2", "([-=])"), //
				RegexLeaf.spaceZeroOrMore(), //
				new RegexLeaf("SYMBOL", "([doU])"), //
				RegexLeaf.spaceZeroOrMore(), //
				new RegexLeaf("\\{"), //
				new RegexLeaf("SUBCLASSES", "(.+)"), //
				new RegexLeaf("\\}"), //
				RegexLeaf.spaceZeroOrMore(), //
				color().getRegex(), //
				RegexLeaf.end());
	}

	private static ColorParser color() {
		return ColorParser.simpleColor(ColorType.BACK);
	}

	@Override
	protected CommandExecutionResult executeArg(ChenEerDiagram diagram, LineLocation location, RegexResult arg, ParserPass currentPass)
			throws NoSuchColorException {
		final String superclass = diagram.cleanId(arg.get("SUPERCLASS", 0));
		final String subclasses = arg.get("SUBCLASSES", 0);

		final List<String> subclassIds = new ArrayList<String>();

		for (String subclass : subclasses.split(","))
			subclassIds.add(diagram.cleanId(subclass.trim()));

		final boolean isDouble = arg.get("PARTICIPATION", 0).equals("=");
		final String symbol = arg.get("SYMBOL", 0);

		final Colors colors = color().getColor(arg, diagram.getSkinParam().getIHtmlColorSet());

		final Quark<Entity> centerQuark = diagram.quarkInContext(false,
				superclass + "/" + symbol + subclasses + "/center");
		final Entity centerEntity = diagram.reallyCreateLeaf(centerQuark, Display.create(symbol), LeafType.CHEN_CIRCLE,
				null);

		centerEntity.setColors(colors);

		final Quark<Entity> superclassQuark = diagram.quarkInContext(true, superclass);
		final Entity superclassEntity = superclassQuark.getData();
		if (superclassEntity == null) {
			return CommandExecutionResult.error("No such entity: " + superclass);
		}

		LinkType linkType = new LinkType(LinkDecor.NONE, LinkDecor.NONE);
		if (isDouble) {
			linkType = linkType.goBold();
		}
		if (symbol.equals("U")) {
			linkType = linkType.withMiddleSuperset();
		}
		final Link link = new Link(diagram, diagram.getCurrentStyleBuilder(), superclassEntity,
				centerEntity, linkType, LinkArg.build(Display.NULL, 2));
		link.setPortMembers(diagram.getPortId(superclassEntity.getName()), diagram.getPortId(centerEntity.getName()));
		link.setColors(colors);
		diagram.addLink(link);

		for (String subclass : subclassIds) {
			final Quark<Entity> subclassQuark = diagram.quarkInContext(true, subclass);
			final Entity subclassEntity = subclassQuark.getData();
			if (subclassEntity == null) {
				return CommandExecutionResult.error("No such entity: " + subclass);
			}

			LinkType subclassLinkType = new LinkType(LinkDecor.NONE, LinkDecor.NONE);
			if (!symbol.equals("U")) {
				subclassLinkType = subclassLinkType.withMiddleSuperset();
			}
			final Link subclassLink = new Link(diagram, diagram.getCurrentStyleBuilder(), centerEntity,
					subclassEntity, subclassLinkType, LinkArg.build(Display.NULL, 3));
			subclassLink.setColors(colors);
			diagram.addLink(subclassLink);
		}

		return CommandExecutionResult.ok();
	}

}
