// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
/* +=======================================================================
 * |
 * |      PlantUML : a free UML diagram generator
 * |
 * +=======================================================================
 *
 * (C) Copyright 2009-2024, Arnaud Roques
 *
 * Project Info:  https://plantuml.com
 *
 * If you like this project or if you find it useful, you can support us at:
 *
 * https://plantuml.com/patreon (only 1$ per month!)
 * https://plantuml.com/liberapay (only 1€ per month!)
 * https://plantuml.com/paypal
 *
 *
 * PlantUML is free software; you can redistribute it and/or modify it
 * under the terms of the MIT License.
 *
 * See http://opensource.org/licenses/MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR
 * IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * PlantUML can occasionally display sponsored or advertising messages. Those
 * messages are usually generated on welcome or error images and never on
 * functional diagrams.
 * See https://plantuml.com/professional if you want to remove them
 *
 * Images (whatever their format : PNG, SVG, EPS...) generated by running PlantUML
 * are owned by the author of their corresponding sources code (that is, their
 * textual description in PlantUML language). Those images are not covered by
 * this MIT license.
 *
 * The generated images can then be used without any reference to the MIT license.
 * It is not even necessary to stipulate that they have been generated with PlantUML,
 * although this will be appreciated by the PlantUML team.
 *
 * There is an exception : if the textual description in PlantUML language is also covered
 * by any license, then the generated images are logically covered
 * by the very same license.
 *
 * This is the IGY distribution (Install GraphViz by Yourself).
 * You have to install GraphViz and to setup the GRAPHVIZ_DOT environment variable
 * (see https://plantuml.com/graphviz-dot )
 *
 * Icons provided by OpenIconic :  https://useiconic.com/open
 * Archimate sprites provided by Archi :  http://www.archimatetool.com
 * Stdlib AWS provided by https://github.com/milo-minderbinder/AWS-PlantUML
 * Stdlib Icons provided https://github.com/tupadr3/plantuml-icon-font-sprites
 * ASCIIMathML (c) Peter Jipsen http://www.chapman.edu/~jipsen
 * ASCIIMathML (c) David Lippman http://www.pierce.ctc.edu/dlippman
 * CafeUndZopfli ported by Eugene Klyuchnikov https://github.com/eustas/CafeUndZopfli
 * Brotli (c) by the Brotli Authors https://github.com/google/brotli
 * Themes (c) by Brett Schwarz https://github.com/bschwarz/puml-themes
 * Twemoji (c) by Twitter at https://twemoji.twitter.com/
 *
 */
package net.sourceforge.plantuml.cucadiagram;

import net.sourceforge.plantuml.json.JsonArray;
import net.sourceforge.plantuml.json.JsonObject;
import net.sourceforge.plantuml.json.JsonValue;
import net.sourceforge.plantuml.klimt.LineBreakStrategy;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.creole.CreoleMode;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.AbstractTextBlock;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.TextBlockUtils;
import net.sourceforge.plantuml.klimt.shape.ULine;
import net.sourceforge.plantuml.style.ISkinParam;
import net.sourceforge.plantuml.svek.Ports;
import net.sourceforge.plantuml.svek.WithPorts;

public class TextBlockCucaJSon extends AbstractTextBlock implements WithPorts {

	private final ISkinParam skinParam;
	private final FontConfiguration fontConfiguration;
	private final JsonValue json;
	private TextBlock jsonTextBlock;
	private double mainTotalWidth;
	private final LineBreakStrategy wordWrap;

	public TextBlockCucaJSon(FontConfiguration fontConfiguration, ISkinParam skinParam, JsonValue json,
			LineBreakStrategy wordWrap) {
		this.skinParam = skinParam;
		this.json = json;
		this.fontConfiguration = fontConfiguration;
		this.wordWrap = wordWrap;
	}

	private TextBlock getJsonTextBlock() {
		if (jsonTextBlock == null)
			this.jsonTextBlock = getTextBlockValue(json, 0);

		if (jsonTextBlock instanceof TextBlockJson)
			((TextBlockJson) jsonTextBlock).jsonTotalWidth = mainTotalWidth;
		if (jsonTextBlock instanceof TextBlockArray)
			((TextBlockArray) jsonTextBlock).arrayTotalWidth = mainTotalWidth;
		
		return jsonTextBlock;
	}

	private TextBlock getTextBlockValue(JsonValue value, double width2) {
		if (value.isString() || value.isNull() || value.isTrue() || value.isFalse() || value.isNumber()) {
			final String tmp = value.isString() ? value.asString() : value.toString();
			return getTextBlock(tmp);
		}
		if (value.isArray())
			return new TextBlockArray(value.asArray(), width2);
		if (value.isObject())
			return new TextBlockJson(value.asObject(), width2);

		final String tmp = value.getClass().getSimpleName();
		return getTextBlock(tmp);
	}

	@Override
	public Ports getPorts(StringBounder stringBounder) {
		return new Ports();
	}

	public XDimension2D calculateDimension(StringBounder stringBounder) {
		return getJsonTextBlock().calculateDimension(stringBounder);
	}

	public void drawU(UGraphic ug) {
		getJsonTextBlock().drawU(ug);
	}

	class TextBlockJson extends AbstractTextBlock {

		private final JsonObject obj;
		private double jsonTotalWidth;

		public TextBlockJson(JsonObject json, double totalWidth) {
			this.obj = json;
			this.jsonTotalWidth = totalWidth;
		}

		@Override
		public XDimension2D calculateDimension(StringBounder stringBounder) {
			return new XDimension2D(getWidth1(stringBounder) + getWidth2(stringBounder), getHeight(stringBounder));
		}

		private double getWidth1(StringBounder stringBounder) {
			double result = 0;
			for (JsonObject.Member s : obj) {
				final TextBlock tb1 = getTextBlock(s.getName());
				result = Math.max(result, tb1.calculateDimension(stringBounder).getWidth());
			}
			return result;
		}

		private double getWidth2(StringBounder stringBounder) {
			double result = 0;
			for (JsonObject.Member s : obj) {
				final TextBlock tb2 = getTextBlockValue(s.getValue(), jsonTotalWidth);
				result = Math.max(result, tb2.calculateDimension(stringBounder).getWidth());
			}
			return result;
		}

		private double getHeight(StringBounder stringBounder) {
			double result = 0;
			for (JsonObject.Member s : obj) {
				final TextBlock tb1 = getTextBlock(s.getName());
				final TextBlock tb2 = getTextBlockValue(s.getValue(), jsonTotalWidth);
				final XDimension2D dim1 = tb1.calculateDimension(stringBounder);
				final XDimension2D dim2 = tb2.calculateDimension(stringBounder);
				result += Math.max(dim1.getHeight(), dim2.getHeight());
			}
			return result;
		}

		@Override
		public void drawU(UGraphic ug) {
			final StringBounder stringBounder = ug.getStringBounder();
			final double width1 = getWidth1(stringBounder);
			final double height = getHeight(stringBounder);
			ug.apply(UTranslate.dx(width1)).draw(ULine.vline(height));
			final ULine hline = ULine.hline(this.jsonTotalWidth);
			for (JsonObject.Member s : obj) {
				final TextBlock tb1 = getTextBlock(s.getName());
				final TextBlock tb2 = getTextBlockValue(s.getValue(), this.jsonTotalWidth - width1);
				final XDimension2D dim1 = tb1.calculateDimension(stringBounder);
				final XDimension2D dim2 = tb2.calculateDimension(stringBounder);
				ug.draw(hline);
				tb1.drawU(ug);
				tb2.drawU(ug.apply(UTranslate.dx(width1)));
				ug = ug.apply(UTranslate.dy(Math.max(dim1.getHeight(), dim2.getHeight())));
			}

		}

	}

	private TextBlock getTextBlock(String key) {
		final Display display = Display.getWithNewlines(key);
		TextBlock result = display.create0(getFontConfiguration(), HorizontalAlignment.LEFT, skinParam, wordWrap,
				CreoleMode.FULL, null, null);
		result = TextBlockUtils.withMargin(result, 5, 2);
		return result;
	}

	class TextBlockArray extends AbstractTextBlock {

		private final JsonArray array;
		private double arrayTotalWidth;

		public TextBlockArray(JsonArray array, double totalWidth) {
			this.array = array;
			this.arrayTotalWidth = totalWidth;
		}

		@Override
		public XDimension2D calculateDimension(StringBounder stringBounder) {
			XDimension2D result = new XDimension2D(0, 0);
			for (JsonValue element : array) {
				final TextBlock tb = getTextBlockValue(element, arrayTotalWidth);
				final XDimension2D dim = tb.calculateDimension(stringBounder);
				result = result.mergeTB(dim);
			}
			return result;
		}

		@Override
		public void drawU(UGraphic ug) {
			final ULine hline = ULine.hline(this.arrayTotalWidth);
			int nb = 0;
			for (JsonValue element : array) {
				final TextBlock tb = getTextBlockValue(element, arrayTotalWidth);
				if (nb > 0)
					ug.draw(hline);
				nb++;
				tb.drawU(ug);
				ug = ug.apply(UTranslate.dy(tb.calculateDimension(ug.getStringBounder()).getHeight()));
			}
		}

	}

	private FontConfiguration getFontConfiguration() {
		return fontConfiguration;
	}

	public void setTotalWidth(double totalWidth) {
		this.mainTotalWidth = totalWidth;
	}

}
