// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
/* +=======================================================================
 * |
 * |      PlantUML : a free UML diagram generator
 * |
 * +=======================================================================
 *
 * (C) Copyright 2009-2024, Arnaud Roques
 *
 * Project Info:  https://plantuml.com
 *
 * If you like this project or if you find it useful, you can support us at:
 *
 * https://plantuml.com/patreon (only 1$ per month!)
 * https://plantuml.com/liberapay (only 1€ per month!)
 * https://plantuml.com/paypal
 *
 *
 * PlantUML is free software; you can redistribute it and/or modify it
 * under the terms of the MIT License.
 *
 * See http://opensource.org/licenses/MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR
 * IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * PlantUML can occasionally display sponsored or advertising messages. Those
 * messages are usually generated on welcome or error images and never on
 * functional diagrams.
 * See https://plantuml.com/professional if you want to remove them
 *
 * Images (whatever their format : PNG, SVG, EPS...) generated by running PlantUML
 * are owned by the author of their corresponding sources code (that is, their
 * textual description in PlantUML language). Those images are not covered by
 * this MIT license.
 *
 * The generated images can then be used without any reference to the MIT license.
 * It is not even necessary to stipulate that they have been generated with PlantUML,
 * although this will be appreciated by the PlantUML team.
 *
 * There is an exception : if the textual description in PlantUML language is also covered
 * by any license, then the generated images are logically covered
 * by the very same license.
 *
 * This is the IGY distribution (Install GraphViz by Yourself).
 * You have to install GraphViz and to setup the GRAPHVIZ_DOT environment variable
 * (see https://plantuml.com/graphviz-dot )
 *
 * Icons provided by OpenIconic :  https://useiconic.com/open
 * Archimate sprites provided by Archi :  http://www.archimatetool.com
 * Stdlib AWS provided by https://github.com/milo-minderbinder/AWS-PlantUML
 * Stdlib Icons provided https://github.com/tupadr3/plantuml-icon-font-sprites
 * ASCIIMathML (c) Peter Jipsen http://www.chapman.edu/~jipsen
 * ASCIIMathML (c) David Lippman http://www.pierce.ctc.edu/dlippman
 * CafeUndZopfli ported by Eugene Klyuchnikov https://github.com/eustas/CafeUndZopfli
 * Brotli (c) by the Brotli Authors https://github.com/google/brotli
 * Themes (c) by Brett Schwarz https://github.com/bschwarz/puml-themes
 * Twemoji (c) by Twitter at https://twemoji.twitter.com/
 *
 */
package net.sourceforge.plantuml.ebnf;

import java.util.ArrayList;
import java.util.List;

import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;

public class ETileAlternation extends ETile {

	private final List<ETile> tiles = new ArrayList<>();
	private final double marginx = 12;
	private boolean inZeroOrMore;

	@Override
	public void push(ETile tile) {
		tiles.add(0, tile);
	}

	@Override
	public double getH1(StringBounder stringBounder) {
		return tiles.get(0).getH1(stringBounder);
	}

	@Override
	public double getH2(StringBounder stringBounder) {
		double height = tiles.get(0).getH2(stringBounder);
		for (int i = 1; i < tiles.size(); i++) {
			final ETile tile = tiles.get(i);
			height += tile.getH1(stringBounder);
			height += tile.getH2(stringBounder);
			height += 10;
		}
		return height;
	}

	@Override
	public double getWidth(StringBounder stringBounder) {
		double width = 0;
		for (ETile tile : tiles) {
			final XDimension2D dim = tile.calculateDimension(stringBounder);
			width = Math.max(width, dim.getWidth());
		}
		width += 2 * 2 * marginx;
		return width;
	}

	@Override
	public void drawU(UGraphic ug) {
		final StringBounder stringBounder = ug.getStringBounder();

		double y = 0;
		double lastLinePos = 0;

		final double a = 0;
		final double b = a + marginx;
		final double c = b + marginx;

		final XDimension2D fullDim = calculateDimension(stringBounder);

		final double r = fullDim.getWidth();
		final double q = r - marginx;
		final double p = q - marginx;

		final double linePos = getH1(stringBounder);

		if (inZeroOrMore) {
			for (int i = 0; i < tiles.size(); i++) {
				final ETile tile = tiles.get(i);
				final XDimension2D dim = tile.calculateDimension(stringBounder);
				lastLinePos = y + tile.getH1(stringBounder);
				tile.drawU(ug.apply(new UTranslate(c, y)));

				CornerCurved.createSW(marginx).drawU(ug.apply(new UTranslate(b, lastLinePos)));
				drawHlineDirected(ug, lastLinePos, c + dim.getWidth(), p, 0.3, 25);
				CornerCurved.createSE(marginx).drawU(ug.apply(new UTranslate(q, lastLinePos)));

				y += dim.getHeight() + 10;

			}
			drawVline(ug, b, 0, lastLinePos - marginx);
			drawVline(ug, q, 0, lastLinePos - marginx);

		} else {
			for (int i = 0; i < tiles.size(); i++) {
				final ETile tile = tiles.get(i);
				final XDimension2D dim = tile.calculateDimension(stringBounder);
				lastLinePos = y + tile.getH1(stringBounder);
				tile.drawU(ug.apply(new UTranslate(c, y)));

				if (i == 0) {
					drawHline(ug, lastLinePos, a, c);
					drawHline(ug, lastLinePos, c + dim.getWidth(), r);
				} else if (i > 0 && i < tiles.size() - 1) {
					CornerCurved.createSW(marginx).drawU(ug.apply(new UTranslate(b, lastLinePos)));
					drawHlineDirected(ug, lastLinePos, c + dim.getWidth(), p, 0.5, 25);
					CornerCurved.createSE(marginx).drawU(ug.apply(new UTranslate(q, lastLinePos)));
				} else if (i == tiles.size() - 1) {
					drawHlineDirected(ug, lastLinePos, c + dim.getWidth(), p, 0.5, 25);

				}
				y += dim.getHeight() + 10;
			}

			final double height42 = lastLinePos - linePos;
			final UGraphic ug_b = ug.apply(new UTranslate(b, linePos));
			final UGraphic ug_q = ug.apply(new UTranslate(q, linePos));

			CornerCurved.createSW(marginx).drawU(ug_b.apply(UTranslate.dy(height42)));
			drawVline(ug_b, 0, marginx, height42 - marginx);
			CornerCurved.createNE(marginx).drawU(ug_b);

			CornerCurved.createSE(marginx).drawU(ug_q.apply(UTranslate.dy(height42)));
			drawVline(ug_q, 0, marginx, height42 - marginx);
			CornerCurved.createNW(marginx).drawU(ug_q);

		}

	}

	public void setInZeroOrMore(boolean inZeroOrMore) {
		this.inZeroOrMore = true;

	}

}
