// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
/* +=======================================================================
 * |
 * |      PlantUML : a free UML diagram generator
 * |
 * +=======================================================================
 *
 * (C) Copyright 2009-2024, Arnaud Roques
 *
 * Project Info:  https://plantuml.com
 *
 * If you like this project or if you find it useful, you can support us at:
 *
 * https://plantuml.com/patreon (only 1$ per month!)
 * https://plantuml.com/liberapay (only 1€ per month!)
 * https://plantuml.com/paypal
 *
 *
 * PlantUML is free software; you can redistribute it and/or modify it
 * under the terms of the MIT License.
 *
 * See http://opensource.org/licenses/MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR
 * IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * PlantUML can occasionally display sponsored or advertising messages. Those
 * messages are usually generated on welcome or error images and never on
 * functional diagrams.
 * See https://plantuml.com/professional if you want to remove them
 *
 * Images (whatever their format : PNG, SVG, EPS...) generated by running PlantUML
 * are owned by the author of their corresponding sources code (that is, their
 * textual description in PlantUML language). Those images are not covered by
 * this MIT license.
 *
 * The generated images can then be used without any reference to the MIT license.
 * It is not even necessary to stipulate that they have been generated with PlantUML,
 * although this will be appreciated by the PlantUML team.
 *
 * There is an exception : if the textual description in PlantUML language is also covered
 * by any license, then the generated images are logically covered
 * by the very same license.
 *
 * This is the IGY distribution (Install GraphViz by Yourself).
 * You have to install GraphViz and to setup the GRAPHVIZ_DOT environment variable
 * (see https://plantuml.com/graphviz-dot )
 *
 * Icons provided by OpenIconic :  https://useiconic.com/open
 * Archimate sprites provided by Archi :  http://www.archimatetool.com
 * Stdlib AWS provided by https://github.com/milo-minderbinder/AWS-PlantUML
 * Stdlib Icons provided https://github.com/tupadr3/plantuml-icon-font-sprites
 * ASCIIMathML (c) Peter Jipsen http://www.chapman.edu/~jipsen
 * ASCIIMathML (c) David Lippman http://www.pierce.ctc.edu/dlippman
 * CafeUndZopfli ported by Eugene Klyuchnikov https://github.com/eustas/CafeUndZopfli
 * Brotli (c) by the Brotli Authors https://github.com/google/brotli
 * Themes (c) by Brett Schwarz https://github.com/bschwarz/puml-themes
 * Twemoji (c) by Twitter at https://twemoji.twitter.com/
 *
 */
package net.sourceforge.plantuml.ebnf;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.FloatingNote;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.TextBlockUtils;
import net.sourceforge.plantuml.style.ISkinParam;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.utils.CharInspector;

public class EbnfExpression implements TextBlockable {

	private final List<Token> tokens = new ArrayList<>();
	private final boolean isCompact;
	private final String commentAbove;
	private final String commentBelow;

	public static EbnfExpression create(CharInspector it, boolean isCompact, String commentAbove, String commentBelow) {
		return new EbnfExpression(it, isCompact, commentAbove, commentBelow);
	}

	private EbnfExpression(CharInspector it, boolean isCompact, String commentAbove, String commentBelow) {
		this.isCompact = isCompact;
		this.commentAbove = commentAbove;
		this.commentBelow = commentBelow;
		while (true) {
			final char ch = it.peek(0);
			if (Character.isWhitespace(ch)) {
			} else if (ch == '-') {
				tokens.add(new Token(Symbol.NOT, null));
			} else if (isLetterOrDigit(ch)) {
				final String litteral = readLitteral(it);
				tokens.add(new Token(Symbol.LITTERAL, litteral));
				continue;
			} else if (ch == '*') {
				tokens.add(new Token(Symbol.REPETITION_SYMBOL, null));
			} else if (ch == '(' && it.peek(1) == '*') {
				final String comment = readComment(it);
				if (comment.trim().length() > 0)
					tokens.add(new Token(Symbol.COMMENT_TOKEN, comment));
				continue;
			} else if (ch == ',') {
				tokens.add(new Token(Symbol.CONCATENATION, null));
			} else if (ch == '|') {
				tokens.add(new Token(Symbol.ALTERNATION, null));
			} else if (ch == '=') {
				tokens.add(new Token(Symbol.DEFINITION, null));
			} else if (ch == '(') {
				tokens.add(new Token(Symbol.GROUPING_OPEN, null));
			} else if (ch == ')') {
				tokens.add(new Token(Symbol.GROUPING_CLOSE, null));
			} else if (ch == '[') {
				tokens.add(new Token(Symbol.OPTIONAL_OPEN, null));
			} else if (ch == ']') {
				tokens.add(new Token(Symbol.OPTIONAL_CLOSE, null));
			} else if (ch == '{') {
				tokens.add(new Token(Symbol.REPETITION_OPEN, null));
			} else if (ch == '}' && it.peek(1) == '-') {
				tokens.add(new Token(Symbol.REPETITION_MINUS_CLOSE, null));
				it.jump();
			} else if (ch == '}') {
				tokens.add(new Token(Symbol.REPETITION_CLOSE, null));
			} else if (ch == ';' || ch == 0) {
				// it.next();
				break;
			} else if (ch == '\"') {
				final String litteral = readString(it);
				tokens.add(new Token(Symbol.TERMINAL_STRING1, protect(litteral)));
			} else if (ch == '\'') {
				final String litteral = readString(it);
				tokens.add(new Token(Symbol.TERMINAL_STRING2, protect(litteral)));
			} else if (ch == '?') {
				final String litteral = readString(it);
				tokens.add(new Token(Symbol.SPECIAL_SEQUENCE, protect(litteral)));
			} else {
				tokens.clear();
				return;
			}
			it.jump();
			continue;
		}
	}

	private static String protect(final String litteral) {
		return litteral.length() == 0 ? " " : litteral;
	}

	public TextBlock getUDrawable(ISkinParam skinParam) {
		final Style style = ETile.getStyleSignature().getMergedStyle(skinParam.getCurrentStyleBuilder());
		final FontConfiguration fc = style.getFontConfiguration(skinParam.getIHtmlColorSet());

		if (tokens.size() == 0)
			return EbnfEngine.syntaxError(fc, skinParam);

		try {
			final Iterator<Token> iterator = tokens.iterator();
			final Token name = iterator.next();
			final Token definition = iterator.next();
			if (definition.getSymbol() != Symbol.DEFINITION)
				return EbnfEngine.syntaxError(fc, skinParam);

			final TextBlock main;
			if (iterator.hasNext()) {
				final List<Token> full = new ShuntingYard(iterator).getOuputQueue();
				if (full.size() == 0)
					return EbnfEngine.syntaxError(fc, skinParam);

				main = getMainDrawing(skinParam, full.iterator());
			} else {
				final HColor lineColor = style.value(PName.LineColor).asColor(skinParam.getIHtmlColorSet());
				main = new ETileWithCircles(new ETileEmpty(), lineColor);
			}

			TextBlock titleBox = new TitleBox(name.getData(), fc);
			if (commentAbove != null)
				titleBox = TextBlockUtils.mergeTB(getNoteAbove(skinParam), titleBox, HorizontalAlignment.CENTER);
			if (commentBelow != null)
				titleBox = TextBlockUtils.mergeTB(titleBox, getNoteBelow(skinParam), HorizontalAlignment.CENTER);

			return TextBlockUtils.mergeTB(titleBox, TextBlockUtils.withMargin(main, 0, 0, 10, 15),
					HorizontalAlignment.LEFT);
		} catch (Exception e) {
			e.printStackTrace();
			return EbnfEngine.syntaxError(fc, skinParam);
		}
	}

	private TextBlock getNoteAbove(ISkinParam skinParam) {
		if (commentAbove == null)
			return null;
		final FloatingNote note = FloatingNote.create(Display.getWithNewlines(commentAbove), skinParam, SName.ebnf);
		return note;
	}

	private TextBlock getNoteBelow(ISkinParam skinParam) {
		if (commentBelow == null)
			return null;
		final FloatingNote note = FloatingNote.create(Display.getWithNewlines(commentBelow), skinParam, SName.ebnf);
		return note;
	}

	private TextBlock getMainDrawing(ISkinParam skinParam, Iterator<Token> it) {
		final EbnfEngine engine = new EbnfEngine(skinParam);
		while (it.hasNext()) {
			final Token element = it.next();
			if (element.getSymbol() == Symbol.TERMINAL_STRING1 || element.getSymbol() == Symbol.TERMINAL_STRING2
					|| element.getSymbol() == Symbol.LITTERAL || element.getSymbol() == Symbol.SPECIAL_SEQUENCE)
				engine.push(element);
			else if (element.getSymbol() == Symbol.COMMENT_ABOVE)
				engine.commentAbove(element.getData());
			else if (element.getSymbol() == Symbol.COMMENT_BELOW)
				engine.commentBelow(element.getData());
			else if (element.getSymbol() == Symbol.ALTERNATION)
				engine.alternation();
			else if (element.getSymbol() == Symbol.CONCATENATION)
				engine.concatenation();
			else if (element.getSymbol() == Symbol.OPTIONAL)
				engine.optional();
			else if (element.getSymbol() == Symbol.NOT)
				engine.not();
			else if (element.getSymbol() == Symbol.REPETITION_ZERO_OR_MORE)
				engine.repetitionZeroOrMore(isCompact);
			else if (element.getSymbol() == Symbol.REPETITION_ONE_OR_MORE)
				engine.repetitionOneOrMore();
			else if (element.getSymbol() == Symbol.REPETITION_SYMBOL)
				engine.repetitionSymbol();
			else
				throw new UnsupportedOperationException(element.toString());
		}

		return engine.getTextBlock();
	}

	private String readString(CharInspector it) {
		final char separator = it.peek(0);
		it.jump();
		final StringBuilder sb = new StringBuilder();
		while (true) {
			final char ch = it.peek(0);
			if (ch == separator)
				return sb.toString();
			sb.append(ch);
			it.jump();
		}
	}

	private String readLitteral(CharInspector it) {
		final StringBuilder sb = new StringBuilder();
		while (true) {
			final char ch = it.peek(0);
			if (isLetterOrDigit(ch) == false)
				return sb.toString();
			sb.append(ch);
			it.jump();
		}
	}

	private String readComment(CharInspector it) {
		final StringBuilder sb = new StringBuilder();
		it.jump();
		it.jump();
		while (true) {
			final char ch = it.peek(0);
			if (ch == '\0')
				return sb.toString();
			if (ch == '*' && it.peek(1) == ')') {
				it.jump();
				it.jump();
				return sb.toString();
			}
			sb.append(ch);
			it.jump();
		}
	}

	private boolean isLetterOrDigit(char ch) {
		return ch == '-' || ch == '_' || Character.isLetterOrDigit(ch);
	}

	public boolean isEmpty() {
		return tokens.size() == 0;
	}

}
