// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
/* +=======================================================================
 * |
 * |      PlantUML : a free UML diagram generator
 * |
 * +=======================================================================
 *
 * (C) Copyright 2009-2024, Arnaud Roques
 *
 * Project Info:  https://plantuml.com
 *
 * If you like this project or if you find it useful, you can support us at:
 *
 * https://plantuml.com/patreon (only 1$ per month!)
 * https://plantuml.com/liberapay (only 1€ per month!)
 * https://plantuml.com/paypal
 *
 *
 * PlantUML is free software; you can redistribute it and/or modify it
 * under the terms of the MIT License.
 *
 * See http://opensource.org/licenses/MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR
 * IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * PlantUML can occasionally display sponsored or advertising messages. Those
 * messages are usually generated on welcome or error images and never on
 * functional diagrams.
 * See https://plantuml.com/professional if you want to remove them
 *
 * Images (whatever their format : PNG, SVG, EPS...) generated by running PlantUML
 * are owned by the author of their corresponding sources code (that is, their
 * textual description in PlantUML language). Those images are not covered by
 * this MIT license.
 *
 * The generated images can then be used without any reference to the MIT license.
 * It is not even necessary to stipulate that they have been generated with PlantUML,
 * although this will be appreciated by the PlantUML team.
 *
 * There is an exception : if the textual description in PlantUML language is also covered
 * by any license, then the generated images are logically covered
 * by the very same license.
 *
 * This is the IGY distribution (Install GraphViz by Yourself).
 * You have to install GraphViz and to setup the GRAPHVIZ_DOT environment variable
 * (see https://plantuml.com/graphviz-dot )
 *
 * Icons provided by OpenIconic :  https://useiconic.com/open
 * Archimate sprites provided by Archi :  http://www.archimatetool.com
 * Stdlib AWS provided by https://github.com/milo-minderbinder/AWS-PlantUML
 * Stdlib Icons provided https://github.com/tupadr3/plantuml-icon-font-sprites
 * ASCIIMathML (c) Peter Jipsen http://www.chapman.edu/~jipsen
 * ASCIIMathML (c) David Lippman http://www.pierce.ctc.edu/dlippman
 * CafeUndZopfli ported by Eugene Klyuchnikov https://github.com/eustas/CafeUndZopfli
 * Brotli (c) by the Brotli Authors https://github.com/google/brotli
 * Themes (c) by Brett Schwarz https://github.com/bschwarz/puml-themes
 * Twemoji (c) by Twitter at https://twemoji.twitter.com/
 *
 */
package net.sourceforge.plantuml.mindmap;

import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;

public class StripeFrontier {

	private final SortedSet<Stripe> stripes = new TreeSet<>();

	public StripeFrontier() {
		this.stripes.add(new Stripe(-Double.MAX_VALUE, Double.MAX_VALUE, -Double.MAX_VALUE));
	}

	public boolean isEmpty() {
		return stripes.size() == 1;
	}

	@Override
	public String toString() {
		return stripes.toString();
	}

	public boolean contains(double x, double y) {
		for (Stripe stripe : stripes)
			if (stripe.contains(x))
				return y <= stripe.getValue();

		throw new UnsupportedOperationException();
	}

	public double getContact(double x1, double x2) {
		final SortedSet<Stripe> collisions = collisionning(x1, x2);
		double result = -Double.MAX_VALUE;
		for (Stripe strip : collisions)
			result = Math.max(result, strip.getValue());

		return result;

	}

	public void addSegment(double x1, double x2, double value) {
		if (x2 <= x1) {
			System.err.println("x1=" + x1);
			System.err.println("x2=" + x2);
			throw new IllegalArgumentException();
		}
		final SortedSet<Stripe> collisions = collisionning(x1, x2);
		if (collisions.size() > 1) {
			final Iterator<Stripe> it = collisions.iterator();
			it.next();
			double x = x1;
			while (it.hasNext()) {
				final Stripe tmp = it.next();
				addSegment(x, tmp.getStart(), value);
				x = tmp.getStart();
			}
			addSegment(x, x2, value);
			// System.err.println("x1=" + x1);
			// System.err.println("x2=" + x2);
			// System.err.println("All=" + stripes);
			// System.err.println("collisions" + collisions);
			// throw new UnsupportedOperationException();
		} else {
			final Stripe touch = collisions.iterator().next();
			addSingleInternal(x1, x2, value, touch);
		}
	}

	private void addSingleInternal(double x1, double x2, double value, final Stripe touch) {
		if (value <= touch.getValue())
			return;

		final boolean ok = this.stripes.remove(touch);
		assert ok;
		if (touch.getStart() != x1)
			this.stripes.add(new Stripe(touch.getStart(), x1, touch.getValue()));

		this.stripes.add(new Stripe(x1, x2, value));
		if (x2 != touch.getEnd())
			this.stripes.add(new Stripe(x2, touch.getEnd(), touch.getValue()));

		assert checkConsistent();
	}

	private boolean checkConsistent() {
		Stripe last = null;
		for (Stripe stripe : stripes) {
			if (last == null && stripe.getStart() != -Double.MAX_VALUE)
				return false;

			if (last != null && last.getEnd() != stripe.getStart())
				return false;

			last = stripe;
		}
		if (last.getEnd() != Double.MAX_VALUE)
			return false;

		return true;
	}

	private SortedSet<Stripe> collisionning(double x1, double x2) {
		final SortedSet<Stripe> result = new TreeSet<>();
		for (Iterator<Stripe> it = stripes.iterator(); it.hasNext();) {
			Stripe stripe = it.next();
			if (x1 >= stripe.getEnd())
				continue;

			result.add(stripe);
			if (x2 <= stripe.getEnd())
				return result;

		}
		throw new UnsupportedOperationException();
	}
}
