// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
/* +=======================================================================
 * |
 * |      PlantUML : a free UML diagram generator
 * |
 * +=======================================================================
 *
 * (C) Copyright 2009-2024, Arnaud Roques
 *
 * Project Info:  https://plantuml.com
 *
 * If you like this project or if you find it useful, you can support us at:
 *
 * https://plantuml.com/patreon (only 1$ per month!)
 * https://plantuml.com/liberapay (only 1€ per month!)
 * https://plantuml.com/paypal
 *
 *
 * PlantUML is free software; you can redistribute it and/or modify it
 * under the terms of the MIT License.
 *
 * See http://opensource.org/licenses/MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR
 * IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * PlantUML can occasionally display sponsored or advertising messages. Those
 * messages are usually generated on welcome or error images and never on
 * functional diagrams.
 * See https://plantuml.com/professional if you want to remove them
 *
 * Images (whatever their format : PNG, SVG, EPS...) generated by running PlantUML
 * are owned by the author of their corresponding sources code (that is, their
 * textual description in PlantUML language). Those images are not covered by
 * this MIT license.
 *
 * The generated images can then be used without any reference to the MIT license.
 * It is not even necessary to stipulate that they have been generated with PlantUML,
 * although this will be appreciated by the PlantUML team.
 *
 * There is an exception : if the textual description in PlantUML language is also covered
 * by any license, then the generated images are logically covered
 * by the very same license.
 *
 * This is the IGY distribution (Install GraphViz by Yourself).
 * You have to install GraphViz and to setup the GRAPHVIZ_DOT environment variable
 * (see https://plantuml.com/graphviz-dot )
 *
 * Icons provided by OpenIconic :  https://useiconic.com/open
 * Archimate sprites provided by Archi :  http://www.archimatetool.com
 * Stdlib AWS provided by https://github.com/milo-minderbinder/AWS-PlantUML
 * Stdlib Icons provided https://github.com/tupadr3/plantuml-icon-font-sprites
 * ASCIIMathML (c) Peter Jipsen http://www.chapman.edu/~jipsen
 * ASCIIMathML (c) David Lippman http://www.pierce.ctc.edu/dlippman
 * CafeUndZopfli ported by Eugene Klyuchnikov https://github.com/eustas/CafeUndZopfli
 * Brotli (c) by the Brotli Authors https://github.com/google/brotli
 * Themes (c) by Brett Schwarz https://github.com/bschwarz/puml-themes
 * Twemoji (c) by Twitter at https://twemoji.twitter.com/
 *
 */
package net.sourceforge.plantuml.project.core;

import net.sourceforge.plantuml.project.GanttConstraintMode;
import net.sourceforge.plantuml.project.LoadPlanable;
import net.sourceforge.plantuml.project.time.Day;

public class TaskInstant {

	private final Moment task;
	private final TaskAttribute attribute;
	private final int delta;
	private final GanttConstraintMode mode;
	private final LoadPlanable calendar;

	public TaskInstant(Moment task, TaskAttribute attribute) {
		this(task, attribute, 0, GanttConstraintMode.IGNORE_CALENDAR, null);
	}

	private TaskInstant(Moment task, TaskAttribute attribute, int delta, GanttConstraintMode mode,
			LoadPlanable calendar) {
		this.task = task;
		this.attribute = attribute;
		this.delta = delta;
		this.mode = mode;
		this.calendar = calendar;
		if (attribute != TaskAttribute.START && attribute != TaskAttribute.END)
			throw new IllegalArgumentException();

	}

	public TaskInstant withDelta(int newDelta, GanttConstraintMode mode, LoadPlanable calendar) {
		return new TaskInstant(task, attribute, newDelta, mode, calendar);
	}

	private Day manageDelta(Day value) {
		if (delta > 0)
			for (int i = 0; i < delta; i++) {
				if (mode == GanttConstraintMode.DO_NOT_COUNT_CLOSE_DAY) {
					int tmp = 0;
					while (calendar.getLoadAt(value) == 0 && tmp++ < 1000)
						value = value.increment();
				}

				value = value.increment();
			}

		if (delta < 0)
			for (int i = 0; i < -delta; i++)
				value = value.decrement();

		return value;
	}

	public Day getInstantPrecise() {
		if (attribute == TaskAttribute.START)
			return manageDelta(task.getStart());

		if (attribute == TaskAttribute.END)
			return manageDelta(task.getEnd().increment());

		throw new IllegalStateException();
	}

	public Day getInstantTheorical() {
		if (attribute == TaskAttribute.START)
			return manageDelta(task.getStart());

		if (attribute == TaskAttribute.END)
			return manageDelta(task.getEnd());

		throw new IllegalStateException();
	}

	@Override
	public String toString() {
		return attribute.toString() + " of " + task;
	}

	public final Moment getMoment() {
		return task;
	}

	public final boolean isTask() {
		return task instanceof AbstractTask;
	}

	public final TaskAttribute getAttribute() {
		return attribute;
	}

	public boolean sameRowAs(TaskInstant dest) {
		if (this.isTask() && dest.isTask()) {
			final AbstractTask t1 = (AbstractTask) this.getMoment();
			final AbstractTask t2 = (AbstractTask) dest.getMoment();
			if (t1 == t2.getRow() || t2 == t1.getRow())
				return true;

		}
		return false;
	}

}
