// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
/* +=======================================================================
 * |
 * |      PlantUML : a free UML diagram generator
 * |
 * +=======================================================================
 *
 * (C) Copyright 2009-2024, Arnaud Roques
 *
 * Project Info:  https://plantuml.com
 *
 * If you like this project or if you find it useful, you can support us at:
 *
 * https://plantuml.com/patreon (only 1$ per month!)
 * https://plantuml.com/liberapay (only 1€ per month!)
 * https://plantuml.com/paypal
 *
 *
 * PlantUML is free software; you can redistribute it and/or modify it
 * under the terms of the MIT License.
 *
 * See http://opensource.org/licenses/MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR
 * IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * PlantUML can occasionally display sponsored or advertising messages. Those
 * messages are usually generated on welcome or error images and never on
 * functional diagrams.
 * See https://plantuml.com/professional if you want to remove them
 *
 * Images (whatever their format : PNG, SVG, EPS...) generated by running PlantUML
 * are owned by the author of their corresponding sources code (that is, their
 * textual description in PlantUML language). Those images are not covered by
 * this MIT license.
 *
 * The generated images can then be used without any reference to the MIT license.
 * It is not even necessary to stipulate that they have been generated with PlantUML,
 * although this will be appreciated by the PlantUML team.
 *
 * There is an exception : if the textual description in PlantUML language is also covered
 * by any license, then the generated images are logically covered
 * by the very same license.
 *
 * This is the IGY distribution (Install GraphViz by Yourself).
 * You have to install GraphViz and to setup the GRAPHVIZ_DOT environment variable
 * (see https://plantuml.com/graphviz-dot )
 *
 * Icons provided by OpenIconic :  https://useiconic.com/open
 * Archimate sprites provided by Archi :  http://www.archimatetool.com
 * Stdlib AWS provided by https://github.com/milo-minderbinder/AWS-PlantUML
 * Stdlib Icons provided https://github.com/tupadr3/plantuml-icon-font-sprites
 * ASCIIMathML (c) Peter Jipsen http://www.chapman.edu/~jipsen
 * ASCIIMathML (c) David Lippman http://www.pierce.ctc.edu/dlippman
 * CafeUndZopfli ported by Eugene Klyuchnikov https://github.com/eustas/CafeUndZopfli
 * Brotli (c) by the Brotli Authors https://github.com/google/brotli
 * Themes (c) by Brett Schwarz https://github.com/bschwarz/puml-themes
 * Twemoji (c) by Twitter at https://twemoji.twitter.com/
 *
 */

package net.sourceforge.plantuml.zopfli;

class BlockSplitter {
	// ::remove folder when __CORE__

	static int split(Cookie cookie, byte[] input, int from, int to) {
		LzStore store = cookie.store1;
		store.reset();
		Deflate.greedy(cookie, null, input, from, to, store);

		int nPoints = splitLz(cookie, store.litLens, store.dists, store.size);

		int pos = from;
		char[] dists = store.dists;
		char[] litLens = store.litLens;
		int[] points = cookie.splitPoints;

		points[0] = pos;
		for (int i = 0, j = 1; j <= nPoints; ++j) {
			for (int pj = points[j]; i < pj; ++i) {
				pos += (dists[i] == 0) ? 1 : litLens[i];
			}
			points[j] = pos;
		}
		return nPoints;
	}

	// TODO: May be use some kind of SORTED data-structure for splitPoints?
	static int splitLz(Cookie cookie, char[] litLens, char[] dists, int llSize) {
		int[] splitPoints = cookie.splitPoints;
		int[] splitSize = cookie.splitSize;
		splitPoints[0] = 0;
		splitSize[0] = Deflate.calculateBlockSize(cookie, litLens, dists, 0, llSize);
		splitPoints[1] = llSize;
		splitSize[1] = -1;
		int numBlocks = 1;
		int maxBlocks = cookie.blockSplittingMax;

		if (llSize < 10) {
			return numBlocks;
		}

		int lStart = 0;
		int lEnd = llSize;
		int blockN = 0;
		while (numBlocks < maxBlocks) {
			int llPos = findMinimum(cookie, litLens, dists, lStart, lEnd);

			int splitL = Deflate.calculateBlockSize(cookie, litLens, dists, lStart, llPos);
			int splitR = Deflate.calculateBlockSize(cookie, litLens, dists, llPos, lEnd);

			if (splitL + splitR > splitSize[blockN] || llPos == lStart + 1 || llPos == lEnd) {
				splitSize[blockN] = -1;
			} else {
				splitSize[blockN] = splitL;
				numBlocks++;
				blockN++;
				System.arraycopy(splitPoints, blockN, splitPoints, blockN + 1, numBlocks - blockN);
				System.arraycopy(splitSize, blockN, splitSize, blockN + 1, numBlocks - blockN);
				splitPoints[blockN] = llPos;
				splitSize[blockN] = splitR;
			}

			int longest = 0;
			boolean found = false;
			for (int i = 0; i < numBlocks; i++) {
				int start = splitPoints[i];
				int end = splitPoints[i + 1];
				if ((splitSize[i] != -1) && end - start > longest) {
					lStart = start;
					lEnd = end;
					found = true;
					longest = end - start;
					blockN = i;
				}
			}
			if (!found) {
				break;
			}

			if (lEnd - lStart < 10) {
				break;
			}
		}

		return numBlocks;
	}

	private static int findMinimum(Cookie cookie, char[] litLens, char[] dists, int from, int to) {
		int start = from + 1;
		int end = to;
		if (end - start < 1024) {
			int best = Integer.MAX_VALUE;
			int result = start;
			for (int i = start; i < end; i++) {
				int v = Deflate.calculateBlockSize(cookie, litLens, dists, from, i)
						+ Deflate.calculateBlockSize(cookie, litLens, dists, i, to);
				if (v < best) {
					best = v;
					result = i;
				}
			}
			return result;
		} else {
			int n = Cookie.SPLIT_PARTITIONS;
			int[] p = cookie.p;
			int[] vp = cookie.vp;
			int lastBest = Integer.MAX_VALUE;
			int pos = start;

			while (true) {
				if (end - start <= n) {
					break;
				}

				for (int i = 0; i < n; i++) {
					p[i] = start + (i + 1) * ((end - start) / (n + 1));
					vp[i] = Deflate.calculateBlockSize(cookie, litLens, dists, from, p[i])
							+ Deflate.calculateBlockSize(cookie, litLens, dists, p[i], to);
				}
				int bestI = 0;
				int best = vp[0];
				for (int i = 1; i < n; i++) {
					if (vp[i] < best) {
						best = vp[i];
						bestI = i;
					}
				}
				if (best > lastBest) {
					break;
				}

				start = bestI == 0 ? start : p[bestI - 1];
				end = bestI == n - 1 ? end : p[bestI + 1];

				pos = p[bestI];
				lastBest = best;
			}
			return pos;
		}
	}
}
