// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
/* +=======================================================================
 * |
 * |      PlantUML : a free UML diagram generator
 * |
 * +=======================================================================
 *
 * (C) Copyright 2009-2024, Arnaud Roques
 *
 * Project Info:  https://plantuml.com
 *
 * If you like this project or if you find it useful, you can support us at:
 *
 * https://plantuml.com/patreon (only 1$ per month!)
 * https://plantuml.com/liberapay (only 1€ per month!)
 * https://plantuml.com/paypal
 *
 *
 * PlantUML is free software; you can redistribute it and/or modify it
 * under the terms of the MIT License.
 *
 * See http://opensource.org/licenses/MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR
 * IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * PlantUML can occasionally display sponsored or advertising messages. Those
 * messages are usually generated on welcome or error images and never on
 * functional diagrams.
 * See https://plantuml.com/professional if you want to remove them
 *
 * Images (whatever their format : PNG, SVG, EPS...) generated by running PlantUML
 * are owned by the author of their corresponding sources code (that is, their
 * textual description in PlantUML language). Those images are not covered by
 * this MIT license.
 *
 * The generated images can then be used without any reference to the MIT license.
 * It is not even necessary to stipulate that they have been generated with PlantUML,
 * although this will be appreciated by the PlantUML team.
 *
 * There is an exception : if the textual description in PlantUML language is also covered
 * by any license, then the generated images are logically covered
 * by the very same license.
 *
 * This is the IGY distribution (Install GraphViz by Yourself).
 * You have to install GraphViz and to setup the GRAPHVIZ_DOT environment variable
 * (see https://plantuml.com/graphviz-dot )
 *
 * Icons provided by OpenIconic :  https://useiconic.com/open
 * Archimate sprites provided by Archi :  http://www.archimatetool.com
 * Stdlib AWS provided by https://github.com/milo-minderbinder/AWS-PlantUML
 * Stdlib Icons provided https://github.com/tupadr3/plantuml-icon-font-sprites
 * ASCIIMathML (c) Peter Jipsen http://www.chapman.edu/~jipsen
 * ASCIIMathML (c) David Lippman http://www.pierce.ctc.edu/dlippman
 * CafeUndZopfli ported by Eugene Klyuchnikov https://github.com/eustas/CafeUndZopfli
 * Brotli (c) by the Brotli Authors https://github.com/google/brotli
 * Themes (c) by Brett Schwarz https://github.com/bschwarz/puml-themes
 * Twemoji (c) by Twitter at https://twemoji.twitter.com/
 *
 */

package net.sourceforge.plantuml.zopfli;

class Cookie {

	static class Node {
		int weight;
		Node tail;
		int count;
	}

	static final int SPLIT_PARTITIONS = 9;
	private static final int POOL_MAX = 10240;

	final static int[] intZeroes = new int[65536];
	final static char[] charZeroes = new char[65536];
	final static byte[] byteZeroes = new byte[65536];
	final static int[] intMOnes = new int[65536];
	final static char[] charOnes = new char[65536];
	final static long[] costMax = new long[65536];

	static {
		for (int i = 0; i < 64; ++i) {
			intMOnes[i] = -1;
			charOnes[i] = 1;
			costMax[i] = Long.MAX_VALUE;
		}
		expand(intMOnes);
		expand(charOnes);
		expand(costMax);
	}

	static void expand(Object array) {
		for (int i = 64; i < 65536; i = i + i) {
			System.arraycopy(array, 0, array, i, i);
		}
	}

	final Node[] list0 = new Node[15];
	final Node[] list1 = new Node[15];
	final Node[] leaves1 = new Node[288];
	final Node[] leaves2 = new Node[288];
	private final Node[] nodes = new Node[POOL_MAX];
	private int nextNode;

	// final Node[] leaves2 = new Node[288];

	/*
	 * private final static Comparator<Node> wc = new Comparator<>() {
	 * 
	 * @Override public int compare(Node node, Node node2) { int r = node.weight -
	 * node2.weight; return r == 0 ? node.count - node2.count : r; } };
	 */

	final int[] i320a = new int[320];
	final int[] i320b = new int[320];
	final int[] i320c = new int[320];
	final int[] i288a = new int[288];
	final int[] i288b = new int[288];
	final int[] i288c = new int[288];
	final int[] i289a = new int[289];
	final char[] c259a = new char[259];
	final int[] i32a = new int[32];
	final int[] i32b = new int[32];
	final int[] i32c = new int[32];
	final int[] i19a = new int[19];
	final int[] i19b = new int[19];
	final int[] i19c = new int[19];
	final int[] i16a = new int[16];
	final int[] i16b = new int[16];

	final int[] p = new int[SPLIT_PARTITIONS];
	final int[] vp = new int[SPLIT_PARTITIONS];

	final char[] lengthArray; // unsigned short, but really values are 0..258 == MAX_MATCH
	final long[] costs;
	final char[] path;
	final int[] splitPoints;
	final int[] splitSize;

	final SymbolStats stats = new SymbolStats();
	final SymbolStats bestStats = new SymbolStats();
	final SymbolStats lastStats = new SymbolStats();
	final Hash h = new Hash();

	int lenVal;
	int distVal;
	int rnd = 42;

	final LzStore store1;
	final LzStore store2;
	final LongestMatchCache lmc;

	final int masterBlockSize;

	final Node node(int weight, int count, Node tail) {
		Node result = nodes[nextNode++];
		result.weight = weight;
		result.count = count;
		result.tail = tail;
		return result;
	}

	final void resetPool() {
		nextNode = 0;
	}

	static void fill0(int[] array, int length) {
		int i = 0;
		while (i < length) {
			int j = i + 65536;
			if (j > length) {
				j = length;
			}
			System.arraycopy(intZeroes, 0, array, i, j - i);
			i = j;
		}
	}

	static void fill0(char[] array, int length) {
		int i = 0;
		while (i < length) {
			int j = i + 65536;
			if (j > length) {
				j = length;
			}
			System.arraycopy(charZeroes, 0, array, i, j - i);
			i = j;
		}
	}

	static void fillCostMax(long[] array, int length) {
		int i = 0;
		while (i < length) {
			int j = i + 65536;
			if (j > length) {
				j = length;
			}
			System.arraycopy(costMax, 0, array, i, j - i);
			i = j;
		}
	}

	/**
	 * Maximum amount of blocks to split into.
	 * <p>
	 * {@code 0} for unlimited.
	 */
	final int blockSplittingMax = 15;

	Cookie(int masterBlockSize) { // TODO: + maxBlockSize?
		this.masterBlockSize = masterBlockSize;

		for (int i = 0; i < POOL_MAX; i++) {
			nodes[i] = new Node();
		}
		splitPoints = new int[blockSplittingMax + 1];
		splitSize = new int[blockSplittingMax + 1];

		lengthArray = new char[masterBlockSize + 1]; // 2
		costs = new long[masterBlockSize + 1]; // 8
		path = new char[masterBlockSize + 1]; // 2
		lmc = new LongestMatchCache(masterBlockSize); // 28
		store1 = new LzStore(masterBlockSize); // 4
		store2 = new LzStore(masterBlockSize); // 4
		// 2 + 8 + 2 + 28 + 4 + 4 = 48
	}
}
