// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
/* +=======================================================================
 * |
 * |      PlantUML : a free UML diagram generator
 * |
 * +=======================================================================
 *
 * (C) Copyright 2009-2024, Arnaud Roques
 *
 * Project Info:  https://plantuml.com
 *
 * If you like this project or if you find it useful, you can support us at:
 *
 * https://plantuml.com/patreon (only 1$ per month!)
 * https://plantuml.com/liberapay (only 1€ per month!)
 * https://plantuml.com/paypal
 *
 *
 * PlantUML is free software; you can redistribute it and/or modify it
 * under the terms of the MIT License.
 *
 * See http://opensource.org/licenses/MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR
 * IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * PlantUML can occasionally display sponsored or advertising messages. Those
 * messages are usually generated on welcome or error images and never on
 * functional diagrams.
 * See https://plantuml.com/professional if you want to remove them
 *
 * Images (whatever their format : PNG, SVG, EPS...) generated by running PlantUML
 * are owned by the author of their corresponding sources code (that is, their
 * textual description in PlantUML language). Those images are not covered by
 * this MIT license.
 *
 * The generated images can then be used without any reference to the MIT license.
 * It is not even necessary to stipulate that they have been generated with PlantUML,
 * although this will be appreciated by the PlantUML team.
 *
 * There is an exception : if the textual description in PlantUML language is also covered
 * by any license, then the generated images are logically covered
 * by the very same license.
 *
 * This is the IGY distribution (Install GraphViz by Yourself).
 * You have to install GraphViz and to setup the GRAPHVIZ_DOT environment variable
 * (see https://plantuml.com/graphviz-dot )
 *
 * Icons provided by OpenIconic :  https://useiconic.com/open
 * Archimate sprites provided by Archi :  http://www.archimatetool.com
 * Stdlib AWS provided by https://github.com/milo-minderbinder/AWS-PlantUML
 * Stdlib Icons provided https://github.com/tupadr3/plantuml-icon-font-sprites
 * ASCIIMathML (c) Peter Jipsen http://www.chapman.edu/~jipsen
 * ASCIIMathML (c) David Lippman http://www.pierce.ctc.edu/dlippman
 * CafeUndZopfli ported by Eugene Klyuchnikov https://github.com/eustas/CafeUndZopfli
 * Brotli (c) by the Brotli Authors https://github.com/google/brotli
 * Themes (c) by Brett Schwarz https://github.com/bschwarz/puml-themes
 * Twemoji (c) by Twitter at https://twemoji.twitter.com/
 *
 */

package net.sourceforge.plantuml.zopfli;

public class Zopfli {

	private static class Crc {

		private final static int[] table = makeTable();

		private static int[] makeTable() {
			int[] result = new int[256];

			for (int n = 0; n < 256; ++n) {
				int c = n;
				for (int k = 0; k < 8; ++k) {
					if ((c & 1) == 1) {
						c = 0xEDB88320 ^ (c >>> 1);
					} else {
						c = c >>> 1;
					}
				}
				result[n] = c;
			}

			return result;
		}

		public static int calculate(byte[] input) {
			int c = ~0;
			for (int i = 0, n = input.length; i < n; ++i) {
				c = table[(c ^ input[i]) & 0xFF] ^ (c >>> 8);
			}
			return ~c;
		}
	}

	private final Cookie cookie;

	public synchronized Buffer compress(Options options, byte[] input) {
		Buffer output = new Buffer();
		switch (options.outputType) {
		case GZIP:
			compressGzip(options, input, output);
			break;

		case ZLIB:
			compressZlib(options, input, output);
			break;
		case DEFLATE:
			Deflate.compress(cookie, options, input, output);
			break;
		default:
			throw new IllegalArgumentException("Unexpected output format: " + options.outputType);
		}
		return output;
	}

	/**
	 * Calculates the adler32 checksum of the data
	 */
	private static int adler32(byte[] data) {
		int s1 = 1;
		int s2 = 1 >> 16;
		int i = 0;
		while (i < data.length) {
			int tick = Math.min(data.length, i + 1024);
			while (i < tick) {
				s1 += data[i++];
				s2 += s1;
			}
			s1 %= 65521;
			s2 %= 65521;
		}

		return (s2 << 16) | s1;
	}

	private void compressZlib(Options options, byte[] input, Buffer output) {
		output.append((byte) 0x78);
		output.append((byte) 0x1E);

		Deflate.compress(cookie, options, input, output);

		int checksum = adler32(input);
		output.append((byte) ((checksum >> 24) & 0xFF));
		output.append((byte) ((checksum >> 16) & 0xFF));
		output.append((byte) ((checksum >> 8) & 0xFF));
		output.append((byte) (checksum & 0xFF));
	}

	private void compressGzip(Options options, byte[] input, Buffer output) {
		output.append((byte) 31);
		output.append((byte) 139);
		output.append((byte) 8);
		output.append((byte) 0);

		output.append((byte) 0);
		output.append((byte) 0);
		output.append((byte) 0);
		output.append((byte) 0);

		output.append((byte) 2);
		output.append((byte) 3);

		Deflate.compress(cookie, options, input, output);

		int crc = Crc.calculate(input);
		output.append((byte) (crc & 0xFF));
		output.append((byte) ((crc >> 8) & 0xFF));
		output.append((byte) ((crc >> 16) & 0xFF));
		output.append((byte) ((crc >> 24) & 0xFF));

		int size = input.length;
		output.append((byte) (size & 0xFF));
		output.append((byte) ((size >> 8) & 0xFF));
		output.append((byte) ((size >> 16) & 0xFF));
		output.append((byte) ((size >> 24) & 0xFF));
	}

	public Zopfli(int masterBlockSize) {
		cookie = new Cookie(masterBlockSize);
	}
}
