// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
/* +=======================================================================
 * |
 * |      PlantUML : a free UML diagram generator
 * |
 * +=======================================================================
 *
 * (C) Copyright 2009-2024, Arnaud Roques
 *
 * Project Info:  https://plantuml.com
 *
 * If you like this project or if you find it useful, you can support us at:
 *
 * https://plantuml.com/patreon (only 1$ per month!)
 * https://plantuml.com/liberapay (only 1€ per month!)
 * https://plantuml.com/paypal
 *
 *
 * PlantUML is free software; you can redistribute it and/or modify it
 * under the terms of the MIT License.
 *
 * See http://opensource.org/licenses/MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR
 * IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * PlantUML can occasionally display sponsored or advertising messages. Those
 * messages are usually generated on welcome or error images and never on
 * functional diagrams.
 * See https://plantuml.com/professional if you want to remove them
 *
 * Images (whatever their format : PNG, SVG, EPS...) generated by running PlantUML
 * are owned by the author of their corresponding sources code (that is, their
 * textual description in PlantUML language). Those images are not covered by
 * this MIT license.
 *
 * The generated images can then be used without any reference to the MIT license.
 * It is not even necessary to stipulate that they have been generated with PlantUML,
 * although this will be appreciated by the PlantUML team.
 *
 * There is an exception : if the textual description in PlantUML language is also covered
 * by any license, then the generated images are logically covered
 * by the very same license.
 *
 * This is the IGY distribution (Install GraphViz by Yourself).
 * You have to install GraphViz and to setup the GRAPHVIZ_DOT environment variable
 * (see https://plantuml.com/graphviz-dot )
 *
 * Icons provided by OpenIconic :  https://useiconic.com/open
 * Archimate sprites provided by Archi :  http://www.archimatetool.com
 * Stdlib AWS provided by https://github.com/milo-minderbinder/AWS-PlantUML
 * Stdlib Icons provided https://github.com/tupadr3/plantuml-icon-font-sprites
 * ASCIIMathML (c) Peter Jipsen http://www.chapman.edu/~jipsen
 * ASCIIMathML (c) David Lippman http://www.pierce.ctc.edu/dlippman
 * CafeUndZopfli ported by Eugene Klyuchnikov https://github.com/eustas/CafeUndZopfli
 * Brotli (c) by the Brotli Authors https://github.com/google/brotli
 * Themes (c) by Brett Schwarz https://github.com/bschwarz/puml-themes
 * Twemoji (c) by Twitter at https://twemoji.twitter.com/
 *
 */
package org.stathissideris.ascii2image.graphics;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

/**
 * 
 * @author Efstathios Sideris
 */
public class FontMeasurer {

	private final Font baseFont;
	private boolean forceFontSize;
	private FontRenderContext fakeRenderContext;
	private Graphics2D fakeGraphics;

	public FontMeasurer(Font font, boolean forceFontSize){
		this.baseFont = font;
		this.forceFontSize = forceFontSize;

		BufferedImage image = new BufferedImage(1,1, BufferedImage.TYPE_INT_RGB);
		fakeGraphics = image.createGraphics();
		
		fakeRenderContext = fakeGraphics.getFontRenderContext();
	}

	public int getWidthFor(String str, int pixelHeight){
		Font font = getFontFor(pixelHeight);
		Rectangle2D rectangle = font.getStringBounds(str, fakeRenderContext);
		return (int) rectangle.getWidth();
	}

	public int getHeightFor(String str, int pixelHeight){
		Font font = getFontFor(pixelHeight);
		Rectangle2D rectangle = font.getStringBounds(str, fakeRenderContext);
		return (int) rectangle.getHeight();
	}

	public int getWidthFor(String str, Font font){
		Rectangle2D rectangle = font.getStringBounds(str, fakeRenderContext);
		return (int) rectangle.getWidth();
	}

	public int getHeightFor(String str, Font font){
		Rectangle2D rectangle = font.getStringBounds(str, fakeRenderContext);
		return (int) rectangle.getHeight();
	}

	public Rectangle2D getBoundsFor(String str, Font font){
		return font.getStringBounds(str, fakeRenderContext);
	}

	public int getAscent(Font font){
		fakeGraphics.setFont(font);
		FontMetrics metrics = fakeGraphics.getFontMetrics();
		return metrics.getAscent();
	}

	public int getZHeight(Font font){
		return (int) font.createGlyphVector(fakeRenderContext, "Z").getOutline().getBounds().getHeight();
	}

	public Font getFontFor(final int maxWidth, final String string){
		if (forceFontSize)
		{
			return baseFont;
		}
		else
		{
			FontPredicate predicate = new FontPredicate() {
				@Override
				public boolean test(Font font)
				{
					int width = getWidthFor(string, font);
					return width > maxWidth;
				}
			};
			return deriveFont(predicate, 1.0f);
		}
	}

	public Font getFontFor(final int pixelHeight){
		if (forceFontSize)
		{
			return baseFont;
		}
		else
		{
			FontPredicate predicate = new FontPredicate() {
				@Override
				public boolean test(Font font)
				{
					//ascent is the distance between the baseline and the tallest character
					int ascent = getAscent(font);
					return ascent > pixelHeight;
				}
			};
			return deriveFont(predicate, 0.5f);
		}
	}

	private Font deriveFont(FontPredicate predicate, float sizeDelta)
	{
		Font currentFont = baseFont;
		float size = baseFont.getSize2D();

		int direction; //direction of size change (towards smaller or bigger)
		if(predicate.test(currentFont)){
			currentFont = currentFont.deriveFont(size - 1f);
			size--;
			direction = -1;
		} else {
			currentFont = currentFont.deriveFont(size + 1f);
			size++;
			direction = 1;
		}

		while(size > 0){
			currentFont = currentFont.deriveFont(size);
			//rectangle = currentFont.getStringBounds(testString, frc);
			if (direction == 1) {
				if (predicate.test(currentFont)) {
					size = size - sizeDelta;
					return currentFont.deriveFont(size);
				} else {
					size = size + sizeDelta;
				}
			} else {
				if (!predicate.test(currentFont)) {
					return currentFont;
				} else {
					size = size - sizeDelta;
				}
			}
		}
		return null;
	}

	private interface FontPredicate {
		boolean test(Font font);
	}
}
