/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.descdiagram;

import net.sourceforge.plantuml.abel.Entity;
import net.sourceforge.plantuml.cucadiagram.BodyFactory;
import net.sourceforge.plantuml.klimt.UStroke;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.ColorType;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.creole.Stencil;
import net.sourceforge.plantuml.klimt.drawing.AbstractUGraphicHorizontalLine;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.font.FontParam;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.TextBlockInEllipse;
import net.sourceforge.plantuml.klimt.shape.TextBlockUtils;
import net.sourceforge.plantuml.klimt.shape.UEllipse;
import net.sourceforge.plantuml.klimt.shape.UHorizontalLine;
import net.sourceforge.plantuml.skin.ColorParam;
import net.sourceforge.plantuml.skin.LineParam;
import net.sourceforge.plantuml.skin.SkinParamUtils;
import net.sourceforge.plantuml.stereo.Stereotype;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.svek.AbstractEntityImage;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.text.Guillemet;
import net.sourceforge.plantuml.url.Url;

public class EntityImageRequirement
extends AbstractEntityImage {
    private final TextBlock desc;
    private final Url url;

    public EntityImageRequirement(Entity entity) {
        super(entity);
        Stereotype stereotype = entity.getStereotype();
        TextBlock tmp = BodyFactory.create2(this.getSkinParam().getDefaultTextAlignment(HorizontalAlignment.CENTER), entity.getDisplay(), this.getSkinParam(), stereotype, entity, this.getStyle());
        if (stereotype == null || stereotype.getLabel(Guillemet.DOUBLE_COMPARATOR) == null) {
            this.desc = tmp;
        } else {
            TextBlock stereo = Display.getWithNewlines(stereotype.getLabel(this.getSkinParam().guillemet())).create(FontConfiguration.create(this.getSkinParam(), FontParam.REQUIREMENT_STEREOTYPE, stereotype), HorizontalAlignment.CENTER, this.getSkinParam());
            this.desc = TextBlockUtils.mergeTB(stereo, tmp, HorizontalAlignment.CENTER);
        }
        this.url = entity.getUrl99();
    }

    private Style getStyle() {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.componentDiagram, SName.requirement).withTOBECHANGED(this.getEntity().getStereotype()).getMergedStyle(this.getSkinParam().getCurrentStyleBuilder());
    }

    private UStroke getStroke() {
        UStroke stroke = this.getSkinParam().getThickness(LineParam.requirementBorder, this.getStereo());
        if (stroke == null) {
            stroke = new UStroke(7.0, 7.0, 1.5);
        }
        return stroke;
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        return new TextBlockInEllipse(this.desc, stringBounder).calculateDimension(stringBounder);
    }

    @Override
    public final void drawU(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        TextBlockInEllipse ellipse = new TextBlockInEllipse(this.desc, stringBounder);
        if (this.url != null) {
            ug.startUrl(this.url);
        }
        ug = ug.apply(this.getStroke());
        HColor linecolor = this.getEntity().getColors().getColor(ColorType.LINE);
        if (linecolor == null) {
            linecolor = SkinParamUtils.getColor(this.getSkinParam(), this.getStereo(), ColorParam.requirementBorder);
        }
        ug = ug.apply(linecolor);
        HColor backcolor = this.getEntity().getColors().getColor(ColorType.BACK);
        if (backcolor == null) {
            backcolor = SkinParamUtils.getColor(this.getSkinParam(), this.getStereo(), ColorParam.requirementBackground);
        }
        ug = ug.apply(backcolor.bg());
        MyUGraphicEllipse ug2 = new MyUGraphicEllipse(ug, 0.0, 0.0, ellipse.getUEllipse());
        ellipse.drawU(ug2);
        if (this.url != null) {
            ug.closeUrl();
        }
    }

    @Override
    public ShapeType getShapeType() {
        return ShapeType.OVAL;
    }

    static class MyUGraphicEllipse
    extends AbstractUGraphicHorizontalLine {
        private final double startingX;
        private final double yTheoricalPosition;
        private final UEllipse ellipse;

        @Override
        protected AbstractUGraphicHorizontalLine copy(UGraphic ug) {
            return new MyUGraphicEllipse(ug, this.startingX, this.yTheoricalPosition, this.ellipse);
        }

        MyUGraphicEllipse(UGraphic ug, double startingX, double yTheoricalPosition, UEllipse ellipse) {
            super(ug);
            this.startingX = startingX;
            this.ellipse = ellipse;
            this.yTheoricalPosition = yTheoricalPosition;
        }

        private double getNormalized(double y) {
            if (y < this.yTheoricalPosition) {
                throw new IllegalArgumentException();
            }
            if ((y -= this.yTheoricalPosition) > this.ellipse.getHeight()) {
                throw new IllegalArgumentException();
            }
            return y;
        }

        private double getStartingXInternal(double y) {
            return this.startingX + this.ellipse.getStartingX(this.getNormalized(y));
        }

        private double getEndingXInternal(double y) {
            return this.startingX + this.ellipse.getEndingX(this.getNormalized(y));
        }

        private Stencil getStencil2(UTranslate translate) {
            final double dy = translate.getDy();
            return new Stencil(){

                @Override
                public double getStartingX(StringBounder stringBounder, double y) {
                    return this.getStartingXInternal(y + dy);
                }

                @Override
                public double getEndingX(StringBounder stringBounder, double y) {
                    return this.getEndingXInternal(y + dy);
                }
            };
        }

        @Override
        protected void drawHline(UGraphic ug, UHorizontalLine line, UTranslate translate) {
            UStroke stroke = UStroke.withThickness(1.5);
            line.drawLineInternal(ug.apply(translate), this.getStencil2(translate), 0.0, stroke);
        }
    }
}

