/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import net.sourceforge.plantuml.code.AsciiEncoder;

public class SignatureUtils {
    public static String getSignature(String string) {
        try {
            AsciiEncoder asciiEncoder = new AsciiEncoder();
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.update(string.getBytes("UTF-8"));
            byte[] byArray = messageDigest.digest();
            return asciiEncoder.encode(byArray);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
            throw new IllegalStateException();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            throw new IllegalStateException();
        }
    }

    public static String getSignatureWithoutImgSrc(String string) {
        string = SignatureUtils.getSignature(SignatureUtils.purge(string));
        return string;
    }

    public static String purge(String string) {
        string = string.replaceAll("(?i)\\<img\\s+src=\"(?:[^\"]+[/\\\\])?([^/\\\\\\d.]+)\\d*(\\.\\w+)\"/\\>", "<img src=\"$1$2\"/>");
        string = string.replaceAll("(?i)image=\"(?:[^\"]+[/\\\\])?([^/\\\\\\d.]+)\\d*(\\.\\w+)\"", "image=\"$1$2\"");
        return string;
    }

    public static String getSignature(File file) throws IOException {
        try {
            AsciiEncoder asciiEncoder = new AsciiEncoder();
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            FileInputStream fileInputStream = new FileInputStream(file);
            int n = -1;
            while ((n = fileInputStream.read()) != -1) {
                messageDigest.update((byte)n);
            }
            fileInputStream.close();
            byte[] byArray = messageDigest.digest();
            return asciiEncoder.encode(byArray);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
            throw new IllegalStateException();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            throw new IllegalStateException();
        }
    }
}

