/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ant;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.GeneratedImage;
import net.sourceforge.plantuml.Option;
import net.sourceforge.plantuml.OptionFlags;
import net.sourceforge.plantuml.SourceFileReader;
import net.sourceforge.plantuml.preproc.Defines;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileList;
import org.apache.tools.ant.types.FileSet;

public class PlantUmlTask
extends Task {
    private String dir = null;
    private final Option option = new Option();
    private List<FileSet> filesets = new ArrayList<FileSet>();
    private List<FileList> filelists = new ArrayList<FileList>();
    private AtomicInteger nbFiles = new AtomicInteger(0);
    private ExecutorService executorService;

    public void addFileset(FileSet fileSet) {
        this.filesets.add(fileSet);
    }

    public void addFilelist(FileList fileList) {
        this.filelists.add(fileList);
    }

    public void execute() throws BuildException {
        this.log("Starting PlantUML");
        try {
            File file;
            if (this.dir != null) {
                Iterator<FileList> iterator = this.processingSingleDirectory(new File(this.dir));
                this.checkError((File)((Object)iterator));
            }
            for (FileSet fileSet : this.filesets) {
                file = this.manageFileSet(fileSet);
                this.checkError(file);
            }
            for (FileList fileList : this.filelists) {
                file = this.manageFileList(fileList);
                this.checkError(file);
            }
            if (this.executorService != null) {
                this.executorService.shutdown();
                this.executorService.awaitTermination(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
            }
            this.log("Nb images generated: " + this.nbFiles.get());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new BuildException(iOException.toString());
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
            throw new BuildException(interruptedException.toString());
        }
    }

    private void checkError(File file) throws IOException {
        if (file != null && OptionFlags.getInstance().isFailOnError()) {
            this.log("Error in file " + file.getCanonicalPath());
            throw new BuildException("Error in file " + file.getCanonicalPath());
        }
    }

    private File manageFileList(FileList fileList) throws IOException, InterruptedException {
        String[] stringArray;
        File file = fileList.getDir(this.getProject());
        for (String string : stringArray = fileList.getFiles(this.getProject())) {
            File file2 = new File(file, string);
            boolean bl = this.processingSingleFile(file2);
            if (!bl) continue;
            return file2;
        }
        return null;
    }

    private File manageFileSet(FileSet fileSet) throws IOException, InterruptedException {
        File file;
        DirectoryScanner directoryScanner = fileSet.getDirectoryScanner(this.getProject());
        File file2 = fileSet.getDir(this.getProject());
        String[] stringArray = directoryScanner.getIncludedFiles();
        String[] stringArray2 = directoryScanner.getIncludedDirectories();
        for (String string : stringArray) {
            file = new File(file2, string);
            boolean bl = this.processingSingleFile(file);
            if (!bl) continue;
            return file;
        }
        for (String string : stringArray2) {
            file = new File(file2, string);
            File file3 = this.processingSingleDirectory(file);
            if (file3 == null) continue;
            return file3;
        }
        return null;
    }

    private boolean processingSingleFile(final File file) throws IOException, InterruptedException {
        if (OptionFlags.getInstance().isVerbose()) {
            this.log("Processing " + file.getAbsolutePath());
        }
        final SourceFileReader sourceFileReader = new SourceFileReader(new Defines(), file, this.option.getOutputDir(), this.option.getConfig(), this.option.getCharset(), this.option.getFileFormatOption());
        if (this.option.isCheckOnly()) {
            return sourceFileReader.hasError();
        }
        if (this.executorService == null) {
            return this.doFile(file, sourceFileReader);
        }
        this.executorService.submit(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return PlantUmlTask.this.doFile(file, sourceFileReader);
            }
        });
        return false;
    }

    private boolean doFile(File file, SourceFileReader sourceFileReader) throws IOException, InterruptedException {
        List<GeneratedImage> list = sourceFileReader.getGeneratedImages();
        boolean bl = false;
        for (GeneratedImage generatedImage : list) {
            if (OptionFlags.getInstance().isVerbose()) {
                this.myLog(generatedImage + " " + generatedImage.getDescription());
            }
            this.nbFiles.addAndGet(1);
            if (!generatedImage.isError()) continue;
            bl = true;
        }
        if (bl) {
            this.myLog("Error: " + file.getCanonicalPath());
        }
        return bl && OptionFlags.getInstance().isFailOnError();
    }

    private synchronized void myLog(String string) {
        this.log(string);
    }

    private File processingSingleDirectory(File file) throws IOException, InterruptedException {
        if (!file.exists()) {
            String string = "The file " + file.getAbsolutePath() + " does not exists.";
            this.log(string);
            throw new BuildException(string);
        }
        for (File file2 : file.listFiles()) {
            boolean bl;
            if (!file2.isFile() || !this.fileToProcess(file2.getName()) || !(bl = this.processingSingleFile(file2))) continue;
            return file2;
        }
        return null;
    }

    private boolean fileToProcess(String string) {
        return string.matches(Option.getPattern());
    }

    public void setDir(String string) {
        this.dir = string;
    }

    public void setOutput(String string) {
        this.option.setOutputDir(new File(string));
    }

    public void setCharset(String string) {
        this.option.setCharset(string);
    }

    public void setConfig(String string) {
        try {
            this.option.initConfig(string);
        }
        catch (IOException iOException) {
            this.log("Error reading " + string);
        }
    }

    public void setKeepTmpFiles(String string) {
        if ("true".equalsIgnoreCase(string)) {
            OptionFlags.getInstance().setKeepTmpFiles(true);
        }
    }

    public void setVerbose(String string) {
        if ("true".equalsIgnoreCase(string)) {
            OptionFlags.getInstance().setVerbose(true);
        }
    }

    public void setFormat(String string) {
        if ("xmi".equalsIgnoreCase(string)) {
            this.option.setFileFormat(FileFormat.XMI_STANDARD);
        }
        if ("xmi:argo".equalsIgnoreCase(string)) {
            this.option.setFileFormat(FileFormat.XMI_ARGO);
        }
        if ("xmi:start".equalsIgnoreCase(string)) {
            this.option.setFileFormat(FileFormat.XMI_STAR);
        }
        if ("eps".equalsIgnoreCase(string)) {
            this.option.setFileFormat(FileFormat.EPS);
        }
        if ("pdf".equalsIgnoreCase(string)) {
            this.option.setFileFormat(FileFormat.PDF);
        }
        if ("eps:text".equalsIgnoreCase(string)) {
            this.option.setFileFormat(FileFormat.EPS_TEXT);
        }
        if ("svg".equalsIgnoreCase(string)) {
            this.option.setFileFormat(FileFormat.SVG);
        }
        if ("txt".equalsIgnoreCase(string)) {
            this.option.setFileFormat(FileFormat.ATXT);
        }
        if ("utxt".equalsIgnoreCase(string)) {
            this.option.setFileFormat(FileFormat.UTXT);
        }
    }

    public void setGraphvizDot(String string) {
        OptionFlags.getInstance().setDotExecutable(string);
    }

    public void setNbThread(String string) {
        int n;
        if (string != null && string.matches("\\d+")) {
            this.option.setNbThreads(Integer.parseInt(string));
            n = this.option.getNbThreads();
            this.executorService = Executors.newFixedThreadPool(n);
        }
        if ("auto".equalsIgnoreCase(string)) {
            this.option.setNbThreads(Option.defaultNbThreads());
            n = this.option.getNbThreads();
            this.executorService = Executors.newFixedThreadPool(n);
        }
    }

    public void setNbThreads(String string) {
        this.setNbThread(string);
    }

    public void setSuggestEngine(String string) {
        OptionFlags.getInstance().setUseSuggestEngine("true".equalsIgnoreCase(string) || "yes".equalsIgnoreCase(string) || "on".equalsIgnoreCase(string));
    }

    public void setFailOnError(String string) {
        OptionFlags.getInstance().setFailOnError("true".equalsIgnoreCase(string) || "yes".equalsIgnoreCase(string) || "on".equalsIgnoreCase(string));
    }

    public void setCheckOnly(String string) {
        boolean bl = "true".equalsIgnoreCase(string) || "yes".equalsIgnoreCase(string) || "on".equalsIgnoreCase(string);
        this.option.setCheckOnly(true);
        OptionFlags.getInstance().setFailOnError(bl);
    }
}

