/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.classdiagram.command;

import java.util.Map;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.classdiagram.ClassDiagram;
import net.sourceforge.plantuml.classdiagram.command.GenericRegexProducer;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexOr;
import net.sourceforge.plantuml.command.regex.RegexPartialMatch;
import net.sourceforge.plantuml.cucadiagram.EntityType;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.LinkDecor;
import net.sourceforge.plantuml.cucadiagram.LinkType;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandCreateEntityClass3
extends SingleLineCommand2<ClassDiagram> {
    public CommandCreateEntityClass3(ClassDiagram classDiagram) {
        super(classDiagram, CommandCreateEntityClass3.getRegexConcat());
    }

    private static RegexConcat getRegexConcat() {
        return new RegexConcat(new RegexLeaf("^"), new RegexLeaf("TYPE", "(interface|enum|abstract\\s+class|abstract|class)\\s+"), new RegexOr(new RegexLeaf("NAME1", "(?:\"([^\"]+)\"\\s+as\\s+)?(\\.?[\\p{L}0-9_]+(?:\\.[\\p{L}0-9_]+)*)"), new RegexLeaf("NAME2", "(\\.?[\\p{L}0-9_]+(?:\\.[\\p{L}0-9_]+)*)\\s+as\\s+\"([^\"]+)\""), new RegexLeaf("NAME3", "\"([^\"]+)\"")), new RegexLeaf("GENERIC", "(?:\\s*\\<(" + GenericRegexProducer.PATTERN + ")\\>)?"), new RegexLeaf("STEREO", "(?:\\s*(\\<{2}.*\\>{2}))?"), new RegexLeaf("COLOR", "\\s*(#\\w+[-\\\\|/]?\\w+)?"), new RegexLeaf("EXTENDS", "(\\s+(extends|implements)\\s+(\\.?[\\p{L}0-9_]+(?:\\.[\\p{L}0-9_]+)*))?"), new RegexLeaf("$"));
    }

    @Override
    protected CommandExecutionResult executeArg(Map<String, RegexPartialMatch> map) {
        IEntity iEntity;
        String string;
        String string2;
        EntityType entityType = EntityType.getEntityType(map.get("TYPE").get(0).toUpperCase());
        if (map.get("NAME1").get(1) != null) {
            string2 = map.get("NAME1").get(1);
            string = map.get("NAME1").get(0);
        } else if (map.get("NAME3").get(0) != null) {
            string2 = map.get("NAME3").get(0);
            string = map.get("NAME3").get(0);
        } else {
            string2 = map.get("NAME2").get(0);
            string = map.get("NAME2").get(1);
        }
        String string3 = map.get("STEREO").get(0);
        String string4 = map.get("GENERIC").get(0);
        if (((ClassDiagram)this.getSystem()).entityExist(string2)) {
            iEntity = ((ClassDiagram)this.getSystem()).getOrCreateEntity(string2, entityType);
            iEntity.muteToType(entityType);
        } else {
            iEntity = ((ClassDiagram)this.getSystem()).createEntity(string2, string, entityType);
        }
        if (string3 != null) {
            iEntity.setStereotype(new Stereotype(string3, ((ClassDiagram)this.getSystem()).getSkinParam().getCircledCharacterRadius(), ((ClassDiagram)this.getSystem()).getSkinParam().getFont(FontParam.CIRCLED_CHARACTER, null)));
        }
        if (string4 != null) {
            iEntity.setGeneric(string4);
        }
        iEntity.setSpecificBackcolor(HtmlColorUtils.getColorIfValid(map.get("COLOR").get(0)));
        CommandCreateEntityClass3.manageExtends((ClassDiagram)this.getSystem(), map, iEntity);
        return CommandExecutionResult.ok();
    }

    public static void manageExtends(ClassDiagram classDiagram, Map<String, RegexPartialMatch> map, IEntity iEntity) {
        if (map.get("EXTENDS").get(1) != null) {
            Mode mode = map.get("EXTENDS").get(1).equalsIgnoreCase("extends") ? Mode.EXTENDS : Mode.IMPLEMENTS;
            String string = map.get("EXTENDS").get(2);
            EntityType entityType = EntityType.CLASS;
            if (mode == Mode.IMPLEMENTS) {
                entityType = EntityType.INTERFACE;
            }
            if (mode == Mode.EXTENDS && iEntity.getEntityType() == EntityType.INTERFACE) {
                entityType = EntityType.INTERFACE;
            }
            IEntity iEntity2 = classDiagram.getOrCreateClass(string, entityType);
            LinkType linkType = new LinkType(LinkDecor.NONE, LinkDecor.EXTENDS);
            if (entityType == EntityType.INTERFACE && iEntity.getEntityType() != EntityType.INTERFACE) {
                linkType = linkType.getDashed();
            }
            Link link = new Link(iEntity2, iEntity, linkType, null, 2, null, null, classDiagram.getLabeldistance(), classDiagram.getLabelangle());
            classDiagram.addLink(link);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Mode {
        EXTENDS,
        IMPLEMENTS;

    }
}

