/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.classdiagram.command;

import java.util.List;
import java.util.Map;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.classdiagram.ClassDiagram;
import net.sourceforge.plantuml.classdiagram.command.GenericRegexProducer;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.CommandMultilines2;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexOr;
import net.sourceforge.plantuml.command.regex.RegexPartialMatch;
import net.sourceforge.plantuml.cucadiagram.EntityType;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.LinkDecor;
import net.sourceforge.plantuml.cucadiagram.LinkType;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.skin.VisibilityModifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandCreateEntityClassMultilines2
extends CommandMultilines2<ClassDiagram> {
    public CommandCreateEntityClassMultilines2(ClassDiagram classDiagram) {
        super(classDiagram, CommandCreateEntityClassMultilines2.getRegexConcat());
    }

    @Override
    public String getPatternEnd() {
        return "(?i)^\\s*\\}\\s*$";
    }

    private static RegexConcat getRegexConcat() {
        return new RegexConcat(new RegexLeaf("^"), new RegexLeaf("TYPE", "(interface|enum|abstract\\s+class|abstract|class)\\s+"), new RegexOr(new RegexLeaf("NAME1", "(?:\"([^\"]+)\"\\s+as\\s+)?(\\.?[\\p{L}0-9_]+(?:\\.[\\p{L}0-9_]+)*)"), new RegexLeaf("NAME2", "(\\.?[\\p{L}0-9_]+(?:\\.[\\p{L}0-9_]+)*)\\s+as\\s+\"([^\"]+)\""), new RegexLeaf("NAME3", "\"([^\"]+)\"")), new RegexLeaf("GENERIC", "(?:\\s*\\<(" + GenericRegexProducer.PATTERN + ")\\>)?"), new RegexLeaf("STEREO", "(?:\\s*([\\<\\[]{2}.*[\\>\\]]{2}))?"), new RegexLeaf("COLOR", "\\s*(#\\w+)?"), new RegexLeaf("EXTENDS", "(\\s+(extends|implements)\\s+(\\.?[\\p{L}0-9_]+(?:\\.[\\p{L}0-9_]+)*))?"), new RegexLeaf("\\s*\\{\\s*$"));
    }

    @Override
    public CommandExecutionResult execute(List<String> list) {
        StringUtils.trim(list, false);
        Map<String, RegexPartialMatch> map = this.getStartingPattern().matcher(list.get(0).trim());
        IEntity iEntity = this.executeArg0(map);
        if (iEntity == null) {
            return CommandExecutionResult.error("No such entity");
        }
        Url url = (list = list.subList(1, list.size() - 1)).size() > 0 ? StringUtils.extractUrl(list.get(0).toString()) : null;
        if (url != null) {
            list = list.subList(1, list.size());
        }
        for (String string : list) {
            if (string.length() > 0 && VisibilityModifier.isVisibilityCharacter(string.charAt(0))) {
                ((ClassDiagram)this.getSystem()).setVisibilityModifierPresent(true);
            }
            iEntity.addFieldOrMethod(string);
        }
        if (url != null) {
            iEntity.addUrl(url);
        }
        CommandCreateEntityClassMultilines2.manageExtends((ClassDiagram)this.getSystem(), map, iEntity);
        return CommandExecutionResult.ok();
    }

    private static void manageExtends(ClassDiagram classDiagram, Map<String, RegexPartialMatch> map, IEntity iEntity) {
        if (map.get("EXTENDS").get(1) != null) {
            Mode mode = map.get("EXTENDS").get(1).equalsIgnoreCase("extends") ? Mode.EXTENDS : Mode.IMPLEMENTS;
            String string = map.get("EXTENDS").get(2);
            EntityType entityType = EntityType.CLASS;
            if (mode == Mode.IMPLEMENTS) {
                entityType = EntityType.INTERFACE;
            }
            if (mode == Mode.EXTENDS && iEntity.getEntityType() == EntityType.INTERFACE) {
                entityType = EntityType.INTERFACE;
            }
            IEntity iEntity2 = classDiagram.getOrCreateClass(string, entityType);
            LinkType linkType = new LinkType(LinkDecor.NONE, LinkDecor.EXTENDS);
            if (entityType == EntityType.INTERFACE && iEntity.getEntityType() != EntityType.INTERFACE) {
                linkType = linkType.getDashed();
            }
            Link link = new Link(iEntity2, iEntity, linkType, null, 2, null, null, classDiagram.getLabeldistance(), classDiagram.getLabelangle());
            classDiagram.addLink(link);
        }
    }

    private IEntity executeArg0(Map<String, RegexPartialMatch> map) {
        String string;
        String string2;
        EntityType entityType = EntityType.getEntityType(map.get("TYPE").get(0).toUpperCase());
        if (map.get("NAME1").get(1) != null) {
            string2 = map.get("NAME1").get(1);
            string = map.get("NAME1").get(0);
        } else if (map.get("NAME3").get(0) != null) {
            string2 = map.get("NAME3").get(0);
            string = map.get("NAME3").get(0);
        } else {
            string2 = map.get("NAME2").get(0);
            string = map.get("NAME2").get(1);
        }
        String string3 = map.get("STEREO").get(0);
        String string4 = map.get("GENERIC").get(0);
        if (((ClassDiagram)this.getSystem()).entityExist(string2)) {
            IEntity iEntity = ((ClassDiagram)this.getSystem()).getOrCreateClass(string2);
            iEntity.muteToType(entityType);
            return iEntity;
        }
        IEntity iEntity = ((ClassDiagram)this.getSystem()).createEntity(string2, string, entityType);
        if (string3 != null) {
            iEntity.setStereotype(new Stereotype(string3, ((ClassDiagram)this.getSystem()).getSkinParam().getCircledCharacterRadius(), ((ClassDiagram)this.getSystem()).getSkinParam().getFont(FontParam.CIRCLED_CHARACTER, null)));
        }
        iEntity.setSpecificBackcolor(HtmlColorUtils.getColorIfValid(map.get("COLOR").get(0)));
        if (string4 != null) {
            iEntity.setGeneric(string4);
        }
        return iEntity;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Mode {
        EXTENDS,
        IMPLEMENTS;

    }
}

