/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.DiagramType;
import net.sourceforge.plantuml.UmlDiagram;
import net.sourceforge.plantuml.command.Command;
import net.sourceforge.plantuml.command.CommandComment;
import net.sourceforge.plantuml.command.CommandControl;
import net.sourceforge.plantuml.command.CommandFooter;
import net.sourceforge.plantuml.command.CommandHeader;
import net.sourceforge.plantuml.command.CommandHideUnlinked;
import net.sourceforge.plantuml.command.CommandMinwidth;
import net.sourceforge.plantuml.command.CommandMultilinesComment;
import net.sourceforge.plantuml.command.CommandMultilinesFooter;
import net.sourceforge.plantuml.command.CommandMultilinesHeader;
import net.sourceforge.plantuml.command.CommandMultilinesTitle;
import net.sourceforge.plantuml.command.CommandNope;
import net.sourceforge.plantuml.command.CommandPragma;
import net.sourceforge.plantuml.command.CommandRotate;
import net.sourceforge.plantuml.command.CommandScale;
import net.sourceforge.plantuml.command.CommandScaleWidthAndHeight;
import net.sourceforge.plantuml.command.CommandScaleWidthOrHeight;
import net.sourceforge.plantuml.command.CommandSkinParam;
import net.sourceforge.plantuml.command.CommandSkinParamMultilines;
import net.sourceforge.plantuml.command.CommandSpriteFile;
import net.sourceforge.plantuml.command.CommandTitle;
import net.sourceforge.plantuml.command.FactorySpriteCommand;
import net.sourceforge.plantuml.command.PSystemCommandFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractUmlSystemCommandFactory
implements PSystemCommandFactory {
    private final DiagramType type;
    private List<Command> cmds;

    protected AbstractUmlSystemCommandFactory() {
        this(DiagramType.UML);
    }

    protected AbstractUmlSystemCommandFactory(DiagramType diagramType) {
        this.type = diagramType;
    }

    public String checkFinalError() {
        return null;
    }

    @Override
    public final CommandControl isValid(List<String> list) {
        for (Command command : this.cmds) {
            CommandControl commandControl = command.isValid(list);
            if (commandControl != CommandControl.OK && commandControl != CommandControl.OK_PARTIAL) continue;
            return commandControl;
        }
        return CommandControl.NOT_OK;
    }

    @Override
    public final Command createCommand(List<String> list) {
        for (Command command : this.cmds) {
            CommandControl commandControl = command.isValid(list);
            if (commandControl == CommandControl.OK) {
                return command;
            }
            if (commandControl != CommandControl.OK_PARTIAL) continue;
            throw new IllegalArgumentException();
        }
        throw new IllegalArgumentException();
    }

    @Override
    public final void init(String string) {
        this.cmds = new ArrayList<Command>();
        this.initCommands();
    }

    protected abstract void initCommands();

    protected final void addCommonCommands(UmlDiagram umlDiagram) {
        this.addCommand(new CommandNope(umlDiagram));
        this.addCommand(new CommandComment(umlDiagram));
        this.addCommand(new CommandMultilinesComment(umlDiagram));
        this.addCommand(new CommandPragma(umlDiagram));
        this.addCommand(new CommandTitle(umlDiagram));
        this.addCommand(new CommandMultilinesTitle(umlDiagram));
        this.addCommand(new CommandFooter(umlDiagram));
        this.addCommand(new CommandMultilinesFooter(umlDiagram));
        this.addCommand(new CommandHeader(umlDiagram));
        this.addCommand(new CommandMultilinesHeader(umlDiagram));
        this.addCommand(new CommandSkinParam(umlDiagram));
        this.addCommand(new CommandSkinParamMultilines(umlDiagram));
        this.addCommand(new CommandMinwidth(umlDiagram));
        this.addCommand(new CommandRotate(umlDiagram));
        this.addCommand(new CommandScale(umlDiagram));
        this.addCommand(new CommandScaleWidthAndHeight(umlDiagram));
        this.addCommand(new CommandScaleWidthOrHeight(umlDiagram));
        this.addCommand(new CommandHideUnlinked(umlDiagram));
        FactorySpriteCommand factorySpriteCommand = new FactorySpriteCommand();
        this.addCommand(factorySpriteCommand.createMultiLine(umlDiagram));
        this.addCommand(factorySpriteCommand.createSingleLine(umlDiagram));
        this.addCommand(new CommandSpriteFile(umlDiagram));
    }

    protected final void addCommand(Command command) {
        this.cmds.add(command);
    }

    public final List<String> getDescription() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Command command : this.cmds) {
            arrayList.addAll(Arrays.asList(command.getDescription()));
        }
        return Collections.unmodifiableList(arrayList);
    }

    @Override
    public final DiagramType getDiagramType() {
        return this.type;
    }
}

