/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command.note;

import java.util.List;
import java.util.Map;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.UniqueSequence;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.activitydiagram.ActivityDiagram;
import net.sourceforge.plantuml.command.Command;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.CommandMultilines2;
import net.sourceforge.plantuml.command.Position;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.note.SingleMultiFactoryCommand;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexPartialMatch;
import net.sourceforge.plantuml.cucadiagram.EntityType;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.LinkDecor;
import net.sourceforge.plantuml.cucadiagram.LinkType;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FactoryNoteActivityCommand
implements SingleMultiFactoryCommand<ActivityDiagram> {
    private RegexConcat getRegexConcatMultiLine() {
        return new RegexConcat(new RegexLeaf("^note\\s+"), new RegexLeaf("POSITION", "(right|left|top|bottom)\\s*"), new RegexLeaf("COLOR", "(#\\w+)?\\s*"), new RegexLeaf("$"));
    }

    private RegexConcat getRegexConcatSingleLine() {
        return new RegexConcat(new RegexLeaf("^note\\s+"), new RegexLeaf("POSITION", "(right|left|top|bottom)\\s*"), new RegexLeaf("COLOR", "(#\\w+)?\\s*:\\s*"), new RegexLeaf("NOTE", "(.*)"), new RegexLeaf("$"));
    }

    @Override
    public Command createMultiLine(ActivityDiagram activityDiagram) {
        return new CommandMultilines2<ActivityDiagram>(activityDiagram, this.getRegexConcatMultiLine()){

            @Override
            public String getPatternEnd() {
                return "(?i)^end ?note$";
            }

            @Override
            public final CommandExecutionResult execute(List<String> list) {
                Map<String, RegexPartialMatch> map = this.getStartingPattern().matcher(list.get(0).trim());
                List<String> list2 = StringUtils.removeEmptyColumns(list.subList(1, list.size() - 1));
                Url url = null;
                if (list2.size() > 0) {
                    url = StringUtils.extractUrl(list2.get(0));
                }
                if (url != null) {
                    list2 = list2.subList(1, list2.size());
                }
                String string = StringUtils.getMergedLines(list2);
                IEntity iEntity = ((ActivityDiagram)this.getSystem()).createEntity("GMN" + UniqueSequence.getValue(), string, EntityType.NOTE);
                if (url != null) {
                    iEntity.addUrl(url);
                }
                return FactoryNoteActivityCommand.this.executeInternal((ActivityDiagram)this.getSystem(), map, iEntity);
            }
        };
    }

    @Override
    public Command createSingleLine(ActivityDiagram activityDiagram) {
        return new SingleLineCommand2<ActivityDiagram>(activityDiagram, this.getRegexConcatSingleLine()){

            @Override
            protected CommandExecutionResult executeArg(Map<String, RegexPartialMatch> map) {
                IEntity iEntity = ((ActivityDiagram)this.getSystem()).createNote("GN" + UniqueSequence.getValue(), map.get("NOTE").get(0));
                return FactoryNoteActivityCommand.this.executeInternal((ActivityDiagram)this.getSystem(), map, iEntity);
            }
        };
    }

    private CommandExecutionResult executeInternal(ActivityDiagram activityDiagram, Map<String, RegexPartialMatch> map, IEntity iEntity) {
        Link link;
        iEntity.setSpecificBackcolor(HtmlColorUtils.getColorIfValid(map.get("COLOR").get(0)));
        IEntity iEntity2 = activityDiagram.getLastEntityConsulted();
        if (iEntity2 == null) {
            iEntity2 = activityDiagram.getStart();
        }
        Position position = Position.valueOf(map.get("POSITION").get(0).toUpperCase()).withRankdir(activityDiagram.getRankdir());
        LinkType linkType = new LinkType(LinkDecor.NONE, LinkDecor.NONE).getDashed();
        if (position == Position.RIGHT) {
            link = new Link(iEntity2, iEntity, linkType, null, 1);
        } else if (position == Position.LEFT) {
            link = new Link(iEntity, iEntity2, linkType, null, 1);
        } else if (position == Position.BOTTOM) {
            link = new Link(iEntity2, iEntity, linkType, null, 2);
        } else if (position == Position.TOP) {
            link = new Link(iEntity, iEntity2, linkType, null, 2);
        } else {
            throw new IllegalArgumentException();
        }
        activityDiagram.addLink(link);
        return CommandExecutionResult.ok();
    }
}

