/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command.note;

import java.util.List;
import java.util.Map;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.classdiagram.AbstractEntityDiagram;
import net.sourceforge.plantuml.command.Command;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.CommandMultilines2;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.note.SingleMultiFactoryCommand;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexPartialMatch;
import net.sourceforge.plantuml.cucadiagram.EntityType;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FactoryNoteCommand
implements SingleMultiFactoryCommand<AbstractEntityDiagram> {
    private RegexConcat getRegexConcatMultiLine() {
        return new RegexConcat(new RegexLeaf("^(note)\\s+"), new RegexLeaf("CODE", "as\\s+([\\p{L}0-9_.]+)"), new RegexLeaf("COLOR", "\\s*(#\\w+)?"), new RegexLeaf("$"));
    }

    private RegexConcat getRegexConcatSingleLine() {
        return new RegexConcat(new RegexLeaf("^note\\s+"), new RegexLeaf("DISPLAY", "\"([^\"]+)\"\\s+as\\s+"), new RegexLeaf("CODE", "([\\p{L}0-9_.]+)\\s*"), new RegexLeaf("COLOR", "(#\\w+)?"), new RegexLeaf("$"));
    }

    @Override
    public Command createSingleLine(AbstractEntityDiagram abstractEntityDiagram) {
        return new SingleLineCommand2<AbstractEntityDiagram>(abstractEntityDiagram, this.getRegexConcatSingleLine()){

            @Override
            protected CommandExecutionResult executeArg(Map<String, RegexPartialMatch> map) {
                String string = map.get("DISPLAY").get(0);
                return FactoryNoteCommand.this.executeInternal((AbstractEntityDiagram)this.getSystem(), map, string);
            }
        };
    }

    @Override
    public Command createMultiLine(AbstractEntityDiagram abstractEntityDiagram) {
        return new CommandMultilines2<AbstractEntityDiagram>(abstractEntityDiagram, this.getRegexConcatMultiLine()){

            @Override
            public String getPatternEnd() {
                return "(?i)^end ?note$";
            }

            @Override
            public CommandExecutionResult execute(List<String> list) {
                StringUtils.trim(list, false);
                Map<String, RegexPartialMatch> map = this.getStartingPattern().matcher(list.get(0).trim());
                List<String> list2 = StringUtils.removeEmptyColumns(list.subList(1, list.size() - 1));
                String string = StringUtils.getMergedLines(list2);
                return FactoryNoteCommand.this.executeInternal((AbstractEntityDiagram)this.getSystem(), map, string);
            }
        };
    }

    private CommandExecutionResult executeInternal(AbstractEntityDiagram abstractEntityDiagram, Map<String, RegexPartialMatch> map, String string) {
        String string2 = map.get("CODE").get(0);
        IEntity iEntity = abstractEntityDiagram.createEntity(string2, string, EntityType.NOTE);
        assert (iEntity != null);
        iEntity.setSpecificBackcolor(HtmlColorUtils.getColorIfValid(map.get("COLOR").get(0)));
        return CommandExecutionResult.ok();
    }
}

