/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command.note;

import java.util.List;
import java.util.Map;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.UniqueSequence;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.classdiagram.AbstractEntityDiagram;
import net.sourceforge.plantuml.command.Command;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.CommandMultilines2;
import net.sourceforge.plantuml.command.Position;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.note.SingleMultiFactoryCommand;
import net.sourceforge.plantuml.command.regex.IRegex;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexOr;
import net.sourceforge.plantuml.command.regex.RegexPartialMatch;
import net.sourceforge.plantuml.cucadiagram.EntityType;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.LinkDecor;
import net.sourceforge.plantuml.cucadiagram.LinkType;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FactoryNoteOnEntityCommand
implements SingleMultiFactoryCommand<AbstractEntityDiagram> {
    private final IRegex partialPattern;

    public FactoryNoteOnEntityCommand(IRegex iRegex) {
        this.partialPattern = iRegex;
    }

    private RegexConcat getRegexConcatSingleLine(IRegex iRegex) {
        return new RegexConcat(new RegexLeaf("^note\\s+"), new RegexLeaf("POSITION", "(right|left|top|bottom)"), new RegexOr(new RegexConcat(new RegexLeaf("\\s+of\\s+"), iRegex), new RegexLeaf("")), new RegexLeaf("COLOR", "\\s*(#\\w+)?\\s*:\\s*"), new RegexLeaf("NOTE", "(.*)"), new RegexLeaf("$"));
    }

    private RegexConcat getRegexConcatMultiLine(IRegex iRegex) {
        return new RegexConcat(new RegexLeaf("^note\\s+"), new RegexLeaf("POSITION", "(right|left|top|bottom)"), new RegexOr(new RegexConcat(new RegexLeaf("\\s+of\\s+"), iRegex), new RegexLeaf("")), new RegexLeaf("COLOR", "\\s*(#\\w+)?"), new RegexLeaf("\\s*\\{?"), new RegexLeaf("$"));
    }

    @Override
    public Command createSingleLine(final AbstractEntityDiagram abstractEntityDiagram) {
        return new SingleLineCommand2<AbstractEntityDiagram>(abstractEntityDiagram, this.getRegexConcatSingleLine(this.partialPattern)){

            @Override
            protected CommandExecutionResult executeArg(Map<String, RegexPartialMatch> map) {
                String string = map.get("NOTE").get(0);
                return FactoryNoteOnEntityCommand.this.executeInternal(map, abstractEntityDiagram, null, string);
            }
        };
    }

    @Override
    public Command createMultiLine(final AbstractEntityDiagram abstractEntityDiagram) {
        return new CommandMultilines2<AbstractEntityDiagram>(abstractEntityDiagram, this.getRegexConcatMultiLine(this.partialPattern)){

            @Override
            public String getPatternEnd() {
                return "(?i)^(end ?note|\\})$";
            }

            @Override
            public CommandExecutionResult execute(List<String> list) {
                StringUtils.trim(list, false);
                Map<String, RegexPartialMatch> map = this.getStartingPattern().matcher(list.get(0).trim());
                List<String> list2 = StringUtils.removeEmptyColumns(list.subList(1, list.size() - 1));
                Url url = null;
                if (list2.size() > 0) {
                    url = StringUtils.extractUrl(list2.get(0));
                }
                if (url != null) {
                    list2 = list2.subList(1, list2.size());
                }
                String string = StringUtils.getMergedLines(list2);
                return FactoryNoteOnEntityCommand.this.executeInternal(map, abstractEntityDiagram, url, string);
            }
        };
    }

    private CommandExecutionResult executeInternal(Map<String, RegexPartialMatch> map, AbstractEntityDiagram abstractEntityDiagram, Url url, String string) {
        Link link;
        IEntity iEntity;
        String string2 = map.get("POSITION").get(0);
        String string3 = map.get("ENTITY").get(0);
        if (string3 == null) {
            iEntity = abstractEntityDiagram.getLastEntity();
            if (iEntity == null) {
                return CommandExecutionResult.error("Nothing to note to");
            }
        } else {
            iEntity = abstractEntityDiagram.getOrCreateClass(string3);
        }
        IEntity iEntity2 = abstractEntityDiagram.createEntity("GMN" + UniqueSequence.getValue(), string, EntityType.NOTE);
        iEntity2.setSpecificBackcolor(HtmlColorUtils.getColorIfValid(map.get("COLOR").get(0)));
        if (url != null) {
            iEntity2.addUrl(url);
        }
        Position position = Position.valueOf(string2.toUpperCase()).withRankdir(abstractEntityDiagram.getRankdir());
        LinkType linkType = new LinkType(LinkDecor.NONE, LinkDecor.NONE).getDashed();
        if (position == Position.RIGHT) {
            link = new Link(iEntity, iEntity2, linkType, null, 1);
            link.setHorizontalSolitary(true);
        } else if (position == Position.LEFT) {
            link = new Link(iEntity2, iEntity, linkType, null, 1);
            link.setHorizontalSolitary(true);
        } else if (position == Position.BOTTOM) {
            link = new Link(iEntity, iEntity2, linkType, null, 2);
        } else if (position == Position.TOP) {
            link = new Link(iEntity2, iEntity, linkType, null, 2);
        } else {
            throw new IllegalArgumentException();
        }
        abstractEntityDiagram.addLink(link);
        return CommandExecutionResult.ok();
    }
}

