/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command.note.sequence;

import java.util.List;
import java.util.Map;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.command.Command;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.CommandMultilines2;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.note.SingleMultiFactoryCommand;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexPartialMatch;
import net.sourceforge.plantuml.sequencediagram.AbstractMessage;
import net.sourceforge.plantuml.sequencediagram.NotePosition;
import net.sourceforge.plantuml.sequencediagram.SequenceDiagram;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FactorySequenceNoteOnArrowCommand
implements SingleMultiFactoryCommand<SequenceDiagram> {
    private RegexConcat getRegexConcatMultiLine() {
        return new RegexConcat(new RegexLeaf("^note\\s+"), new RegexLeaf("POSITION", "(right|left)\\s*"), new RegexLeaf("COLOR", "(#\\w+)?"), new RegexLeaf("$"));
    }

    private RegexConcat getRegexConcatSingleLine() {
        return new RegexConcat(new RegexLeaf("^note\\s+"), new RegexLeaf("POSITION", "(right|left)\\s*"), new RegexLeaf("COLOR", "(#\\w+)?\\s*:\\s*"), new RegexLeaf("NOTE", "(.*)"), new RegexLeaf("$"));
    }

    @Override
    public Command createSingleLine(SequenceDiagram sequenceDiagram) {
        return new SingleLineCommand2<SequenceDiagram>(sequenceDiagram, this.getRegexConcatSingleLine()){

            @Override
            protected CommandExecutionResult executeArg(Map<String, RegexPartialMatch> map) {
                List<String> list = StringUtils.getWithNewlines(map.get("NOTE").get(0));
                return FactorySequenceNoteOnArrowCommand.this.executeInternal((SequenceDiagram)this.getSystem(), map, list);
            }
        };
    }

    @Override
    public Command createMultiLine(SequenceDiagram sequenceDiagram) {
        return new CommandMultilines2<SequenceDiagram>(sequenceDiagram, this.getRegexConcatMultiLine()){

            @Override
            public String getPatternEnd() {
                return "(?i)^end ?note$";
            }

            @Override
            public CommandExecutionResult execute(List<String> list) {
                Map<String, RegexPartialMatch> map = this.getStartingPattern().matcher(list.get(0).trim());
                List<String> list2 = StringUtils.removeEmptyColumns(list.subList(1, list.size() - 1));
                return FactorySequenceNoteOnArrowCommand.this.executeInternal((SequenceDiagram)this.getSystem(), map, list2);
            }
        };
    }

    private CommandExecutionResult executeInternal(SequenceDiagram sequenceDiagram, Map<String, RegexPartialMatch> map, List<String> list) {
        AbstractMessage abstractMessage = sequenceDiagram.getLastMessage();
        if (abstractMessage != null) {
            NotePosition notePosition = NotePosition.valueOf(map.get("POSITION").get(0).toUpperCase());
            List<CharSequence> list2 = StringUtils.manageEmbededDiagrams(list);
            Url url = list2.size() > 0 ? StringUtils.extractUrl(((Object)list2.get(0)).toString()) : null;
            if (url != null) {
                list2 = list2.subList(1, list2.size());
            }
            abstractMessage.setNote(list2, notePosition, map.get("COLOR").get(0), url);
        }
        return CommandExecutionResult.ok();
    }
}

