/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command.note.sequence;

import java.util.List;
import java.util.Map;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.command.Command;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.CommandMultilines2;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.note.SingleMultiFactoryCommand;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexPartialMatch;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.sequencediagram.Note;
import net.sourceforge.plantuml.sequencediagram.NoteStyle;
import net.sourceforge.plantuml.sequencediagram.Participant;
import net.sourceforge.plantuml.sequencediagram.SequenceDiagram;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FactorySequenceNoteOverSeveralCommand
implements SingleMultiFactoryCommand<SequenceDiagram> {
    private RegexConcat getRegexConcatMultiLine() {
        return new RegexConcat(new RegexLeaf("STYLE", "^(note|hnote|rnote)\\s+over\\s+"), new RegexLeaf("P1", "([\\p{L}0-9_.@]+|\"[^\"]+\")\\s*\\,\\s*"), new RegexLeaf("P2", "([\\p{L}0-9_.@]+|\"[^\"]+\")\\s*"), new RegexLeaf("COLOR", "(#\\w+)?"), new RegexLeaf("$"));
    }

    private RegexConcat getRegexConcatSingleLine() {
        return new RegexConcat(new RegexLeaf("STYLE", "^(note|hnote|rnote)\\s+over\\s+"), new RegexLeaf("P1", "([\\p{L}0-9_.@]+|\"[^\"]+\")\\s*\\,\\s*"), new RegexLeaf("P2", "([\\p{L}0-9_.@]+|\"[^\"]+\")\\s*"), new RegexLeaf("COLOR", "(#\\w+)?\\s*:\\s*"), new RegexLeaf("NOTE", "(.*)"), new RegexLeaf("$"));
    }

    @Override
    public Command createSingleLine(SequenceDiagram sequenceDiagram) {
        return new SingleLineCommand2<SequenceDiagram>(sequenceDiagram, this.getRegexConcatSingleLine()){

            @Override
            protected CommandExecutionResult executeArg(Map<String, RegexPartialMatch> map) {
                List<String> list = StringUtils.getWithNewlines(map.get("NOTE").get(0));
                return FactorySequenceNoteOverSeveralCommand.this.executeInternal((SequenceDiagram)this.getSystem(), map, list);
            }
        };
    }

    @Override
    public Command createMultiLine(SequenceDiagram sequenceDiagram) {
        return new CommandMultilines2<SequenceDiagram>(sequenceDiagram, this.getRegexConcatMultiLine()){

            @Override
            public String getPatternEnd() {
                return "(?i)^end ?(note|hnote|rnote)$";
            }

            @Override
            public CommandExecutionResult execute(List<String> list) {
                Map<String, RegexPartialMatch> map = this.getStartingPattern().matcher(list.get(0).trim());
                List<String> list2 = StringUtils.removeEmptyColumns(list.subList(1, list.size() - 1));
                return FactorySequenceNoteOverSeveralCommand.this.executeInternal((SequenceDiagram)this.getSystem(), map, list2);
            }
        };
    }

    private CommandExecutionResult executeInternal(SequenceDiagram sequenceDiagram, Map<String, RegexPartialMatch> map, List<String> list) {
        Participant participant = sequenceDiagram.getOrCreateParticipant(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(map.get("P1").get(0)));
        Participant participant2 = sequenceDiagram.getOrCreateParticipant(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(map.get("P2").get(0)));
        if (list.size() > 0) {
            Note note = new Note(participant, participant2, list);
            note.setSpecificBackcolor(HtmlColorUtils.getColorIfValid(map.get("COLOR").get(0)));
            note.setStyle(NoteStyle.getNoteStyle(map.get("STYLE").get(0)));
            sequenceDiagram.addNote(note);
        }
        return CommandExecutionResult.ok();
    }
}

