/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command.regex;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.command.regex.IRegex;
import net.sourceforge.plantuml.command.regex.MatcherIterator;
import net.sourceforge.plantuml.command.regex.RegexPartialMatch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RegexComposed
implements IRegex {
    private final List<IRegex> partials;

    protected abstract Pattern getFull();

    public RegexComposed(IRegex ... iRegexArray) {
        this.partials = Arrays.asList(iRegexArray);
        if (this.partials.size() < 2) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public Map<String, RegexPartialMatch> createPartialMatch(Iterator<String> iterator) {
        HashMap<String, RegexPartialMatch> hashMap = new HashMap<String, RegexPartialMatch>();
        for (IRegex iRegex : this.partials) {
            hashMap.putAll(iRegex.createPartialMatch(iterator));
        }
        return hashMap;
    }

    @Override
    public final int count() {
        int n = this.getStartCount();
        for (IRegex iRegex : this.partials) {
            n += iRegex.count();
        }
        return n;
    }

    protected int getStartCount() {
        return 0;
    }

    public Map<String, RegexPartialMatch> matcher(String string) {
        Matcher matcher = this.getFull().matcher(string);
        if (!matcher.find()) {
            throw new IllegalArgumentException(this.getClass() + " " + string);
        }
        MatcherIterator matcherIterator = new MatcherIterator(matcher);
        return Collections.unmodifiableMap(this.createPartialMatch(matcherIterator));
    }

    public final boolean match(String string) {
        return this.getFull().matcher(string).find();
    }

    @Override
    public final String getPattern() {
        return this.getFull().pattern();
    }

    protected final List<IRegex> getPartials() {
        return this.partials;
    }
}

