/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.componentdiagram;

import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.classdiagram.AbstractEntityDiagram;
import net.sourceforge.plantuml.cucadiagram.EntityType;
import net.sourceforge.plantuml.cucadiagram.GroupType;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.IEntityMutable;

public class ComponentDiagram
extends AbstractEntityDiagram {
    public IEntity getOrCreateClass(String string) {
        if (string.startsWith("[") && string.endsWith("]")) {
            return this.getOrCreateEntity(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(string), EntityType.COMPONENT);
        }
        if (string.startsWith(":") && string.endsWith(":")) {
            return this.getOrCreateEntity(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(string), EntityType.ACTOR);
        }
        if (string.startsWith("()")) {
            string = string.substring(2).trim();
            string = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(string);
            return this.getOrCreateEntity(string, EntityType.CIRCLE_INTERFACE);
        }
        string = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(string);
        return this.getOrCreateEntity(string, EntityType.CIRCLE_INTERFACE);
    }

    public IEntity getOrCreateEntity(String string, EntityType entityType) {
        if (super.entityExist(string = this.getFullyQualifiedCode(string))) {
            return super.getOrCreateEntity(string, entityType);
        }
        return this.createEntityWithNamespace(string, this.getShortName(string), entityType);
    }

    public IEntity createEntity(String string, String string2, EntityType entityType) {
        if (entityType != EntityType.COMPONENT) {
            return super.createEntity(string, string2, entityType);
        }
        if (super.entityExist(string = this.getFullyQualifiedCode(string))) {
            throw new IllegalArgumentException("Already known: " + string);
        }
        return this.createEntityWithNamespace(string, string2, entityType);
    }

    private IEntity createEntityWithNamespace(String string, String string2, EntityType entityType) {
        IEntityMutable iEntityMutable = this.getCurrentGroup();
        String string3 = this.getNamespace(string);
        if (!(string3 == null || iEntityMutable != null && iEntityMutable.zgetGroupCode().equals(string3))) {
            iEntityMutable = this.getOrCreateGroupInternal(string3, string3, string3, GroupType.PACKAGE, null);
        }
        return this.createEntityInternal(string, string2 == null ? this.getShortName(string) : string2, entityType, iEntityMutable);
    }

    public final boolean entityExist(String string) {
        return super.entityExist(this.getFullyQualifiedCode(string));
    }

    public UmlDiagramType getUmlDiagramType() {
        return UmlDiagramType.COMPONENT;
    }
}

