/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.componentdiagram.command;

import java.util.Map;
import net.sourceforge.plantuml.Direction;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexPartialMatch;
import net.sourceforge.plantuml.componentdiagram.ComponentDiagram;
import net.sourceforge.plantuml.cucadiagram.EntityType;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.LinkDecor;
import net.sourceforge.plantuml.cucadiagram.LinkType;
import net.sourceforge.plantuml.cucadiagram.Stereotype;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandLinkComponent2
extends SingleLineCommand2<ComponentDiagram> {
    public CommandLinkComponent2(ComponentDiagram componentDiagram) {
        super(componentDiagram, CommandLinkComponent2.getRegex());
    }

    static RegexConcat getRegex() {
        return new RegexConcat(new RegexLeaf("^"), CommandLinkComponent2.getRegexGroup("G1"), new RegexLeaf("\\s*"), new RegexLeaf("AR_TO_RIGHT", "(([-=.]+)(?:(left|right|up|down|le?|ri?|up?|do?)(?=[-=.]))?([-=.]*)\\()"), new RegexLeaf("\\s*"), CommandLinkComponent2.getRegexGroup("G2"), new RegexLeaf("\\s*"), new RegexLeaf("END", "(?::\\s*([^\"]+))?$"));
    }

    private static RegexLeaf getRegexGroup(String string) {
        return new RegexLeaf(string, "([\\p{L}0-9_.]+|:[^:]+:|\\[[^\\]*]+[^\\]]*\\])(?:\\s*(\\<\\<.*\\>\\>))?");
    }

    @Override
    protected CommandExecutionResult executeArg(Map<String, RegexPartialMatch> map) {
        String string = map.get("G1").get(0);
        String string2 = map.get("G2").get(0);
        if (((ComponentDiagram)this.getSystem()).isGroup(string) || ((ComponentDiagram)this.getSystem()).isGroup(string2)) {
            return CommandExecutionResult.error("Not implemented");
        }
        IEntity iEntity = ((ComponentDiagram)this.getSystem()).getOrCreateClass(string);
        IEntity iEntity2 = ((ComponentDiagram)this.getSystem()).getOrCreateEntity(string2, EntityType.ARC_CIRCLE);
        if (map.get("G1").get(1) != null) {
            iEntity.setStereotype(new Stereotype(map.get("G1").get(1)));
        }
        if (map.get("G2").get(1) != null) {
            iEntity2.setStereotype(new Stereotype(map.get("G2").get(1)));
        }
        LinkType linkType = new LinkType(LinkDecor.NONE, LinkDecor.NONE);
        String string3 = map.get("AR_TO_RIGHT").get(0) != null ? map.get("AR_TO_RIGHT").get(1) + map.get("AR_TO_RIGHT").get(3) : map.get("AR_TO_LEFT").get(2) + map.get("AR_TO_LEFT").get(4);
        Direction direction = this.getDirection(map);
        if (direction == Direction.LEFT || direction == Direction.RIGHT) {
            string3 = "-";
        }
        Link link = new Link(iEntity, iEntity2, linkType, map.get("END").get(0), string3.length());
        if (direction == Direction.LEFT || direction == Direction.UP) {
            link = link.getInv();
        }
        ((ComponentDiagram)this.getSystem()).addLink(link);
        return CommandExecutionResult.ok();
    }

    private Direction getDirection(Map<String, RegexPartialMatch> map) {
        if (map.get("AR_TO_RIGHT").get(1) != null) {
            return StringUtils.getQueueDirection(map.get("AR_TO_RIGHT").get(1));
        }
        return null;
    }
}

