/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram;

import java.awt.geom.Dimension2D;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.SpriteContainer;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.cucadiagram.Member;
import net.sourceforge.plantuml.cucadiagram.MemberImpl;
import net.sourceforge.plantuml.cucadiagram.MethodsOrFieldsArea;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignement;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockLineBefore;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.TextBlockWidth;
import net.sourceforge.plantuml.graphic.TextBlockWidthVertical;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.ugraphic.UGraphic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BodyEnhanced
implements TextBlockWidth {
    private TextBlockWidth area2;
    private final FontConfiguration titleConfig;
    private final List<String> rawBody;
    private final FontParam fontParam;
    private final ISkinParam skinParam;

    public BodyEnhanced(List<String> list, FontParam fontParam, ISkinParam iSkinParam) {
        this.rawBody = new ArrayList<String>(list);
        this.fontParam = fontParam;
        this.skinParam = iSkinParam;
        this.titleConfig = new FontConfiguration(iSkinParam.getFont(fontParam, null), new Rose().getFontColor(iSkinParam, fontParam));
    }

    private TextBlockWidth decorate(StringBounder stringBounder, TextBlockWidth textBlockWidth, char c, TextBlock textBlock) {
        if (textBlock == null) {
            return new TextBlockLineBefore(TextBlockUtils.withMargin(textBlockWidth, 6.0, 4.0), c);
        }
        Dimension2D dimension2D = textBlock.calculateDimension(stringBounder);
        TextBlockLineBefore textBlockLineBefore = new TextBlockLineBefore(TextBlockUtils.withMargin(textBlockWidth, 6.0, dimension2D.getHeight() / 2.0, 4.0), c, textBlock);
        return TextBlockUtils.withMargin(textBlockLineBefore, 0.0, dimension2D.getHeight() / 2.0, 0.0);
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        return this.getArea(stringBounder).calculateDimension(stringBounder);
    }

    private TextBlockWidth getArea(StringBounder stringBounder) {
        if (this.area2 != null) {
            return this.area2;
        }
        ArrayList<TextBlockWidth> arrayList = new ArrayList<TextBlockWidth>();
        char c = '_';
        TextBlock textBlock = null;
        ArrayList<Member> arrayList2 = new ArrayList<Member>();
        for (String string : this.rawBody) {
            if (BodyEnhanced.isBlockSeparator(string)) {
                arrayList.add(this.decorate(stringBounder, new MethodsOrFieldsArea(arrayList2, this.fontParam, this.skinParam), c, textBlock));
                c = string.charAt(0);
                textBlock = this.getTitle(string, this.skinParam);
                arrayList2 = new ArrayList();
                continue;
            }
            MemberImpl memberImpl = new MemberImpl(string, StringUtils.isMethod(string));
            arrayList2.add(memberImpl);
        }
        arrayList.add(this.decorate(stringBounder, new MethodsOrFieldsArea(arrayList2, this.fontParam, this.skinParam), c, textBlock));
        this.area2 = new TextBlockWidthVertical(arrayList);
        return this.area2;
    }

    @Override
    public void drawU(UGraphic uGraphic, double d, double d2, double d3) {
        this.getArea(uGraphic.getStringBounder()).drawU(uGraphic, d, d2, d3);
    }

    public static boolean isBlockSeparator(String string) {
        if (string.startsWith("--") && string.endsWith("--")) {
            return true;
        }
        if (string.startsWith("==") && string.endsWith("==")) {
            return true;
        }
        if (string.startsWith("..") && string.endsWith("..")) {
            return true;
        }
        return string.startsWith("__") && string.endsWith("__");
    }

    private TextBlock getTitle(String string, SpriteContainer spriteContainer) {
        if (string.length() <= 4) {
            return null;
        }
        string = string.substring(2, string.length() - 2).trim();
        return TextBlockUtils.create(StringUtils.getWithNewlines(string), this.titleConfig, HorizontalAlignement.LEFT, spriteContainer);
    }
}

