/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram;

import net.sourceforge.plantuml.cucadiagram.EntityGender;
import net.sourceforge.plantuml.cucadiagram.EntityType;
import net.sourceforge.plantuml.cucadiagram.EntityUtils;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.IEntityMutable;

public class EntityGenderUtils {
    public static EntityGender byEntityType(final EntityType entityType) {
        return new EntityGender(){

            public boolean contains(IEntity iEntity) {
                return iEntity.getEntityType() == entityType;
            }
        };
    }

    public static EntityGender byEntityAlone(final IEntity iEntity) {
        return new EntityGender(){

            public boolean contains(IEntity iEntity2) {
                return iEntity2.getUid().equals(iEntity.getUid());
            }
        };
    }

    public static EntityGender byStereotype(final String string) {
        return new EntityGender(){

            public boolean contains(IEntity iEntity) {
                if (iEntity.getStereotype() == null) {
                    return false;
                }
                return string.equals(iEntity.getStereotype().getLabel());
            }
        };
    }

    public static EntityGender byPackage(final IEntityMutable iEntityMutable) {
        if (iEntityMutable == null) {
            throw new IllegalArgumentException();
        }
        return new EntityGender(){

            public boolean contains(IEntity iEntity) {
                if (iEntity.getContainer() == null) {
                    return false;
                }
                return EntityUtils.equals(iEntityMutable, iEntity.getContainer());
            }
        };
    }

    public static EntityGender and(final EntityGender entityGender, final EntityGender entityGender2) {
        return new EntityGender(){

            public boolean contains(IEntity iEntity) {
                return entityGender.contains(iEntity) && entityGender2.contains(iEntity);
            }
        };
    }

    public static EntityGender all() {
        return new EntityGender(){

            public boolean contains(IEntity iEntity) {
                return true;
            }
        };
    }

    public static EntityGender emptyMethods() {
        return new EntityGender(){

            public boolean contains(IEntity iEntity) {
                return iEntity.getMethodsToDisplay().size() == 0;
            }
        };
    }

    public static EntityGender emptyFields() {
        return new EntityGender(){

            public boolean contains(IEntity iEntity) {
                return iEntity.getFieldsToDisplay().size() == 0;
            }
        };
    }

    public static EntityGender emptyMembers() {
        return new EntityGender(){

            public boolean contains(IEntity iEntity) {
                return iEntity.getMethodsToDisplay().size() == 0 && iEntity.getFieldsToDisplay().size() == 0;
            }
        };
    }
}

