/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.cucadiagram.BlockMember;
import net.sourceforge.plantuml.cucadiagram.Bodier;
import net.sourceforge.plantuml.cucadiagram.CrossingType;
import net.sourceforge.plantuml.cucadiagram.EntityFactory;
import net.sourceforge.plantuml.cucadiagram.EntityImpl;
import net.sourceforge.plantuml.cucadiagram.EntityType;
import net.sourceforge.plantuml.cucadiagram.Group;
import net.sourceforge.plantuml.cucadiagram.GroupImpl;
import net.sourceforge.plantuml.cucadiagram.GroupType;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.IEntityMutable;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.Member;
import net.sourceforge.plantuml.cucadiagram.PortionShower;
import net.sourceforge.plantuml.cucadiagram.Rankdir;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.cucadiagram.UnsupportedEntity;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.svek.IEntityImage;
import net.sourceforge.plantuml.svek.PackageStyle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityMutable
implements IEntityMutable {
    private IEntity entity;
    private Bodier bodier;
    private Group group;
    private final EntityFactory entityFactory;
    private boolean isValid = true;
    private String zuid;

    public void invalidateNow() {
        this.isValid = false;
    }

    private void checkValid() {
        if (!this.isValid) {
            // empty if block
        }
    }

    public String toString() {
        if (this.group == null) {
            return super.toString() + " " + this.entity;
        }
        return "GROUP**" + super.toString() + " " + this.entity + " " + this.group;
    }

    @Override
    public boolean isGroup() {
        this.checkValid();
        return this.group != null;
    }

    public CrossingType getCrossingType(Link link) {
        this.checkValid();
        if (this.group == null) {
            throw new IllegalStateException();
        }
        if (link.getEntity1().equals(this) && link.getEntity2().equals(this)) {
            return CrossingType.SELF;
        }
        if (link.getEntity1().equals(this)) {
            if (this.zcontains(link.getEntity2())) {
                return CrossingType.TOUCH_INSIDE;
            }
            return CrossingType.TOUCH_OUTSIDE;
        }
        if (link.getEntity2().equals(this)) {
            if (this.zcontains(link.getEntity1())) {
                return CrossingType.TOUCH_INSIDE;
            }
            return CrossingType.TOUCH_OUTSIDE;
        }
        boolean bl = this.zcontains(link.getEntity1());
        boolean bl2 = this.zcontains(link.getEntity2());
        if (bl && bl2) {
            return CrossingType.INSIDE;
        }
        if (!bl && !bl2) {
            return CrossingType.OUTSIDE;
        }
        return CrossingType.CUT;
    }

    public EntityMutable(EntityImpl entityImpl, EntityFactory entityFactory, Bodier bodier) {
        this.entity = entityImpl;
        this.entityFactory = entityFactory;
        this.bodier = bodier;
    }

    public EntityMutable(GroupImpl groupImpl, EntityFactory entityFactory) {
        this.entity = null;
        this.group = groupImpl;
        this.entityFactory = entityFactory;
    }

    @Override
    public void overideImage42(IEntityImage iEntityImage, List<Url> list) {
        this.entityFactory.overideImage42(this);
        this.entity = new MyEntity42(this.getContainer(), iEntityImage, this.getStereotype(), this.getCode(), list);
        this.group = null;
    }

    @Override
    public void muteToGroup99(Group group) {
        this.checkValid();
        if (this.group != null) {
            throw new IllegalStateException();
        }
        this.group = group;
    }

    public final void zsetEntityCluster(String string) {
        this.checkValid();
        this.zuid = string;
    }

    public void overidesFieldsToDisplay(EntityMutable entityMutable) {
        this.checkValid();
        this.bodier = entityMutable.bodier;
    }

    @Override
    public HtmlColor getSpecificBackColor() {
        this.checkValid();
        return this.entity.getSpecificBackColor();
    }

    @Override
    public void setSpecificBackcolor(HtmlColor htmlColor) {
        this.checkValid();
        this.entity.setSpecificBackcolor(htmlColor);
    }

    @Override
    public Group getContainer() {
        this.checkValid();
        if (this.group != null) {
            if (this == this.group.zgetParent()) {
                throw new IllegalStateException();
            }
            return this.group.zgetParent();
        }
        if (this == this.entity.getContainer()) {
            throw new IllegalStateException();
        }
        return this.entity.getContainer();
    }

    @Override
    public List<? extends CharSequence> getDisplay2() {
        this.checkValid();
        if (this.group != null) {
            return Arrays.asList(this.zgetDisplay());
        }
        return this.entity.getDisplay2();
    }

    @Override
    public EntityType getEntityType() {
        this.checkValid();
        if (this.group != null) {
            return null;
        }
        return this.entity.getEntityType();
    }

    @Override
    public String getUid() {
        this.checkValid();
        if (this.zuid != null) {
            return this.zuid;
        }
        return this.entity.getUid();
    }

    @Override
    public List<Url> getUrls() {
        this.checkValid();
        if (this.entity == null) {
            return null;
        }
        return this.entity.getUrls();
    }

    @Override
    public Stereotype getStereotype() {
        this.checkValid();
        if (this.entity == null) {
            return this.zgetStereotype();
        }
        return this.entity.getStereotype();
    }

    @Override
    public void setStereotype(Stereotype stereotype) {
        this.checkValid();
        this.entity.setStereotype(stereotype);
    }

    @Override
    public BlockMember getBody(PortionShower portionShower) {
        this.checkValid();
        return this.entity.getBody(portionShower);
    }

    @Override
    public String getCode() {
        this.checkValid();
        if (this.entity == null) {
            return this.zgetGroupCode();
        }
        return this.entity.getCode();
    }

    @Override
    public boolean isTop() {
        this.checkValid();
        return this.entity.isTop();
    }

    @Override
    public void setTop(boolean bl) {
        this.checkValid();
        this.entity.setTop(bl);
    }

    @Override
    public boolean hasNearDecoration() {
        this.checkValid();
        if (this.entity == null) {
            return false;
        }
        return this.entity.hasNearDecoration();
    }

    @Override
    public void setNearDecoration(boolean bl) {
        this.checkValid();
        this.entity.setNearDecoration(bl);
    }

    @Override
    public int getXposition() {
        this.checkValid();
        return this.entity.getXposition();
    }

    @Override
    public void setXposition(int n) {
        this.checkValid();
        this.entity.setXposition(n);
    }

    @Override
    public IEntityImage getSvekImage() {
        this.checkValid();
        return this.entity.getSvekImage();
    }

    @Override
    public String getGeneric() {
        this.checkValid();
        return this.entity.getGeneric();
    }

    @Override
    public BlockMember getMouseOver() {
        this.checkValid();
        return this.entity.getMouseOver();
    }

    @Override
    public void muteToType(EntityType entityType) {
        this.checkValid();
        this.entity.muteToType(entityType);
    }

    @Override
    public void setGeneric(String string) {
        this.checkValid();
        this.entity.setGeneric(string);
    }

    @Override
    public void mouseOver(String string) {
        this.checkValid();
        this.entity.mouseOver(string);
    }

    @Override
    public void addUrl(Url url) {
        this.checkValid();
        this.entity.addUrl(url);
    }

    @Override
    public void setSvekImage(IEntityImage iEntityImage) {
        this.checkValid();
        this.entity.setSvekImage(iEntityImage);
    }

    @Override
    public void setDisplay2(String string) {
        this.checkValid();
        this.entity.setDisplay2(string);
    }

    @Override
    public void setContainer(IEntityMutable iEntityMutable) {
        this.checkValid();
        this.entity.setContainer(iEntityMutable);
    }

    @Override
    public boolean zcontains(IEntity iEntity) {
        this.checkValid();
        return this.group.zcontains(iEntity);
    }

    @Override
    public Collection<IEntity> zentities() {
        this.checkValid();
        if (this.group == null) {
            return Collections.emptyList();
        }
        return this.group.zentities();
    }

    @Override
    public int zsize() {
        this.checkValid();
        return this.group.zsize();
    }

    @Override
    public String zgetGroupCode() {
        this.checkValid();
        return this.group.zgetGroupCode();
    }

    @Override
    public String zgetUid() {
        this.checkValid();
        return this.group.zgetUid();
    }

    @Override
    public String zgetUid1() {
        this.checkValid();
        return this.group.zgetUid1();
    }

    @Override
    public int zgetUid2() {
        this.checkValid();
        if (this.group == null) {
            if (this.entity.getContainer() == null) {
                throw new IllegalStateException();
            }
            return this.entity.getContainer().zgetUid2();
        }
        return this.group.zgetUid2();
    }

    @Override
    public HtmlColor zgetBackColor() {
        this.checkValid();
        if (this.group == null) {
            return this.getSpecificBackColor();
        }
        return this.group.zgetBackColor();
    }

    @Override
    public void zsetBackColor(HtmlColor htmlColor) {
        this.checkValid();
        this.group.zsetBackColor(htmlColor);
    }

    @Override
    public Group zgetParent() {
        this.checkValid();
        if (this.group == null) {
            return null;
        }
        return this.group.zgetParent();
    }

    @Override
    public GroupType zgetGroupType() {
        this.checkValid();
        return this.group.zgetGroupType();
    }

    @Override
    public String zgetDisplay() {
        this.checkValid();
        return this.group.zgetDisplay();
    }

    @Override
    public void zmoveEntitiesTo(IEntityMutable iEntityMutable) {
        this.checkValid();
        this.group.zmoveEntitiesTo(iEntityMutable);
    }

    @Override
    public String zgetNamespace() {
        this.checkValid();
        return this.group.zgetNamespace();
    }

    @Override
    public Collection<? extends Group> zgetChildren() {
        this.checkValid();
        return this.group.zgetChildren();
    }

    @Override
    public boolean zisAutonom() {
        this.checkValid();
        return this.group.zisAutonom();
    }

    @Override
    public void zsetAutonom(boolean bl) {
        this.checkValid();
        this.group.zsetAutonom(bl);
    }

    @Override
    public Rankdir zgetRankdir() {
        this.checkValid();
        return this.group.zgetRankdir();
    }

    @Override
    public void zsetRankdir(Rankdir rankdir) {
        this.checkValid();
        this.group.zsetRankdir(rankdir);
    }

    @Override
    public void zsetStereotype(Stereotype stereotype) {
        this.checkValid();
        this.group.zsetStereotype(stereotype);
    }

    @Override
    public PackageStyle zgetPackageStyle() {
        this.checkValid();
        return this.group.zgetPackageStyle();
    }

    @Override
    public Stereotype zgetStereotype() {
        this.checkValid();
        if (this.group == null) {
            return this.getStereotype();
        }
        return this.group.zgetStereotype();
    }

    @Override
    public List<Member> getFieldsToDisplay() {
        this.checkValid();
        return this.bodier.getFieldsToDisplay();
    }

    @Override
    public List<Member> getMethodsToDisplay() {
        this.checkValid();
        return this.bodier.getMethodsToDisplay();
    }

    @Override
    public void addFieldOrMethod(String string) {
        this.checkValid();
        this.bodier.addFieldOrMethod(string);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MyEntity42
    extends UnsupportedEntity {
        private final Group container;
        private final IEntityImage img;
        private final Stereotype stereotype;
        private final String code;
        private final List<Url> url;

        public MyEntity42(Group group, IEntityImage iEntityImage, Stereotype stereotype, String string, List<Url> list) {
            this.container = group;
            this.img = iEntityImage;
            this.code = string;
            this.stereotype = stereotype;
            this.url = list;
        }

        @Override
        public String getCode() {
            return this.code;
        }

        @Override
        public Stereotype getStereotype() {
            return this.stereotype;
        }

        @Override
        public HtmlColor getSpecificBackColor() {
            return null;
        }

        @Override
        public List<Url> getUrls() {
            return this.url;
        }

        @Override
        public EntityType getEntityType() {
            return null;
        }

        @Override
        public boolean isTop() {
            return false;
        }

        @Override
        public IEntityImage getSvekImage() {
            return this.img;
        }

        @Override
        public Group getContainer() {
            return this.container;
        }
    }
}

