/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram.dot;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.OptionFlags;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.cucadiagram.dot.Graphviz;
import net.sourceforge.plantuml.cucadiagram.dot.GraphvizLayoutStrategy;
import net.sourceforge.plantuml.cucadiagram.dot.OS;
import net.sourceforge.plantuml.cucadiagram.dot.ProcessRunner;
import net.sourceforge.plantuml.graphic.GraphicStrings;

class AbstractGraphviz2
implements Graphviz {
    private final OS os;
    private final GraphvizLayoutStrategy strategy;
    private final String dotString;
    private final String[] type;

    AbstractGraphviz2(OS oS, GraphvizLayoutStrategy graphvizLayoutStrategy, String string, String ... stringArray) {
        if (stringArray == null) {
            throw new IllegalArgumentException();
        }
        this.os = oS;
        this.strategy = graphvizLayoutStrategy;
        this.dotString = string;
        this.type = stringArray;
        throw new UnsupportedOperationException("not used yet");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void createFile(OutputStream outputStream) throws IOException, InterruptedException {
        if (this.dotString == null) {
            throw new IllegalArgumentException();
        }
        if (this.illegalDotExe()) {
            this.createPngNoGraphviz(outputStream, new FileFormatOption(FileFormat.valueOf(this.type[0].toUpperCase())));
            return;
        }
        String string = this.getCommandLine();
        ProcessRunner processRunner = null;
        try {
            Log.info("Starting Graphviz process " + string);
            Log.info("DotString size: " + this.dotString.length());
            processRunner = new ProcessRunner(string);
            processRunner.run(this.dotString.getBytes(), outputStream);
            Log.info("Ending process ok");
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Log.error("Error: " + throwable);
            Log.error("The command was " + string);
            Log.error("");
            Log.error("Try java -jar plantuml.jar -testdot to figure out the issue");
            Log.error("");
        }
        finally {
            Log.info("Ending Graphviz process");
        }
        if (OptionFlags.getInstance().isCheckDotError() && processRunner != null && processRunner.getError().length() > 0) {
            Log.error("GraphViz error stream : " + processRunner.getError());
            if (OptionFlags.getInstance().isCheckDotError()) {
                throw new IllegalStateException("Dot error " + processRunner.getError());
            }
        }
        if (OptionFlags.getInstance().isCheckDotError() && processRunner != null && processRunner.getOut().length() > 0) {
            Log.error("GraphViz out stream : " + processRunner.getOut());
            if (OptionFlags.getInstance().isCheckDotError()) {
                throw new IllegalStateException("Dot out " + processRunner.getOut());
            }
        }
    }

    private String getCommandLine() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.os.getCommand(this.strategy));
        this.appendImageType(stringBuilder);
        return stringBuilder.toString();
    }

    public String dotVersion() throws IOException, InterruptedException {
        String string = this.os.getCommand(this.strategy) + " -V";
        return this.executeCmd(string);
    }

    public File getDotExe() {
        return this.os.getExecutable(this.strategy);
    }

    private boolean illegalDotExe() {
        File file = this.getDotExe();
        return file == null || !file.isFile() || !file.canRead();
    }

    private String executeCmd(String string) throws IOException, InterruptedException {
        ProcessRunner processRunner = new ProcessRunner(string);
        processRunner.run(null, null);
        StringBuilder stringBuilder = new StringBuilder();
        if (StringUtils.isNotEmpty(processRunner.getOut())) {
            stringBuilder.append(processRunner.getOut());
        }
        if (StringUtils.isNotEmpty(processRunner.getError())) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(processRunner.getError());
        }
        return stringBuilder.toString().replace('\n', ' ').trim();
    }

    private final void createPngNoGraphviz(OutputStream outputStream, FileFormatOption fileFormatOption) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        File file = this.getDotExe();
        arrayList.add("Dot Executable: " + file);
        if (file != null) {
            if (!file.exists()) {
                arrayList.add("File does not exist");
            } else if (file.isDirectory()) {
                arrayList.add("It should be an executable, not a directory");
            } else if (!file.isFile()) {
                arrayList.add("Not a valid file");
            } else if (!file.canRead()) {
                arrayList.add("File cannot be read");
            }
        }
        arrayList.add("Cannot find Graphviz. You should try");
        arrayList.add(" ");
        arrayList.add("@startuml");
        arrayList.add("testdot");
        arrayList.add("@enduml");
        arrayList.add(" ");
        arrayList.add(" or ");
        arrayList.add(" ");
        arrayList.add("java -jar plantuml.jar -testdot");
        GraphicStrings graphicStrings = new GraphicStrings(arrayList);
        graphicStrings.writeImage(outputStream, fileFormatOption);
    }

    private final void appendImageType(StringBuilder stringBuilder) {
        for (String string : this.type) {
            stringBuilder.append(" -T" + string + " ");
        }
    }

    public String testFile(String string, String string2) throws IOException, InterruptedException {
        throw new UnsupportedOperationException();
    }
}

