/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram.dot;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.EmptyImageBuilder;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.cucadiagram.CucaDiagram;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.graph.ANodeImpl;
import net.sourceforge.plantuml.graph.Board;
import net.sourceforge.plantuml.graph.BoardExplorer;
import net.sourceforge.plantuml.graph.Graph2;
import net.sourceforge.plantuml.graph.Heap;
import net.sourceforge.plantuml.graph.Zoda1;
import net.sourceforge.plantuml.graph.Zoda2;
import net.sourceforge.plantuml.png.PngSplitter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CucaDiagramPngMaker2 {
    private final CucaDiagram diagram;

    public CucaDiagramPngMaker2(CucaDiagram cucaDiagram) {
        this.diagram = cucaDiagram;
    }

    public void createPng(OutputStream outputStream) throws IOException {
        Object object;
        Zoda2 zoda2 = new Zoda2();
        for (Link object22 : this.diagram.getLinks()) {
            object = object22.getEntity1().getCode() + "->" + object22.getEntity2().getCode();
            Log.println("CucaDiagramPngMaker2:: " + (String)object);
            int n = object22.getLength() - 1;
            Log.println("CucaDiagramPngMaker2:: " + (String)object + " " + n);
            zoda2.addLink((String)object, n, object22);
        }
        for (IEntity iEntity : this.diagram.getEntities().values()) {
            object = zoda2.getNode(iEntity.getCode());
            if (object == null) {
                object = zoda2.createAloneNode(iEntity.getCode());
            }
            ((ANodeImpl)object).setUserData(iEntity);
        }
        List<Graph2> list = this.getGraphs2(zoda2.getHeaps());
        Dimension2D dimension2D = this.getTotalDimension(list);
        object = new EmptyImageBuilder(dimension2D.getWidth(), dimension2D.getHeight(), Color.WHITE);
        double d = 0.0;
        Graphics2D graphics2D = ((EmptyImageBuilder)object).getGraphics2D();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Graph2 graph2 = (Graph2)iterator.next();
            graphics2D.setTransform(new AffineTransform());
            graphics2D.translate(d, 0.0);
            graph2.draw(graphics2D);
            d += graph2.getDimension().getWidth();
        }
        ImageIO.write((RenderedImage)((EmptyImageBuilder)object).getBufferedImage(), "png", outputStream);
    }

    private Dimension2D getTotalDimension(List<Graph2> list) {
        double d = 0.0;
        double d2 = 0.0;
        for (Graph2 graph2 : list) {
            d += graph2.getDimension().getWidth();
            d2 = Math.max(d2, graph2.getDimension().getHeight());
        }
        return new Dimension2DDouble(d, d2);
    }

    private List<Graph2> getGraphs2(Collection<Heap> collection) {
        ArrayList<Graph2> arrayList = new ArrayList<Graph2>();
        for (Heap heap : collection) {
            boolean bl;
            heap.computeRows();
            Board board = new Board(heap.getNodes(), heap.getLinks());
            BoardExplorer boardExplorer = new BoardExplorer(board);
            long l = System.currentTimeMillis();
            for (int i = 0; i < 400 && !(bl = boardExplorer.onePass()); ++i) {
                if (i % 100 != 0) continue;
                Log.info("" + i + " boardExplorer.getBestCost()=" + boardExplorer.getBestCost() + " " + boardExplorer.collectionSize());
            }
            Log.info("################# DURATION = " + (System.currentTimeMillis() - l));
            board = boardExplorer.getBestBoard();
            arrayList.add(new Graph2(board));
        }
        return arrayList;
    }

    private void createPngOld(OutputStream outputStream) throws IOException {
        Object object;
        Zoda1 zoda1 = new Zoda1();
        if (this.diagram.getLinks().size() == 0) {
            return;
        }
        for (Link object2 : this.diagram.getLinks()) {
            object = object2.getEntity1().getCode() + "->" + object2.getEntity2().getCode();
            zoda1.addLink((String)object);
        }
        for (IEntity iEntity : this.diagram.getEntities().values()) {
            object = zoda1.getExistingNode(iEntity.getCode());
            ((ANodeImpl)object).setUserData(iEntity);
        }
        zoda1.computeRows();
        Board board = new Board(zoda1.getNodes(), zoda1.getLinks());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<File> createPng(File file) throws IOException {
        OutputStream outputStream = null;
        try {
            outputStream = new BufferedOutputStream(new FileOutputStream(file));
            this.createPng(outputStream);
        }
        finally {
            if (outputStream != null) {
                outputStream.close();
            }
        }
        return new PngSplitter(file, this.diagram.getHorizontalPages(), this.diagram.getVerticalPages(), this.diagram.getMetadata(), 96).getFiles();
    }
}

