/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram.dot;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.RectangularShape;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.cucadiagram.EntityType;
import net.sourceforge.plantuml.cucadiagram.EntityUtils;
import net.sourceforge.plantuml.cucadiagram.Group;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.IEntityMutable;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.LinkType;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignement;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.posimo.Block;
import net.sourceforge.plantuml.posimo.Cluster;
import net.sourceforge.plantuml.posimo.EntityImageBlock;
import net.sourceforge.plantuml.posimo.EntityImageClass2;
import net.sourceforge.plantuml.posimo.EntityImageNote2;
import net.sourceforge.plantuml.posimo.Frame;
import net.sourceforge.plantuml.posimo.GraphvizSolverB;
import net.sourceforge.plantuml.posimo.IEntityImageBlock;
import net.sourceforge.plantuml.posimo.Label;
import net.sourceforge.plantuml.posimo.LabelImage;
import net.sourceforge.plantuml.posimo.MargedBlock;
import net.sourceforge.plantuml.posimo.Path;
import net.sourceforge.plantuml.posimo.PathDrawerInterface;
import net.sourceforge.plantuml.posimo.PositionableUtils;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PlayField {
    private final Rose rose = new Rose();
    private final ISkinParam skinParam;
    private final Cluster root = new Cluster(null, 0.0, 0.0);
    private final Map<Path, Link> paths = new LinkedHashMap<Path, Link>();
    private final Map<IEntity, MargedBlock> blocks = new HashMap<IEntity, MargedBlock>();
    private final Map<IEntity, Cluster> clusters = new HashMap<IEntity, Cluster>();
    private final Map<IEntity, Frame> frames = new HashMap<IEntity, Frame>();
    private final double marginLabel = 6.0;
    private final UFont fontQualif;

    public PlayField(ISkinParam iSkinParam) {
        this.skinParam = iSkinParam;
        this.fontQualif = iSkinParam.getFont(FontParam.CLASS_ARROW, null);
    }

    public void initInternal(Collection<IEntity> collection, Collection<Link> collection2, StringBounder stringBounder) {
        Object object;
        Object object2;
        Object object3;
        if (this.blocks.size() != 0 || this.paths.size() != 0 || this.clusters.size() != 0) {
            throw new IllegalStateException();
        }
        if (collection.size() != new HashSet<IEntity>(collection).size()) {
            throw new IllegalArgumentException("Duplicate entities");
        }
        if (collection2.size() != new HashSet<Link>(collection2).size()) {
            throw new IllegalArgumentException("Duplicate entities");
        }
        for (IEntity object4 : collection) {
            if (!((IEntityMutable)object4).isGroup() || ((Group)((Object)object4)).zisAutonom()) continue;
            object3 = new Frame(object4.getDisplay2(), this.skinParam);
            this.frames.put(object4, (Frame)object3);
            object2 = ((Frame)object3).getTextDim(stringBounder);
            this.clusters.put(object4, new Cluster(this.root, ((Dimension2D)object2).getWidth(), ((Dimension2D)object2).getHeight()));
        }
        for (IEntity iEntity : collection) {
            if (((IEntityMutable)iEntity).isGroup() && !((Group)((Object)iEntity)).zisAutonom()) {
                assert (this.clusters.containsKey(iEntity));
                continue;
            }
            assert (!this.clusters.containsKey(iEntity));
            object3 = this.root;
            if (!((IEntityMutable)iEntity).isGroup() && iEntity.getContainer() != null && (object3 = this.clusters.get(iEntity.getContainer())) == null) {
                object3 = this.root;
            }
            object2 = this.createEntityImageBlock(collection2, iEntity);
            object = new MargedBlock(stringBounder, (IEntityImageBlock)object2, this.getMargin(stringBounder, iEntity, collection2), (Cluster)object3);
            this.blocks.put(iEntity, (MargedBlock)object);
            ((Cluster)object3).addBloc(((MargedBlock)object).getBlock());
        }
        for (Cluster cluster : this.clusters.values()) {
            if (cluster.getContents().size() != 0) continue;
        }
        for (Link link : collection2) {
            Object object4;
            if (!collection.contains(link.getEntity1()) || !collection.contains(link.getEntity2())) continue;
            object3 = this.getToto(link.getEntity1());
            object2 = this.getToto(link.getEntity2());
            if (link.getLabel() == null) {
                object = null;
            } else {
                object4 = new LabelImage(link, this.rose, this.skinParam);
                Dimension2D dimension2D = Dimension2DDouble.delta(((LabelImage)object4).getDimension(stringBounder), 6.0);
                object = new Label(dimension2D.getWidth(), dimension2D.getHeight());
            }
            object4 = new Path((Block)object3, (Block)object2, (Label)object, link.getLength());
            this.paths.put((Path)object4, link);
        }
    }

    private double getMargin(StringBounder stringBounder, IEntity iEntity, Collection<Link> collection) {
        double d = 0.0;
        for (Link link : collection) {
            if (link.getEntity2() == iEntity) {
                d = Math.max(d, link.getMarginDecors2(stringBounder, this.fontQualif, this.skinParam));
            }
            if (link.getEntity1() != iEntity) continue;
            d = Math.max(d, link.getMarginDecors1(stringBounder, this.fontQualif, this.skinParam));
        }
        return d;
    }

    private Block getToto(IEntity iEntity) {
        MargedBlock margedBlock = this.blocks.get(iEntity);
        if (margedBlock != null) {
            return margedBlock.getBlock();
        }
        if (!this.clusters.containsKey(iEntity)) {
            throw new IllegalArgumentException();
        }
        return this.blocks.get(this.getOneOf(EntityUtils.getContainerOrEquivalent(iEntity))).getBlock();
    }

    private IEntity getOneOf(Group group) {
        assert (group != null);
        return group.zentities().iterator().next();
    }

    public void drawInternal(UGraphic uGraphic) {
        Object object;
        Object object2;
        for (Map.Entry<IEntity, Cluster> entry : this.clusters.entrySet()) {
            object2 = this.frames.get(entry.getKey());
            object = PositionableUtils.convert(entry.getValue());
            double d = uGraphic.getTranslateX();
            double d2 = uGraphic.getTranslateY();
            uGraphic.translate(((RectangularShape)object).getX(), ((RectangularShape)object).getY());
            ((Frame)object2).drawU(uGraphic, new Area(new Dimension2DDouble(((RectangularShape)object).getWidth(), ((RectangularShape)object).getHeight())), null);
            uGraphic.setTranslate(d, d2);
        }
        for (Map.Entry<Object, Object> entry : this.paths.entrySet()) {
            object2 = ((Link)entry.getValue()).getType();
            object = PathDrawerInterface.create(this.skinParam, (LinkType)object2);
            Path path = (Path)entry.getKey();
            uGraphic.getParam().setColor(this.rose.getHtmlColor(this.skinParam, ColorParam.classBorder));
            if (path.getLabel() == null) continue;
            uGraphic.getParam().setColor(HtmlColorUtils.BLACK);
            this.drawLabel(uGraphic, path);
        }
        for (Map.Entry<Object, Object> entry : this.blocks.entrySet()) {
            object2 = (MargedBlock)entry.getValue();
            object = ((MargedBlock)object2).getImagePosition().getPosition();
            ((MargedBlock)object2).getImageBlock().drawU(uGraphic, ((Point2D)object).getX(), ((Point2D)object).getY(), 0.0, 0.0);
        }
        for (Map.Entry<Object, Object> entry : this.paths.entrySet()) {
            Object object3;
            Object object4;
            object2 = (Link)entry.getValue();
            object = ((Link)object2).getType();
            PathDrawerInterface pathDrawerInterface = PathDrawerInterface.create(this.skinParam, (LinkType)object);
            Path path = (Path)entry.getKey();
            uGraphic.getParam().setColor(this.rose.getHtmlColor(this.skinParam, ColorParam.classBorder));
            pathDrawerInterface.drawPathAfter(uGraphic, this.getMargedBlock(path.getStart()).getImagePosition(), this.getMargedBlock(path.getEnd()).getImagePosition(), path);
            String string = ((Link)object2).getQualifier1();
            if (string != null) {
                object4 = TextBlockUtils.create(Arrays.asList(string), new FontConfiguration(this.fontQualif, this.skinParam.getFontHtmlColor(FontParam.CLASS_ARROW, null)), HorizontalAlignement.LEFT, this.skinParam);
                object3 = path.getDotPath().getStartPoint();
                object4.drawU(uGraphic, ((Point2D)object3).getX(), ((Point2D)object3).getY());
            }
            if ((object4 = ((Link)object2).getQualifier2()) == null) continue;
            object3 = TextBlockUtils.create(Arrays.asList(object4), new FontConfiguration(this.fontQualif, this.skinParam.getFontHtmlColor(FontParam.CLASS_ARROW, null)), HorizontalAlignement.LEFT, this.skinParam);
            Point2D point2D = path.getDotPath().getEndPoint();
            object3.drawU(uGraphic, point2D.getX(), point2D.getY());
        }
    }

    private MargedBlock getMargedBlock(Block block) {
        for (MargedBlock margedBlock : this.blocks.values()) {
            if (margedBlock.getBlock() != block) continue;
            return margedBlock;
        }
        throw new IllegalArgumentException();
    }

    public Dimension2D solve() throws IOException, InterruptedException {
        GraphvizSolverB graphvizSolverB = new GraphvizSolverB();
        Dimension2D dimension2D = Dimension2DDouble.delta(graphvizSolverB.solve(this.root, this.paths.keySet()), 20.0);
        return dimension2D;
    }

    private void drawLabel(UGraphic uGraphic, Path path) {
        Label label = path.getLabel();
        Point2D point2D = label.getPosition();
        LabelImage labelImage = new LabelImage(this.paths.get(path), this.rose, this.skinParam);
        labelImage.drawU(uGraphic, point2D.getX(), point2D.getY());
    }

    private IEntityImageBlock createEntityImageBlock(Collection<Link> collection, IEntity iEntity) {
        if (iEntity.getEntityType() == EntityType.CLASS || iEntity.getEntityType() == EntityType.ABSTRACT_CLASS || iEntity.getEntityType() == EntityType.INTERFACE || iEntity.getEntityType() == EntityType.ENUM) {
            return new EntityImageClass2(iEntity, this.skinParam, collection);
        }
        if (iEntity.getEntityType() == EntityType.NOTE) {
            return new EntityImageNote2(iEntity, this.skinParam, collection);
        }
        return new EntityImageBlock(iEntity, this.rose, this.skinParam, collection, FontParam.PACKAGE);
    }

    private IEntityImageBlock createClusterTitle() {
        return null;
    }
}

